/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.core;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import org.apache.ojb.broker.Identity;
import org.apache.ojb.broker.IdentityFactory;
import org.apache.ojb.broker.ManageableCollection;
import org.apache.ojb.broker.MtoNImplementor;
import org.apache.ojb.broker.PBKey;
import org.apache.ojb.broker.PBState;
import org.apache.ojb.broker.PersistenceBrokerException;
import org.apache.ojb.broker.TransactionAbortedException;
import org.apache.ojb.broker.TransactionInProgressException;
import org.apache.ojb.broker.TransactionNotInProgressException;
import org.apache.ojb.broker.accesslayer.ChainingIterator;
import org.apache.ojb.broker.accesslayer.ConnectionManagerFactory;
import org.apache.ojb.broker.accesslayer.ConnectionManagerIF;
import org.apache.ojb.broker.accesslayer.JdbcAccess;
import org.apache.ojb.broker.accesslayer.JdbcAccessFactory;
import org.apache.ojb.broker.accesslayer.OJBIterator;
import org.apache.ojb.broker.accesslayer.PagingIterator;
import org.apache.ojb.broker.accesslayer.PkEnumeration;
import org.apache.ojb.broker.accesslayer.StatementManagerFactory;
import org.apache.ojb.broker.accesslayer.StatementManagerIF;
import org.apache.ojb.broker.accesslayer.sql.SqlGenerator;
import org.apache.ojb.broker.accesslayer.sql.SqlGeneratorFactory;
import org.apache.ojb.broker.cache.InternalCache;
import org.apache.ojb.broker.cache.ObjectCache;
import org.apache.ojb.broker.cache.ObjectCacheFactory;
import org.apache.ojb.broker.core.IdentityFactoryImpl;
import org.apache.ojb.broker.core.MtoNBroker;
import org.apache.ojb.broker.core.PersistenceBrokerAbstractImpl;
import org.apache.ojb.broker.core.PersistenceBrokerFactoryIF;
import org.apache.ojb.broker.core.QueryReferenceBroker;
import org.apache.ojb.broker.core.ReportRsIteratorFactoryImpl;
import org.apache.ojb.broker.core.RsIteratorFactory;
import org.apache.ojb.broker.core.RsIteratorFactoryImpl;
import org.apache.ojb.broker.core.ValueContainer;
import org.apache.ojb.broker.core.proxy.CollectionProxyDefaultImpl;
import org.apache.ojb.broker.core.proxy.ProxyHelper;
import org.apache.ojb.broker.metadata.ClassDescriptor;
import org.apache.ojb.broker.metadata.ClassNotPersistenceCapableException;
import org.apache.ojb.broker.metadata.CollectionDescriptor;
import org.apache.ojb.broker.metadata.DescriptorRepository;
import org.apache.ojb.broker.metadata.FieldDescriptor;
import org.apache.ojb.broker.metadata.MetadataManager;
import org.apache.ojb.broker.metadata.ObjectReferenceDescriptor;
import org.apache.ojb.broker.metadata.fieldaccess.PersistentField;
import org.apache.ojb.broker.query.QueryByIdentity;
import org.apache.ojb.broker.query.QueryBySQL;
import org.apache.ojb.broker.util.BrokerHelper;
import org.apache.ojb.broker.util.IdentityArrayList;
import org.apache.ojb.broker.util.ObjectModification;
import org.apache.ojb.broker.util.logging.Logger;
import org.apache.ojb.broker.util.logging.LoggerFactory;
import org.apache.ojb.broker.util.sequence.SequenceManager;
import org.apache.ojb.broker.util.sequence.SequenceManagerException;
import org.apache.ojb.broker.util.sequence.SequenceManagerFactory;
import org.apache.ojb.soda.QueryImpl;
import org.odbms.Query;

public class PersistenceBrokerImpl
extends PersistenceBrokerAbstractImpl
implements PBState {
    private Logger logger = LoggerFactory.getLogger(class$org$apache$ojb$broker$core$PersistenceBrokerImpl == null ? (class$org$apache$ojb$broker$core$PersistenceBrokerImpl = PersistenceBrokerImpl.class$("org.apache.ojb.broker.core.PersistenceBrokerImpl")) : class$org$apache$ojb$broker$core$PersistenceBrokerImpl);
    protected PersistenceBrokerFactoryIF pbf;
    protected BrokerHelper brokerHelper;
    protected MtoNBroker mtoNBroker;
    protected QueryReferenceBroker referencesBroker;
    private boolean isClosed;
    private boolean inTransaction;
    private InternalCache objectCache;
    private JdbcAccess dbAccess;
    private DescriptorRepository descriptorRepository = null;
    private ConnectionManagerIF connectionManager = null;
    private SequenceManager sequenceManager = null;
    private StatementManagerIF statementManager = null;
    private SqlGenerator sqlGenerator;
    private IdentityFactory identityFactory;
    private PBKey pbKey;
    private List nowStoring = new IdentityArrayList();
    private List markedForDelete = new IdentityArrayList();
    private Set deletedDuringTransaction = new HashSet();
    static /* synthetic */ Class class$org$apache$ojb$broker$core$PersistenceBrokerImpl;

    public PersistenceBrokerImpl(PBKey pBKey, PersistenceBrokerFactoryIF persistenceBrokerFactoryIF) {
        this.refresh();
        if (pBKey == null) {
            throw new PersistenceBrokerException("Could not instantiate broker with PBKey 'null'");
        }
        this.pbf = persistenceBrokerFactoryIF;
        this.pbKey = pBKey;
        this.brokerHelper = new BrokerHelper(this);
        this.connectionManager = ConnectionManagerFactory.getInstance().createConnectionManager(this);
        this.objectCache = new InternalCache(ObjectCacheFactory.getInstance().createObjectCache(this));
        this.sequenceManager = SequenceManagerFactory.getSequenceManager(this);
        this.dbAccess = JdbcAccessFactory.getInstance().createJdbcAccess(this);
        this.statementManager = StatementManagerFactory.getInstance().createStatementManager(this);
        this.sqlGenerator = SqlGeneratorFactory.getInstance().createSqlGenerator(this.connectionManager.getSupportedPlatform());
        this.mtoNBroker = new MtoNBroker(this);
        this.referencesBroker = new QueryReferenceBroker(this);
        this.identityFactory = new IdentityFactoryImpl(this);
    }

    public InternalCache getInternalCache() {
        return this.objectCache;
    }

    public IdentityFactory serviceIdentity() {
        return this.identityFactory;
    }

    public SqlGenerator serviceSqlGenerator() {
        return this.sqlGenerator;
    }

    public StatementManagerIF serviceStatementManager() {
        return this.statementManager;
    }

    public JdbcAccess serviceJdbcAccess() {
        return this.dbAccess;
    }

    public ConnectionManagerIF serviceConnectionManager() {
        return this.connectionManager;
    }

    public SequenceManager serviceSequenceManager() {
        return this.sequenceManager;
    }

    public BrokerHelper serviceBrokerHelper() {
        return this.brokerHelper;
    }

    public ObjectCache serviceObjectCache() {
        return this.objectCache;
    }

    public QueryReferenceBroker getReferenceBroker() {
        return this.referencesBroker;
    }

    public boolean isClosed() {
        return this.isClosed;
    }

    public void setClosed(boolean bl) {
        if (!bl) {
            this.refresh();
        }
        this.isClosed = bl;
    }

    public void refresh() {
        this.setInTransaction(false);
        this.descriptorRepository = MetadataManager.getInstance().getRepository();
    }

    public void destroy() {
        this.removeAllListeners();
        if (this.connectionManager != null) {
            if (this.connectionManager.isInLocalTransaction()) {
                this.connectionManager.localRollback();
            }
            this.connectionManager.releaseConnection();
        }
        this.setClosed(true);
        this.descriptorRepository = null;
        this.pbKey = null;
        this.pbf = null;
        this.connectionManager = null;
        this.dbAccess = null;
        this.objectCache = null;
        this.sequenceManager = null;
        this.sqlGenerator = null;
        this.statementManager = null;
    }

    public PBKey getPBKey() {
        return this.pbKey;
    }

    public void setPBKey(PBKey pBKey) {
        this.pbKey = pBKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean close() {
        if (this.isInTransaction()) {
            this.logger.error("Broker is still in PB-transaction, do automatic abort before close!");
            this.abortTransaction();
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("PB.close was called: " + this);
        }
        try {
            this.fireBrokerEvent(this.BEFORE_CLOSE_EVENT);
            this.clearRegistrationLists();
            this.referencesBroker.removePrefetchingListeners();
            if (this.connectionManager != null) {
                this.connectionManager.releaseConnection();
                this.connectionManager.setBatchMode(false);
            }
            this.removeAllListeners();
        }
        finally {
            this.descriptorRepository = null;
            this.setClosed(true);
        }
        return true;
    }

    public synchronized void abortTransaction() throws TransactionNotInProgressException {
        if (this.isInTransaction()) {
            this.fireBrokerEvent(this.BEFORE_ROLLBACK_EVENT);
            this.setInTransaction(false);
            this.clearRegistrationLists();
            this.referencesBroker.removePrefetchingListeners();
            if (this.connectionManager.isInLocalTransaction()) {
                this.connectionManager.localRollback();
            }
            this.fireBrokerEvent(this.AFTER_ROLLBACK_EVENT);
        }
    }

    public synchronized void beginTransaction() throws TransactionInProgressException, TransactionAbortedException {
        if (this.isInTransaction()) {
            throw new TransactionInProgressException("PersistenceBroker is already in transaction");
        }
        this.fireBrokerEvent(this.BEFORE_BEGIN_EVENT);
        this.setInTransaction(true);
        this.connectionManager.localBegin();
        this.fireBrokerEvent(this.AFTER_BEGIN_EVENT);
    }

    public synchronized void commitTransaction() throws TransactionNotInProgressException, TransactionAbortedException {
        if (!this.isInTransaction()) {
            throw new TransactionNotInProgressException("PersistenceBroker is NOT in transaction, can't commit");
        }
        this.fireBrokerEvent(this.BEFORE_COMMIT_EVENT);
        this.setInTransaction(false);
        this.clearRegistrationLists();
        this.referencesBroker.removePrefetchingListeners();
        if (this.connectionManager.isInLocalTransaction()) {
            this.connectionManager.localCommit();
        }
        this.fireBrokerEvent(this.AFTER_COMMIT_EVENT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(Object object) throws PersistenceBrokerException {
        if (!this.isInTransaction()) {
            this.logger.warn("No running tx found, please only delete objects in context of an PB-transaction, to avoid side-effects - e.g. when rollback of complex objects");
        }
        try {
            this.doDelete(object);
        }
        finally {
            this.markedForDelete.clear();
        }
    }

    private void doDelete(Object object) throws PersistenceBrokerException {
        if (object != null) {
            if (this.markedForDelete.contains(object = ProxyHelper.getRealObject(object))) {
                return;
            }
            this.markedForDelete.add(object);
            ClassDescriptor classDescriptor = this.getClassDescriptor(object.getClass());
            Identity identity = new Identity(object, this, classDescriptor);
            this.BEFORE_DELETE_EVENT.setTarget(object);
            this.fireBrokerEvent(this.BEFORE_DELETE_EVENT);
            this.BEFORE_DELETE_EVENT.setTarget(null);
            if (classDescriptor.getCollectionDescriptors().size() > 0) {
                this.deleteCollections(object, classDescriptor.getCollectionDescriptors());
            }
            this.dbAccess.executeDelete(classDescriptor, object);
            this.deletedDuringTransaction.add(identity);
            if (classDescriptor.getObjectReferenceDescriptors().size() > 0) {
                this.deleteReferences(object, classDescriptor.getObjectReferenceDescriptors());
            }
            this.objectCache.remove(identity);
            this.AFTER_DELETE_EVENT.setTarget(object);
            this.fireBrokerEvent(this.AFTER_DELETE_EVENT);
            this.AFTER_DELETE_EVENT.setTarget(null);
            this.connectionManager.executeBatchIfNecessary();
        }
    }

    private void deleteByQuery(org.apache.ojb.broker.query.Query query, ClassDescriptor classDescriptor) throws PersistenceBrokerException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("deleteByQuery " + classDescriptor.getClassNameOfObject() + ", " + query);
        }
        if (query instanceof QueryBySQL) {
            String string = ((QueryBySQL)query).getSql();
            this.dbAccess.executeUpdateSQL(string, classDescriptor);
        } else {
            Iterator iterator;
            Object object;
            if (query instanceof QueryByIdentity) {
                object = (QueryByIdentity)query;
                iterator = ((QueryByIdentity)object).getExampleObject();
                if (!(iterator instanceof Identity)) {
                    iterator = new Identity(iterator, this);
                }
                query = this.referencesBroker.getPKQuery((Identity)((Object)iterator));
            }
            if (!classDescriptor.isInterface()) {
                this.dbAccess.executeDelete(query, classDescriptor);
            }
            object = classDescriptor.getFullTableName();
            if (classDescriptor.isExtent()) {
                iterator = this.getDescriptorRepository().getAllConcreteSubclassDescriptors(classDescriptor).iterator();
                while (iterator.hasNext()) {
                    ClassDescriptor classDescriptor2 = (ClassDescriptor)iterator.next();
                    if (classDescriptor2.getFullTableName().equals(object)) continue;
                    object = classDescriptor2.getFullTableName();
                    this.dbAccess.executeDelete(query, classDescriptor2);
                }
            }
        }
    }

    public void deleteByQuery(org.apache.ojb.broker.query.Query query) throws PersistenceBrokerException {
        ClassDescriptor classDescriptor = this.getClassDescriptor(query.getSearchClass());
        this.deleteByQuery(query, classDescriptor);
    }

    private void deleteReferences(Object object, List list) throws PersistenceBrokerException {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Object object2;
            ObjectReferenceDescriptor objectReferenceDescriptor = (ObjectReferenceDescriptor)iterator.next();
            if (objectReferenceDescriptor.getCascadingDelete() != 23 || (object2 = objectReferenceDescriptor.getPersistentField().get(object)) == null) continue;
            this.doDelete(object2);
        }
    }

    private void deleteCollections(Object object, List list) throws PersistenceBrokerException {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Object object2;
            CollectionDescriptor collectionDescriptor = (CollectionDescriptor)iterator.next();
            if (collectionDescriptor.getCascadingDelete() == 17) continue;
            if (collectionDescriptor.isMtoNRelation()) {
                this.mtoNBroker.deleteMtoNImplementor(collectionDescriptor, object);
            }
            if (collectionDescriptor.getCascadingDelete() != 23 || (object2 = collectionDescriptor.getPersistentField().get(object)) == null) continue;
            Iterator iterator2 = BrokerHelper.getCollectionIterator(object2);
            while (iterator2.hasNext()) {
                this.doDelete(iterator2.next());
            }
        }
    }

    public void store(Object object) throws PersistenceBrokerException {
        if (object != null && !this.nowStoring.contains(object)) {
            if ((object = ProxyHelper.getRealObjectIfMaterialized(object)) == null) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("No materialized object could be found -> nothing to store");
                }
                return;
            }
            ClassDescriptor classDescriptor = this.getClassDescriptor(object.getClass());
            boolean bl = this.serviceBrokerHelper().hasNullPKField(classDescriptor, object);
            Identity identity = new Identity(object, this, classDescriptor);
            boolean bl2 = false;
            if (!bl) {
                bl = this.deletedDuringTransaction.contains(identity);
                bl2 = true;
                if (!bl) {
                    bl = this.objectCache.lookup(identity) == null && !this.serviceBrokerHelper().doesExist(classDescriptor, identity, object);
                }
            }
            this.store(object, identity, classDescriptor, bl);
            if (bl2) {
                this.deletedDuringTransaction.remove(identity);
            }
        } else {
            return;
        }
        this.connectionManager.executeBatchIfNecessary();
    }

    private void storeReferences(Object object, ClassDescriptor classDescriptor, boolean bl) {
        Vector vector = classDescriptor.getObjectReferenceDescriptors();
        if (vector.size() == 0) {
            return;
        }
        Iterator iterator = vector.iterator();
        while (iterator.hasNext()) {
            ObjectReferenceDescriptor objectReferenceDescriptor = (ObjectReferenceDescriptor)iterator.next();
            if (objectReferenceDescriptor.getCascadingStore() == 17) continue;
            this.storeAndLinkOneToOne(false, object, classDescriptor, objectReferenceDescriptor, bl);
        }
    }

    private void storeAndLinkOneToOne(boolean bl, Object object, ClassDescriptor classDescriptor, ObjectReferenceDescriptor objectReferenceDescriptor, boolean bl2) {
        Object object2 = objectReferenceDescriptor.getPersistentField().get(object);
        if (!bl && objectReferenceDescriptor.getCascadingStore() == 23) {
            this.store(object2);
        } else if (this.logger.isEnabledFor(2)) {
            this.logger.info("Cascade store for this reference-descriptor (" + objectReferenceDescriptor.getAttributeName() + ") was set to false.");
        }
        this.link(object, classDescriptor, objectReferenceDescriptor, object2, bl2);
    }

    private void storeCollections(Object object, ClassDescriptor classDescriptor, boolean bl) throws PersistenceBrokerException {
        Vector vector = classDescriptor.getCollectionDescriptors();
        if (vector.size() == 0) {
            return;
        }
        Iterator iterator = vector.iterator();
        while (iterator.hasNext()) {
            CollectionDescriptor collectionDescriptor = (CollectionDescriptor)iterator.next();
            if (collectionDescriptor.getCascadingStore() == 17) continue;
            Object object2 = collectionDescriptor.getPersistentField().get(object);
            if (collectionDescriptor.isMtoNRelation()) {
                this.storeAndLinkMtoN(false, object, collectionDescriptor, object2, bl);
            } else {
                this.storeAndLinkOneToMany(false, object, collectionDescriptor, object2, bl);
            }
            if (collectionDescriptor.getCascadingStore() != 23 || !(object2 instanceof ManageableCollection)) continue;
            ((ManageableCollection)object2).afterStore(this);
        }
    }

    private void storeAndLinkMtoN(boolean bl, Object object, CollectionDescriptor collectionDescriptor, Object object2, boolean bl2) {
        if (bl2 || !(object2 instanceof CollectionProxyDefaultImpl) || ((CollectionProxyDefaultImpl)object2).isLoaded()) {
            Iterator iterator;
            if (object2 == null) {
                object2 = Collections.EMPTY_LIST;
            }
            if (!(iterator = BrokerHelper.getCollectionIterator(object2)).hasNext()) {
                this.mtoNBroker.deleteMtoNImplementor(collectionDescriptor, object);
            } else {
                Collection collection;
                if (bl2) {
                    collection = Collections.EMPTY_LIST;
                } else {
                    collection = this.mtoNBroker.getMtoNImplementor(collectionDescriptor, object);
                    this.mtoNBroker.deleteMtoNImplementor(collectionDescriptor, object, iterator, collection);
                }
                iterator = BrokerHelper.getCollectionIterator(object2);
                while (iterator.hasNext()) {
                    Object e = iterator.next();
                    if (!bl && collectionDescriptor.getCascadingStore() == 23) {
                        this.store(e);
                        collection = this.mtoNBroker.getMtoNImplementor(collectionDescriptor, object);
                    }
                    this.mtoNBroker.storeMtoNImplementor(collectionDescriptor, object, e, collection);
                }
            }
        }
    }

    private void storeAndLinkOneToMany(boolean bl, Object object, CollectionDescriptor collectionDescriptor, Object object2, boolean bl2) {
        if (object2 == null) {
            return;
        }
        if (bl2 || !(object2 instanceof CollectionProxyDefaultImpl) || ((CollectionProxyDefaultImpl)object2).isLoaded()) {
            Iterator iterator = BrokerHelper.getCollectionIterator(object2);
            while (iterator.hasNext()) {
                Object object3 = iterator.next();
                if (!ProxyHelper.isMaterialized(object3)) continue;
                ClassDescriptor classDescriptor = this.getClassDescriptor(ProxyHelper.getRealClass(object3));
                object3 = ProxyHelper.getRealObject(object3);
                this.link(object3, classDescriptor, collectionDescriptor, object, bl2);
                if (bl || collectionDescriptor.getCascadingStore() != 23) continue;
                this.store(object3);
            }
        }
    }

    protected void link(Object object, ClassDescriptor classDescriptor, ObjectReferenceDescriptor objectReferenceDescriptor, Object object2, boolean bl) {
        if (object2 == null) {
            if (!bl) {
                this.unlinkFK(object, classDescriptor, objectReferenceDescriptor);
            }
        } else {
            this.setFKField(object, classDescriptor, objectReferenceDescriptor, object2);
        }
    }

    public void unlinkFK(Object object, ClassDescriptor classDescriptor, ObjectReferenceDescriptor objectReferenceDescriptor) {
        this.setFKField(object, classDescriptor, objectReferenceDescriptor, null);
    }

    private void setFKField(Object object, ClassDescriptor classDescriptor, ObjectReferenceDescriptor objectReferenceDescriptor, Object object2) {
        ValueContainer[] valueContainerArray;
        FieldDescriptor[] fieldDescriptorArray = objectReferenceDescriptor.getForeignKeyFieldDescriptors(classDescriptor);
        if (fieldDescriptorArray == null) {
            throw new PersistenceBrokerException("No foreign key fields defined for class '" + classDescriptor.getClassNameOfObject() + "'");
        }
        if (object2 == null) {
            valueContainerArray = null;
        } else {
            Class clazz = ProxyHelper.getRealClass(object2);
            ClassDescriptor classDescriptor2 = this.getClassDescriptor(clazz);
            valueContainerArray = this.brokerHelper.getKeyValues(classDescriptor2, object2, false);
        }
        for (int i = 0; i < fieldDescriptorArray.length; ++i) {
            FieldDescriptor fieldDescriptor = fieldDescriptorArray[i];
            if (valueContainerArray == null && fieldDescriptor.isPrimaryKey()) continue;
            fieldDescriptor.getPersistentField().set(object, valueContainerArray != null ? valueContainerArray[i].getValue() : null);
        }
    }

    public void linkOneToOne(Object object, ClassDescriptor classDescriptor, ObjectReferenceDescriptor objectReferenceDescriptor, boolean bl) {
        this.storeAndLinkOneToOne(true, object, classDescriptor, objectReferenceDescriptor, true);
    }

    public void linkOneToMany(Object object, CollectionDescriptor collectionDescriptor, boolean bl) {
        Object object2 = collectionDescriptor.getPersistentField().get(object);
        this.storeAndLinkOneToMany(true, object, collectionDescriptor, object2, bl);
    }

    public void linkMtoN(Object object, CollectionDescriptor collectionDescriptor, boolean bl) {
        Object object2 = collectionDescriptor.getPersistentField().get(object);
        this.storeAndLinkMtoN(true, object, collectionDescriptor, object2, bl);
    }

    public void unlinkXtoN(Object object, CollectionDescriptor collectionDescriptor) {
        if (collectionDescriptor.isMtoNRelation()) {
            this.mtoNBroker.deleteMtoNImplementor(collectionDescriptor, object);
        } else {
            Object object2 = collectionDescriptor.getPersistentField().get(object);
            if (object2 != null) {
                Iterator iterator = BrokerHelper.getCollectionIterator(object2);
                ClassDescriptor classDescriptor = null;
                while (iterator.hasNext()) {
                    Object e = iterator.next();
                    if (classDescriptor == null) {
                        classDescriptor = this.getClassDescriptor(ProxyHelper.getRealClass(e));
                    }
                    this.unlinkFK(e, classDescriptor, collectionDescriptor);
                }
            }
        }
    }

    public void retrieveAllReferences(Object object) throws PersistenceBrokerException {
        ClassDescriptor classDescriptor = this.getClassDescriptor(object.getClass());
        this.referencesBroker.retrieveReferences(object, classDescriptor, true);
        this.referencesBroker.retrieveCollections(object, classDescriptor, true);
    }

    public void retrieveReference(Object object, String string) throws PersistenceBrokerException {
        ClassDescriptor classDescriptor = this.getClassDescriptor(object.getClass());
        CollectionDescriptor collectionDescriptor = classDescriptor.getCollectionDescriptorByName(string);
        if (collectionDescriptor != null) {
            this.referencesBroker.retrieveCollection(object, classDescriptor, collectionDescriptor, true);
        } else {
            ObjectReferenceDescriptor objectReferenceDescriptor = classDescriptor.getObjectReferenceDescriptorByName(string);
            if (objectReferenceDescriptor != null) {
                this.referencesBroker.retrieveReference(object, classDescriptor, objectReferenceDescriptor, true);
            } else {
                throw new PersistenceBrokerException("did not find attribute " + string + " for class " + object.getClass().getName());
            }
        }
    }

    public void refreshRelationships(Object object, ClassDescriptor classDescriptor) {
        Iterator iterator = classDescriptor.getCollectionDescriptors().iterator();
        while (iterator.hasNext()) {
            CollectionDescriptor collectionDescriptor = (CollectionDescriptor)iterator.next();
            if (!collectionDescriptor.isRefresh()) continue;
            this.referencesBroker.retrieveCollection(object, classDescriptor, collectionDescriptor, false);
        }
        iterator = classDescriptor.getObjectReferenceDescriptors().iterator();
        while (iterator.hasNext()) {
            ObjectReferenceDescriptor objectReferenceDescriptor = (ObjectReferenceDescriptor)iterator.next();
            if (!objectReferenceDescriptor.isRefresh()) continue;
            this.referencesBroker.retrieveReference(object, classDescriptor, objectReferenceDescriptor, false);
        }
    }

    public ManageableCollection getCollectionByQuery(Class clazz, org.apache.ojb.broker.query.Query query) throws PersistenceBrokerException {
        return this.referencesBroker.getCollectionByQuery(clazz, query, false);
    }

    public Collection getCollectionByQuery(org.apache.ojb.broker.query.Query query) throws PersistenceBrokerException {
        return this.referencesBroker.getCollectionByQuery(query, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object getDBObject(Identity identity) throws ClassNotPersistenceCapableException {
        ClassDescriptor classDescriptor;
        Iterator iterator;
        Class clazz = identity.getObjectsRealClass();
        if (clazz == null) {
            this.logger.info("Real class for used Identity object is 'null', use top-level class instead");
            clazz = identity.getObjectsTopLevelClass();
        }
        ClassDescriptor classDescriptor2 = this.getClassDescriptor(clazz);
        Object object = null;
        if (!classDescriptor2.isInterface()) {
            object = this.dbAccess.materializeObject(classDescriptor2, identity);
        }
        if (object == null && classDescriptor2.isExtent()) {
            iterator = this.getDescriptorRepository().getAllConcreteSubclassDescriptors(classDescriptor2).iterator();
            while (iterator.hasNext() && (object = this.dbAccess.materializeObject(classDescriptor = (ClassDescriptor)iterator.next(), identity)) == null) {
            }
        }
        if (object != null) {
            if (identity.getObjectsRealClass() == null) {
                identity.setObjectsRealClass(object.getClass());
            }
            iterator = object;
            synchronized (iterator) {
                this.objectCache.cache(identity, object);
                classDescriptor = this.getClassDescriptor(object.getClass());
                this.referencesBroker.retrieveReferences(object, classDescriptor, false);
                this.referencesBroker.retrieveCollections(object, classDescriptor, false);
            }
        }
        return object;
    }

    public Iterator getIteratorByQuery(org.apache.ojb.broker.query.Query query) throws PersistenceBrokerException {
        Class clazz = query.getSearchClass();
        ClassDescriptor classDescriptor = this.getClassDescriptor(clazz);
        return this.getIteratorFromQuery(query, classDescriptor);
    }

    protected OJBIterator getIteratorFromQuery(org.apache.ojb.broker.query.Query query, ClassDescriptor classDescriptor) throws PersistenceBrokerException {
        RsIteratorFactory rsIteratorFactory = RsIteratorFactoryImpl.getInstance();
        OJBIterator oJBIterator = this.getRsIteratorFromQuery(query, classDescriptor, rsIteratorFactory);
        if (query.usePaging()) {
            oJBIterator = new PagingIterator(oJBIterator, query.getStartAtIndex(), query.getEndAtIndex());
        }
        return oJBIterator;
    }

    public Object getObjectByIdentity(Identity identity) throws PersistenceBrokerException {
        this.objectCache.enableMaterializationCache();
        Object object = this.doGetObjectByIdentity(identity);
        this.objectCache.disableMaterializationCache();
        return object;
    }

    public Object doGetObjectByIdentity(Identity identity) throws PersistenceBrokerException {
        Object object;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("getObjectByIdentity " + identity);
        }
        if ((object = this.objectCache.lookup(identity)) == null) {
            object = this.getDBObject(identity);
        } else {
            ClassDescriptor classDescriptor = this.getClassDescriptor(object.getClass());
            if (classDescriptor.isAlwaysRefresh()) {
                this.refreshInstance(object, identity, classDescriptor);
            }
            this.refreshRelationships(object, classDescriptor);
        }
        this.AFTER_LOOKUP_EVENT.setTarget(object);
        this.fireBrokerEvent(this.AFTER_LOOKUP_EVENT);
        this.AFTER_LOOKUP_EVENT.setTarget(null);
        return object;
    }

    private void refreshInstance(Object object, Identity identity, ClassDescriptor classDescriptor) {
        Object object2 = this.getDBObject(identity);
        FieldDescriptor[] fieldDescriptorArray = classDescriptor.getFieldDescriptions();
        for (int i = 0; i < fieldDescriptorArray.length; ++i) {
            FieldDescriptor fieldDescriptor = fieldDescriptorArray[i];
            PersistentField persistentField = fieldDescriptor.getPersistentField();
            persistentField.set(object, persistentField.get(object2));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getObjectByQuery(org.apache.ojb.broker.query.Query query) throws PersistenceBrokerException {
        if (query instanceof QueryByIdentity) {
            Object object = query.getExampleObject();
            Identity identity = null;
            identity = object instanceof Identity ? (Identity)object : new Identity(object, this);
            return this.getObjectByIdentity(identity);
        }
        Class clazz = query.getSearchClass();
        ClassDescriptor classDescriptor = this.getClassDescriptor(clazz);
        OJBIterator oJBIterator = this.getIteratorFromQuery(query, classDescriptor);
        Object var5_7 = null;
        try {
            while (var5_7 == null && oJBIterator.hasNext()) {
                var5_7 = oJBIterator.next();
            }
        }
        finally {
            if (oJBIterator != null) {
                oJBIterator.releaseDbResources();
            }
        }
        return var5_7;
    }

    public Enumeration getPKEnumerationByQuery(Class clazz, org.apache.ojb.broker.query.Query query) throws PersistenceBrokerException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("getPKEnumerationByQuery " + query);
        }
        ClassDescriptor classDescriptor = this.getClassDescriptor(query.getSearchClass());
        return new PkEnumeration(query, classDescriptor, clazz, this);
    }

    public void store(Object object, ObjectModification objectModification) throws PersistenceBrokerException {
        object = ProxyHelper.getRealObject(object);
        ClassDescriptor classDescriptor = this.getClassDescriptor(object.getClass());
        Identity identity = new Identity(object, this, classDescriptor);
        if (objectModification.needsInsert()) {
            this.store(object, identity, classDescriptor, true);
        } else if (objectModification.needsUpdate()) {
            this.store(object, identity, classDescriptor, false);
        } else {
            this.storeCollections(object, classDescriptor, objectModification.needsInsert());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void store(Object object, Identity identity, ClassDescriptor classDescriptor, boolean bl) {
        if (!this.isInTransaction()) {
            this.logger.warn("No running tx found, please only store in context of an PB-transaction, to avoid side-effects - e.g. when rollback of complex objects");
        }
        if (bl) {
            this.BEFORE_STORE_EVENT.setTarget(object);
            this.fireBrokerEvent(this.BEFORE_STORE_EVENT);
            this.BEFORE_STORE_EVENT.setTarget(null);
        } else {
            this.BEFORE_UPDATE_EVENT.setTarget(object);
            this.fireBrokerEvent(this.BEFORE_UPDATE_EVENT);
            this.BEFORE_UPDATE_EVENT.setTarget(null);
        }
        if (object != null) {
            this.nowStoring.add(object);
            try {
                this.storeToDb(object, classDescriptor, identity, bl);
            }
            finally {
                this.nowStoring.remove(object);
            }
        } else {
            return;
        }
        if (bl) {
            this.AFTER_STORE_EVENT.setTarget(object);
            this.fireBrokerEvent(this.AFTER_STORE_EVENT);
            this.AFTER_STORE_EVENT.setTarget(null);
        } else {
            this.AFTER_UPDATE_EVENT.setTarget(object);
            this.fireBrokerEvent(this.AFTER_UPDATE_EVENT);
            this.AFTER_UPDATE_EVENT.setTarget(null);
        }
    }

    private void storeToDb(Object object, ClassDescriptor classDescriptor, Identity identity, boolean bl) {
        Serializable serializable;
        this.storeReferences(object, classDescriptor, bl);
        Object[] objectArray = identity.getPrimaryKeyValues();
        if (!this.serviceBrokerHelper().assertValidPkFields(classDescriptor.getPkFields(), objectArray)) {
            objectArray = this.serviceBrokerHelper().getKeyValues(classDescriptor, object);
            if (!this.serviceBrokerHelper().assertValidPkFields(classDescriptor.getPkFields(), objectArray)) {
                String string = bl ? " on insert" : " on update";
                throw new PersistenceBrokerException("assertValidPkFields failed for Object of type: " + classDescriptor.getClassNameOfObject() + string);
            }
        }
        try {
            this.sequenceManager.setReferenceFKs(object, classDescriptor);
        }
        catch (SequenceManagerException sequenceManagerException) {
            this.logger.error("Setting of reference FK failed", (Throwable)((Object)sequenceManagerException));
            throw new PersistenceBrokerException((Throwable)((Object)sequenceManagerException));
        }
        if (classDescriptor.getSuperClass() != null) {
            serializable = this.getDescriptorRepository().getDescriptorFor(classDescriptor.getSuperClass());
            this.storeToDb(object, (ClassDescriptor)serializable, identity, bl);
        }
        if (bl) {
            this.dbAccess.executeInsert(classDescriptor, object);
            try {
                this.sequenceManager.afterStore(this.dbAccess, classDescriptor, object);
            }
            catch (SequenceManagerException sequenceManagerException) {
                this.logger.error("SQLException during SequenceManager.afterStore call on object '" + classDescriptor.getClassOfObject().getName() + "': " + sequenceManagerException.getMessage(), (Throwable)((Object)sequenceManagerException));
                throw new PersistenceBrokerException((Throwable)((Object)sequenceManagerException));
            }
        } else {
            this.dbAccess.executeUpdate(classDescriptor, object);
        }
        serializable = new Identity(object, this, classDescriptor);
        this.objectCache.cache((Identity)serializable, object);
        this.storeCollections(object, classDescriptor, bl);
    }

    public boolean isInTransaction() {
        return this.inTransaction;
    }

    public void setInTransaction(boolean bl) {
        this.inTransaction = bl;
    }

    public void removeFromCache(Object object) throws PersistenceBrokerException {
        Identity identity = object instanceof Identity ? (Identity)object : new Identity(object, this);
        this.objectCache.remove(identity);
    }

    public ClassDescriptor getClassDescriptor(Class clazz) throws PersistenceBrokerException {
        return this.descriptorRepository.getDescriptorFor(clazz);
    }

    public boolean hasClassDescriptor(Class clazz) {
        return this.descriptorRepository.hasDescriptorFor(clazz);
    }

    public void clearCache() throws PersistenceBrokerException {
        this.objectCache.clear();
    }

    public Class getTopLevelClass(Class clazz) throws PersistenceBrokerException {
        try {
            return this.descriptorRepository.getTopLevelClass(clazz);
        }
        catch (ClassNotPersistenceCapableException classNotPersistenceCapableException) {
            throw new PersistenceBrokerException((Throwable)((Object)classNotPersistenceCapableException));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getCount(org.apache.ojb.broker.query.Query query) throws PersistenceBrokerException {
        org.apache.ojb.broker.query.Query query2 = this.serviceBrokerHelper().getCountQuery(query);
        int n = 0;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("getCount " + query2.getSearchClass() + ", " + query2);
        }
        Iterator iterator = this.getReportQueryIteratorByQuery(query2);
        try {
            while (iterator.hasNext()) {
                Object[] objectArray = (Object[])iterator.next();
                n += ((Number)objectArray[0]).intValue();
            }
        }
        finally {
            if (iterator instanceof OJBIterator) {
                ((OJBIterator)iterator).releaseDbResources();
            }
        }
        return n;
    }

    public Iterator getReportQueryIteratorByQuery(org.apache.ojb.broker.query.Query query) throws PersistenceBrokerException {
        ClassDescriptor classDescriptor = this.getClassDescriptor(query.getSearchClass());
        return this.getReportQueryIteratorFromQuery(query, classDescriptor);
    }

    private OJBIterator getRsIteratorFromQuery(org.apache.ojb.broker.query.Query query, ClassDescriptor classDescriptor, RsIteratorFactory rsIteratorFactory) throws PersistenceBrokerException {
        if (query instanceof QueryBySQL) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Creating SQL-RsIterator for class [" + classDescriptor.getClassNameOfObject() + "]");
            }
            return rsIteratorFactory.createRsIterator((QueryBySQL)query, classDescriptor, this);
        }
        if (!classDescriptor.isExtent() || !query.getWithExtents()) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Creating RsIterator for class [" + classDescriptor.getClassNameOfObject() + "]");
            }
            return rsIteratorFactory.createRsIterator(query, classDescriptor, this);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Creating ChainingIterator for class [" + classDescriptor.getClassNameOfObject() + "]");
        }
        ChainingIterator chainingIterator = new ChainingIterator();
        if (!classDescriptor.isInterface()) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Adding RsIterator for class [" + classDescriptor.getClassNameOfObject() + "] to ChainingIterator");
            }
            chainingIterator.addIterator(rsIteratorFactory.createRsIterator(query, classDescriptor, this));
        }
        Iterator iterator = this.getDescriptorRepository().getAllConcreteSubclassDescriptors(classDescriptor).iterator();
        while (iterator.hasNext()) {
            ClassDescriptor classDescriptor2 = (ClassDescriptor)iterator.next();
            if (chainingIterator.containsIteratorForTable(classDescriptor2.getFullTableName())) {
                if (!this.logger.isDebugEnabled()) continue;
                this.logger.debug("Skipping class [" + classDescriptor2.getClassNameOfObject() + "]");
                continue;
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Adding RsIterator of class [" + classDescriptor2.getClassNameOfObject() + "] to ChainingIterator");
            }
            chainingIterator.addIterator(rsIteratorFactory.createRsIterator(query, classDescriptor2, this));
        }
        return chainingIterator;
    }

    private OJBIterator getReportQueryIteratorFromQuery(org.apache.ojb.broker.query.Query query, ClassDescriptor classDescriptor) throws PersistenceBrokerException {
        RsIteratorFactory rsIteratorFactory = ReportRsIteratorFactoryImpl.getInstance();
        OJBIterator oJBIterator = this.getRsIteratorFromQuery(query, classDescriptor, rsIteratorFactory);
        if (query.usePaging()) {
            oJBIterator = new PagingIterator(oJBIterator, query.getStartAtIndex(), query.getEndAtIndex());
        }
        return oJBIterator;
    }

    public Query query() {
        return new QueryImpl(this);
    }

    public DescriptorRepository getDescriptorRepository() {
        return this.descriptorRepository;
    }

    protected void finalize() {
        if (!this.isClosed) {
            this.close();
        }
    }

    private void clearRegistrationLists() {
        this.nowStoring.clear();
        this.objectCache.localClear();
        this.deletedDuringTransaction.clear();
    }

    public void deleteMtoNImplementor(MtoNImplementor mtoNImplementor) throws PersistenceBrokerException {
        this.mtoNBroker.deleteMtoNImplementor(mtoNImplementor);
    }

    public void addMtoNImplementor(MtoNImplementor mtoNImplementor) throws PersistenceBrokerException {
        this.mtoNBroker.storeMtoNImplementor(mtoNImplementor);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

