/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.core;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.ojb.broker.Identity;
import org.apache.ojb.broker.ManageableCollection;
import org.apache.ojb.broker.PersistenceBrokerException;
import org.apache.ojb.broker.accesslayer.OJBIterator;
import org.apache.ojb.broker.accesslayer.PagingIterator;
import org.apache.ojb.broker.accesslayer.PlainPrefetcher;
import org.apache.ojb.broker.accesslayer.RelationshipPrefetcher;
import org.apache.ojb.broker.accesslayer.RelationshipPrefetcherFactory;
import org.apache.ojb.broker.core.PersistenceBrokerImpl;
import org.apache.ojb.broker.core.ValueContainer;
import org.apache.ojb.broker.core.proxy.CollectionProxyDefaultImpl;
import org.apache.ojb.broker.core.proxy.CollectionProxyListener;
import org.apache.ojb.broker.core.proxy.IndirectionHandler;
import org.apache.ojb.broker.core.proxy.MaterializationListener;
import org.apache.ojb.broker.core.proxy.ProxyFactory;
import org.apache.ojb.broker.core.proxy.ProxyHelper;
import org.apache.ojb.broker.core.proxy.VirtualProxy;
import org.apache.ojb.broker.metadata.ClassDescriptor;
import org.apache.ojb.broker.metadata.ClassNotPersistenceCapableException;
import org.apache.ojb.broker.metadata.CollectionDescriptor;
import org.apache.ojb.broker.metadata.FieldDescriptor;
import org.apache.ojb.broker.metadata.FieldHelper;
import org.apache.ojb.broker.metadata.ObjectReferenceDescriptor;
import org.apache.ojb.broker.metadata.fieldaccess.PersistentField;
import org.apache.ojb.broker.query.Criteria;
import org.apache.ojb.broker.query.Query;
import org.apache.ojb.broker.query.QueryByCriteria;
import org.apache.ojb.broker.query.QueryFactory;
import org.apache.ojb.broker.util.logging.Logger;
import org.apache.ojb.broker.util.logging.LoggerFactory;

public class QueryReferenceBroker {
    private Logger log = LoggerFactory.getLogger(class$org$apache$ojb$broker$core$QueryReferenceBroker == null ? (class$org$apache$ojb$broker$core$QueryReferenceBroker = QueryReferenceBroker.class$("org.apache.ojb.broker.core.QueryReferenceBroker")) : class$org$apache$ojb$broker$core$QueryReferenceBroker);
    private PersistenceBrokerImpl pb;
    private HashMap m_retrievalTasks;
    private ArrayList prefetchingListeners;
    private final boolean batchRetrieval = true;
    private final boolean prefetchProxies = true;
    private Class classToPrefetch;
    static /* synthetic */ Class class$org$apache$ojb$broker$core$QueryReferenceBroker;
    static /* synthetic */ Class class$org$apache$ojb$broker$util$collections$RemovalAwareCollection;
    static /* synthetic */ Class class$org$apache$ojb$broker$util$collections$ManageableArrayList;
    static /* synthetic */ Class class$org$apache$ojb$broker$metadata$fieldaccess$AnonymousPersistentField;

    public QueryReferenceBroker(PersistenceBrokerImpl persistenceBrokerImpl) {
        this.pb = persistenceBrokerImpl;
    }

    private ManageableCollection getCollectionByQuery(Class clazz, Class clazz2, Query query) throws ClassNotPersistenceCapableException, PersistenceBrokerException {
        if (this.log.isDebugEnabled()) {
            this.log.debug("getCollectionByQuery (" + clazz + ", " + clazz2 + ", " + query + ")");
        }
        ClassDescriptor classDescriptor = this.pb.getClassDescriptor(clazz2);
        ManageableCollection manageableCollection = null;
        OJBIterator oJBIterator = null;
        boolean bl = this.m_retrievalTasks == null;
        int n = -1;
        int n2 = 0;
        if (bl) {
            this.m_retrievalTasks = new HashMap();
        }
        try {
            block16: {
                try {
                    Object object;
                    manageableCollection = (ManageableCollection)clazz.newInstance();
                    oJBIterator = this.pb.getIteratorFromQuery(query, classDescriptor);
                    if (oJBIterator instanceof PagingIterator) {
                        n = oJBIterator.fullSize();
                    }
                    while (oJBIterator.hasNext()) {
                        object = oJBIterator.next();
                        if (object == null) continue;
                        IndirectionHandler indirectionHandler = ProxyHelper.getIndirectionHandler(object);
                        if (indirectionHandler != null || clazz2.isAssignableFrom(object.getClass())) {
                            manageableCollection.ojbAdd(object);
                            ++n2;
                        } else {
                            this.log.warn("Candidate object [" + object + "] class [" + object.getClass().getName() + "] is not a subtype of [" + clazz2.getName() + "] or any type of proxy. NOT INCLUDED in result collection");
                        }
                        if (indirectionHandler == null || classDescriptor.getProxyPrefetchingLimit() <= 0 || !this.addRetrievalTask(object, this)) continue;
                        new PBMaterializationListener(object, this.m_retrievalTasks, this, classDescriptor.getProxyPrefetchingLimit());
                    }
                    if (!bl) break block16;
                    object = this.classToPrefetch;
                    this.classToPrefetch = null;
                    this.performRetrievalTasks();
                    this.classToPrefetch = object;
                }
                catch (InstantiationException instantiationException) {
                    this.log.error(instantiationException);
                    throw new PersistenceBrokerException(instantiationException);
                }
                catch (IllegalAccessException illegalAccessException) {
                    this.log.error(illegalAccessException);
                    throw new PersistenceBrokerException(illegalAccessException);
                }
            }
            Object var13_14 = null;
            if (oJBIterator != null) {
                oJBIterator.releaseDbResources();
            }
            if (bl) {
                this.m_retrievalTasks = null;
            }
        }
        catch (Throwable throwable) {
            Object var13_15 = null;
            if (oJBIterator != null) {
                oJBIterator.releaseDbResources();
            }
            if (bl) {
                this.m_retrievalTasks = null;
            }
            throw throwable;
        }
        if (n < 0) {
            n = n2;
        }
        query.fullSize(n);
        return manageableCollection;
    }

    public ManageableCollection getCollectionByQuery(Class clazz, Query query, boolean bl) throws PersistenceBrokerException {
        try {
            ManageableCollection manageableCollection = query == null ? (ManageableCollection)clazz.newInstance() : (bl ? ProxyFactory.createCollectionProxy(this.pb.getPBKey(), query, clazz) : this.getCollectionByQuery(clazz, query.getSearchClass(), query));
            return manageableCollection;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            throw new PersistenceBrokerException(throwable);
        }
    }

    public Collection getCollectionByQuery(Query query, boolean bl) throws PersistenceBrokerException {
        return (Collection)((Object)this.getCollectionByQuery(class$org$apache$ojb$broker$util$collections$RemovalAwareCollection == null ? (class$org$apache$ojb$broker$util$collections$RemovalAwareCollection = QueryReferenceBroker.class$("org.apache.ojb.broker.util.collections.RemovalAwareCollection")) : class$org$apache$ojb$broker$util$collections$RemovalAwareCollection, query, bl));
    }

    private Collection getCollectionByQuery(Query query, CollectionDescriptor collectionDescriptor) throws PersistenceBrokerException {
        if (collectionDescriptor.isMtoNRelation()) {
            return (Collection)((Object)this.getCollectionByQuery(class$org$apache$ojb$broker$util$collections$ManageableArrayList == null ? (class$org$apache$ojb$broker$util$collections$ManageableArrayList = QueryReferenceBroker.class$("org.apache.ojb.broker.util.collections.ManageableArrayList")) : class$org$apache$ojb$broker$util$collections$ManageableArrayList, query, collectionDescriptor.isLazy()));
        }
        return (Collection)((Object)this.getCollectionByQuery(class$org$apache$ojb$broker$util$collections$RemovalAwareCollection == null ? (class$org$apache$ojb$broker$util$collections$RemovalAwareCollection = QueryReferenceBroker.class$("org.apache.ojb.broker.util.collections.RemovalAwareCollection")) : class$org$apache$ojb$broker$util$collections$RemovalAwareCollection, query, collectionDescriptor.isLazy()));
    }

    private boolean addRetrievalTask(Object object, Object object2) {
        ArrayList<Object> arrayList = (ArrayList<Object>)this.m_retrievalTasks.get(object2);
        boolean bl = false;
        if (arrayList == null) {
            arrayList = new ArrayList<Object>();
            this.m_retrievalTasks.put(object2, arrayList);
            bl = true;
        }
        arrayList.add(object);
        return bl;
    }

    public void performRetrievalTasks() {
        if (this.m_retrievalTasks == null) {
            return;
        }
        while (this.m_retrievalTasks.size() > 0) {
            HashMap hashMap = this.m_retrievalTasks;
            this.m_retrievalTasks = new HashMap();
            Iterator iterator = hashMap.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                Object k = entry.getKey();
                if (!(k instanceof ObjectReferenceDescriptor)) continue;
                ObjectReferenceDescriptor objectReferenceDescriptor = (ObjectReferenceDescriptor)k;
                ArrayList arrayList = (ArrayList)entry.getValue();
                if (objectReferenceDescriptor.isLazy() || objectReferenceDescriptor.getItemProxyClass() != null) continue;
                RelationshipPrefetcher relationshipPrefetcher = RelationshipPrefetcherFactory.createRelationshipPrefetcher(this.pb, objectReferenceDescriptor);
                relationshipPrefetcher.prefetchRelationship(arrayList);
                iterator.remove();
            }
        }
    }

    public void retrieveReference(Object object, ClassDescriptor classDescriptor, ObjectReferenceDescriptor objectReferenceDescriptor, boolean bl) {
        Object object2 = null;
        if (bl || objectReferenceDescriptor.getCascadeRetrieve()) {
            Identity identity = this.getReferencedObjectIdentity(object, objectReferenceDescriptor, classDescriptor);
            boolean bl2 = true;
            if (identity == null) {
                object2 = null;
            } else if (this.pb.serviceObjectCache().lookup(identity) != null) {
                object2 = this.pb.doGetObjectByIdentity(identity);
            } else if (this.m_retrievalTasks != null && !objectReferenceDescriptor.isLazy() && objectReferenceDescriptor.getItemProxyClass() == null) {
                this.addRetrievalTask(object, objectReferenceDescriptor);
                bl2 = false;
            } else {
                object2 = this.getReferencedObject(identity, objectReferenceDescriptor, classDescriptor);
            }
            if (bl2) {
                IndirectionHandler indirectionHandler;
                PersistentField persistentField = objectReferenceDescriptor.getPersistentField();
                persistentField.set(object, object2);
                if (object2 != null && this.m_retrievalTasks != null && objectReferenceDescriptor.getProxyPrefetchingLimit() > 0 && (indirectionHandler = ProxyHelper.getIndirectionHandler(object2)) != null && this.addRetrievalTask(object, objectReferenceDescriptor)) {
                    new PBMaterializationListener(object, this.m_retrievalTasks, objectReferenceDescriptor, objectReferenceDescriptor.getProxyPrefetchingLimit());
                }
            }
        }
    }

    public void retrieveReferences(Object object, ClassDescriptor classDescriptor, boolean bl) throws PersistenceBrokerException {
        Iterator iterator = classDescriptor.getObjectReferenceDescriptors().iterator();
        ObjectReferenceDescriptor objectReferenceDescriptor = null;
        Class clazz = this.classToPrefetch;
        this.classToPrefetch = null;
        while (iterator.hasNext()) {
            objectReferenceDescriptor = (ObjectReferenceDescriptor)iterator.next();
            this.retrieveReference(object, classDescriptor, objectReferenceDescriptor, bl);
        }
        this.classToPrefetch = clazz;
    }

    private Identity getReferencedObjectIdentity(Object object, ObjectReferenceDescriptor objectReferenceDescriptor, ClassDescriptor classDescriptor) {
        Object[] objectArray = objectReferenceDescriptor.getForeignKeyValues(object, classDescriptor);
        FieldDescriptor[] fieldDescriptorArray = objectReferenceDescriptor.getForeignKeyFieldDescriptors(classDescriptor);
        boolean bl = this.hasNullifiedFK(fieldDescriptorArray, objectArray);
        if (bl) {
            Object object2;
            if (this.isAnonymousKeyReference(classDescriptor, objectReferenceDescriptor) && (object2 = objectReferenceDescriptor.getPersistentField().get(object)) != null) {
                return new Identity(object2, this.pb);
            }
        } else {
            return new Identity(objectReferenceDescriptor.getItemClass(), this.pb.getTopLevelClass(objectReferenceDescriptor.getItemClass()), objectArray);
        }
        return null;
    }

    private boolean hasNullifiedFK(FieldDescriptor[] fieldDescriptorArray, Object[] objectArray) {
        boolean bl = true;
        for (int i = 0; i < objectArray.length; ++i) {
            if (this.pb.serviceBrokerHelper().representsNull(fieldDescriptorArray[i], objectArray[i])) continue;
            bl = false;
            break;
        }
        return bl;
    }

    private boolean isAnonymousKeyReference(ClassDescriptor classDescriptor, ObjectReferenceDescriptor objectReferenceDescriptor) {
        boolean bl = false;
        FieldDescriptor[] fieldDescriptorArray = objectReferenceDescriptor.getForeignKeyFieldDescriptors(classDescriptor);
        for (int i = 0; i < fieldDescriptorArray.length; ++i) {
            FieldDescriptor fieldDescriptor;
            if (!(class$org$apache$ojb$broker$metadata$fieldaccess$AnonymousPersistentField == null ? QueryReferenceBroker.class$("org.apache.ojb.broker.metadata.fieldaccess.AnonymousPersistentField") : class$org$apache$ojb$broker$metadata$fieldaccess$AnonymousPersistentField).isAssignableFrom((fieldDescriptor = fieldDescriptorArray[i]).getPersistentField().getClass())) continue;
            bl = true;
            break;
        }
        return bl;
    }

    private Object getReferencedObject(Identity identity, ObjectReferenceDescriptor objectReferenceDescriptor, ClassDescriptor classDescriptor) {
        Class clazz = objectReferenceDescriptor.isLazy() ? this.pb.getClassDescriptor(objectReferenceDescriptor.getItemClass()).getDynamicProxyClass() : objectReferenceDescriptor.getItemProxyClass();
        if (clazz != null) {
            try {
                return VirtualProxy.createProxy(this.pb.getPBKey(), clazz, identity);
            }
            catch (Exception exception) {
                this.log.error("Error instantiating obj: " + exception.getMessage(), exception);
                throw new PersistenceBrokerException(exception);
            }
        }
        return this.pb.doGetObjectByIdentity(identity);
    }

    public void retrieveCollection(Object object, ClassDescriptor classDescriptor, CollectionDescriptor collectionDescriptor, boolean bl) {
        if (bl || collectionDescriptor.getCascadeRetrieve()) {
            if (this.m_retrievalTasks != null && !collectionDescriptor.isLazy() && !collectionDescriptor.hasProxyItems() && collectionDescriptor.getQueryCustomizer() == null) {
                this.addRetrievalTask(object, collectionDescriptor);
            } else {
                Object object2;
                Class clazz = collectionDescriptor.getCollectionClass();
                PersistentField persistentField = collectionDescriptor.getPersistentField();
                Query query = this.getFKQuery(object, classDescriptor, collectionDescriptor);
                if (clazz == null) {
                    Collection collection = this.getCollectionByQuery(query, collectionDescriptor);
                    if (persistentField.getType().isArray()) {
                        int n = collection.size();
                        Class<?> clazz2 = persistentField.getType().getComponentType();
                        Object object3 = Array.newInstance(clazz2, n);
                        int n2 = 0;
                        Iterator iterator = collection.iterator();
                        while (iterator.hasNext()) {
                            Array.set(object3, n2, iterator.next());
                            ++n2;
                        }
                        persistentField.set(object, object3);
                    } else {
                        persistentField.set(object, collection);
                    }
                    object2 = collection;
                } else {
                    ManageableCollection manageableCollection = this.getCollectionByQuery(clazz, query, collectionDescriptor.isLazy());
                    persistentField.set(object, manageableCollection);
                    object2 = manageableCollection;
                }
                if (this.m_retrievalTasks != null && collectionDescriptor.getProxyPrefetchingLimit() > 0 && collectionDescriptor.getQueryCustomizer() == null && object2 instanceof CollectionProxyDefaultImpl && this.addRetrievalTask(object, collectionDescriptor)) {
                    new PBCollectionProxyListener(object, this.m_retrievalTasks, collectionDescriptor, collectionDescriptor.getProxyPrefetchingLimit());
                }
            }
        }
    }

    private Query getFKQuery(Object object, ClassDescriptor classDescriptor, CollectionDescriptor collectionDescriptor) {
        Query query = null;
        QueryByCriteria queryByCriteria = null;
        queryByCriteria = collectionDescriptor.isMtoNRelation() ? this.getFKQueryMtoN(object, classDescriptor, collectionDescriptor) : this.getFKQuery1toN(object, classDescriptor, collectionDescriptor);
        if (!collectionDescriptor.getOrderBy().isEmpty()) {
            Iterator iterator = collectionDescriptor.getOrderBy().iterator();
            while (iterator.hasNext()) {
                queryByCriteria.addOrderBy((FieldHelper)iterator.next());
            }
        }
        query = collectionDescriptor.getQueryCustomizer() != null ? collectionDescriptor.getQueryCustomizer().customizeQuery(object, this.pb, collectionDescriptor, queryByCriteria) : queryByCriteria;
        return query;
    }

    private QueryByCriteria getFKQueryMtoN(Object object, ClassDescriptor classDescriptor, CollectionDescriptor collectionDescriptor) {
        int n;
        ValueContainer[] valueContainerArray = this.pb.serviceBrokerHelper().getKeyValues(classDescriptor, object);
        String[] stringArray = collectionDescriptor.getFksToThisClass();
        String[] stringArray2 = collectionDescriptor.getFksToItemClass();
        ClassDescriptor classDescriptor2 = this.pb.getClassDescriptor(collectionDescriptor.getItemClass());
        Criteria criteria = new Criteria();
        for (n = 0; n < stringArray.length; ++n) {
            criteria.addColumnEqualTo(collectionDescriptor.getIndirectionTable() + "." + stringArray[n], valueContainerArray[n].getValue());
        }
        for (n = 0; n < stringArray2.length; ++n) {
            criteria.addColumnEqualToField(collectionDescriptor.getIndirectionTable() + "." + stringArray2[n].toString(), classDescriptor2.getPkFields()[n].getAttributeName());
        }
        return QueryFactory.newQuery(classDescriptor2.getClassOfObject(), collectionDescriptor.getIndirectionTable(), criteria);
    }

    private QueryByCriteria getFKQuery1toN(Object object, ClassDescriptor classDescriptor, CollectionDescriptor collectionDescriptor) {
        ValueContainer[] valueContainerArray = this.pb.serviceBrokerHelper().getKeyValues(classDescriptor, object);
        ClassDescriptor classDescriptor2 = this.pb.getClassDescriptor(collectionDescriptor.getItemClass());
        FieldDescriptor[] fieldDescriptorArray = collectionDescriptor.getForeignKeyFieldDescriptors(classDescriptor2);
        Criteria criteria = new Criteria();
        for (int i = 0; i < fieldDescriptorArray.length; ++i) {
            FieldDescriptor fieldDescriptor = fieldDescriptorArray[i];
            criteria.addEqualTo(fieldDescriptor.getAttributeName(), valueContainerArray[i].getValue());
        }
        return QueryFactory.newQuery(classDescriptor2.getClassOfObject(), criteria);
    }

    public Query getPKQuery(Identity identity) {
        Object[] objectArray = identity.getPrimaryKeyValues();
        ClassDescriptor classDescriptor = this.pb.getClassDescriptor(identity.getObjectsTopLevelClass());
        FieldDescriptor[] fieldDescriptorArray = classDescriptor.getPkFields();
        Criteria criteria = new Criteria();
        for (int i = 0; i < fieldDescriptorArray.length; ++i) {
            FieldDescriptor fieldDescriptor = fieldDescriptorArray[i];
            criteria.addEqualTo(fieldDescriptor.getAttributeName(), objectArray[i]);
        }
        return QueryFactory.newQuery(classDescriptor.getClassOfObject(), criteria);
    }

    public void retrieveCollections(Object object, ClassDescriptor classDescriptor, boolean bl) throws PersistenceBrokerException {
        Iterator iterator = classDescriptor.getCollectionDescriptors().iterator();
        Class clazz = this.classToPrefetch;
        this.classToPrefetch = null;
        while (iterator.hasNext()) {
            CollectionDescriptor collectionDescriptor = (CollectionDescriptor)iterator.next();
            this.retrieveCollection(object, classDescriptor, collectionDescriptor, bl);
        }
        this.classToPrefetch = clazz;
    }

    public void removePrefetchingListeners() {
        if (this.prefetchingListeners != null) {
            Iterator iterator = this.prefetchingListeners.iterator();
            while (iterator.hasNext()) {
                PBPrefetchingListener pBPrefetchingListener = (PBPrefetchingListener)iterator.next();
                pBPrefetchingListener.removeThisListener();
            }
            this.prefetchingListeners.clear();
        }
    }

    public Class getClassToPrefetch() {
        return this.classToPrefetch;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class PBCollectionProxyListener
    extends PBPrefetchingListener
    implements CollectionProxyListener {
        CollectionProxyDefaultImpl _listenedCollection;

        PBCollectionProxyListener(Object object, HashMap hashMap, CollectionDescriptor collectionDescriptor, int n) {
            super(object, hashMap, collectionDescriptor, n);
        }

        protected void addThisListenerTo(Object object) {
            PersistentField persistentField = ((CollectionDescriptor)this._key).getPersistentField();
            this._listenedCollection = (CollectionProxyDefaultImpl)persistentField.get(object);
            this._listenedCollection.addListener(this);
        }

        protected void removeThisListener() {
            if (this._listenedCollection != null) {
                this._listenedCollection.removeListener(this);
                this._listenedCollection = null;
            }
        }

        protected RelationshipPrefetcher getPrefetcher(Object object) {
            return RelationshipPrefetcherFactory.createRelationshipPrefetcher(QueryReferenceBroker.this.pb, (CollectionDescriptor)this._key);
        }

        public void beforeLoading(CollectionProxyDefaultImpl collectionProxyDefaultImpl) {
            this.prefetch(collectionProxyDefaultImpl);
        }

        public void afterLoading(CollectionProxyDefaultImpl collectionProxyDefaultImpl) {
        }
    }

    abstract class PBPrefetchingListener {
        private HashMap _retrievalTasks;
        private int _limit;
        protected Object _key;

        PBPrefetchingListener(Object object, HashMap hashMap, Object object2, int n) {
            this._retrievalTasks = hashMap;
            this._key = object2;
            this._limit = n + 1;
            if (QueryReferenceBroker.this.prefetchingListeners == null) {
                QueryReferenceBroker.this.prefetchingListeners = new ArrayList();
            }
            this.addThisListenerTo(object);
            QueryReferenceBroker.this.prefetchingListeners.add(this);
        }

        protected abstract void addThisListenerTo(Object var1);

        protected abstract void removeThisListener();

        protected abstract RelationshipPrefetcher getPrefetcher(Object var1);

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void prefetch(Object object) {
            boolean bl;
            List list;
            ArrayList arrayList = (ArrayList)this._retrievalTasks.get(this._key);
            this.removeThisListener();
            if (arrayList == null) {
                return;
            }
            RelationshipPrefetcher relationshipPrefetcher = this.getPrefetcher(object);
            if (arrayList.size() <= this._limit) {
                list = arrayList;
                bl = true;
            } else {
                list = arrayList.subList(0, this._limit);
                bl = false;
            }
            Class clazz = QueryReferenceBroker.this.classToPrefetch;
            QueryReferenceBroker.this.classToPrefetch = relationshipPrefetcher.getItemClassDescriptor().getClassOfObject();
            try {
                relationshipPrefetcher.prefetchRelationship(list);
            }
            finally {
                QueryReferenceBroker.this.classToPrefetch = clazz;
            }
            if (bl) {
                this._retrievalTasks.remove(this._key);
            } else {
                list.clear();
                this.addThisListenerTo(arrayList.get(0));
            }
        }
    }

    class PBMaterializationListener
    extends PBPrefetchingListener
    implements MaterializationListener {
        private IndirectionHandler _listenedHandler;

        PBMaterializationListener(Object object, HashMap hashMap, Object object2, int n) {
            super(object, hashMap, object2, n);
        }

        protected void addThisListenerTo(Object object) {
            this._listenedHandler = ProxyHelper.getIndirectionHandler(object);
            if (this._listenedHandler != null) {
                this._listenedHandler.addListener(this);
            }
        }

        protected void removeThisListener() {
            if (this._listenedHandler != null) {
                this._listenedHandler.removeListener(this);
                this._listenedHandler = null;
            }
        }

        protected RelationshipPrefetcher getPrefetcher(Object object) {
            if (this._key instanceof ObjectReferenceDescriptor) {
                return RelationshipPrefetcherFactory.createRelationshipPrefetcher(QueryReferenceBroker.this.pb, (ObjectReferenceDescriptor)this._key);
            }
            IndirectionHandler indirectionHandler = (IndirectionHandler)object;
            return new PlainPrefetcher(QueryReferenceBroker.this.pb, indirectionHandler.getIdentity().getObjectsTopLevelClass());
        }

        public void beforeMaterialization(IndirectionHandler indirectionHandler, Identity identity) {
            this.prefetch(indirectionHandler);
        }

        public void afterMaterialization(IndirectionHandler indirectionHandler, Object object) {
        }
    }
}

