/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.core.proxy;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.apache.ojb.broker.ManageableCollection;
import org.apache.ojb.broker.OJBRuntimeException;
import org.apache.ojb.broker.PBFactoryException;
import org.apache.ojb.broker.PBKey;
import org.apache.ojb.broker.PersistenceBroker;
import org.apache.ojb.broker.PersistenceBrokerException;
import org.apache.ojb.broker.PersistenceBrokerFactory;
import org.apache.ojb.broker.core.PersistenceBrokerThreadMapping;
import org.apache.ojb.broker.core.proxy.CollectionProxy;
import org.apache.ojb.broker.core.proxy.CollectionProxyListener;
import org.apache.ojb.broker.query.Query;

public class CollectionProxyDefaultImpl
implements Collection,
ManageableCollection,
CollectionProxy {
    private transient PersistenceBroker _broker;
    private PBKey _brokerKey;
    private Query _query;
    private Collection _data;
    private Class _collectionClass;
    private int _size = -1;
    private boolean _needsClose;
    private transient ArrayList _listeners;
    static /* synthetic */ Class class$org$apache$ojb$broker$util$collections$RemovalAwareCollection;
    static /* synthetic */ Class class$org$apache$ojb$broker$util$collections$IRemovalAwareCollection;

    public CollectionProxyDefaultImpl(PBKey pBKey, Query query) {
        this(pBKey, class$org$apache$ojb$broker$util$collections$RemovalAwareCollection == null ? (class$org$apache$ojb$broker$util$collections$RemovalAwareCollection = CollectionProxyDefaultImpl.class$("org.apache.ojb.broker.util.collections.RemovalAwareCollection")) : class$org$apache$ojb$broker$util$collections$RemovalAwareCollection, query);
    }

    public CollectionProxyDefaultImpl(PBKey pBKey, Class clazz, Query query) {
        this.setBrokerKey(pBKey);
        this.setCollectionClass(clazz);
        this.setQuery(query);
    }

    public boolean isLoaded() {
        return this._data != null;
    }

    protected synchronized int loadSize() throws PersistenceBrokerException {
        try {
            int n = this.getBroker().getCount(this.getQuery());
            return n;
        }
        catch (Exception exception) {
            throw new PersistenceBrokerException(exception);
        }
        finally {
            this.releaseBroker();
        }
    }

    protected synchronized void setSize(int n) {
        this._size = n;
    }

    protected Collection loadData() throws PersistenceBrokerException {
        try {
            Collection collection = this._data != null ? this._data : (this._size != 0 ? (Collection)((Object)this.getBroker().getCollectionByQuery(this.getCollectionClass(), this.getQuery())) : (Collection)this.getCollectionClass().newInstance());
            Collection collection2 = collection;
            return collection2;
        }
        catch (Exception exception) {
            throw new PersistenceBrokerException(exception);
        }
        finally {
            this.releaseBroker();
        }
    }

    protected void beforeLoading() {
        if (this._listeners != null) {
            for (int i = this._listeners.size() - 1; i >= 0; --i) {
                CollectionProxyListener collectionProxyListener = (CollectionProxyListener)this._listeners.get(i);
                collectionProxyListener.beforeLoading(this);
            }
        }
    }

    protected void afterLoading() {
        if (this._listeners != null) {
            for (int i = this._listeners.size() - 1; i >= 0; --i) {
                CollectionProxyListener collectionProxyListener = (CollectionProxyListener)this._listeners.get(i);
                collectionProxyListener.afterLoading(this);
            }
        }
    }

    public int size() {
        if (this.isLoaded()) {
            return this.getData().size();
        }
        if (this._size < 0) {
            this._size = this.loadSize();
        }
        return this._size;
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public boolean contains(Object object) {
        return this.getData().contains(object);
    }

    public Iterator iterator() {
        return this.getData().iterator();
    }

    public Object[] toArray() {
        return this.getData().toArray();
    }

    public Object[] toArray(Object[] objectArray) {
        return this.getData().toArray(objectArray);
    }

    public boolean add(Object object) {
        return this.getData().add(object);
    }

    public boolean remove(Object object) {
        return this.getData().remove(object);
    }

    public boolean containsAll(Collection collection) {
        return this.getData().containsAll(collection);
    }

    public boolean addAll(Collection collection) {
        return this.getData().addAll(collection);
    }

    public boolean removeAll(Collection collection) {
        return this.getData().removeAll(collection);
    }

    public boolean retainAll(Collection collection) {
        return this.getData().retainAll(collection);
    }

    public void clear() {
        Class clazz;
        if ((class$org$apache$ojb$broker$util$collections$IRemovalAwareCollection == null ? (class$org$apache$ojb$broker$util$collections$IRemovalAwareCollection = CollectionProxyDefaultImpl.class$("org.apache.ojb.broker.util.collections.IRemovalAwareCollection")) : class$org$apache$ojb$broker$util$collections$IRemovalAwareCollection).isAssignableFrom(clazz = this.getCollectionClass())) {
            this.getData().clear();
        } else {
            ArrayList arrayList;
            try {
                arrayList = (ArrayList)clazz.newInstance();
            }
            catch (Exception exception) {
                arrayList = new ArrayList();
            }
            this.setData(arrayList);
        }
        this._size = 0;
    }

    public Query getQuery() {
        return this._query;
    }

    protected void setQuery(Query query) {
        this._query = query;
    }

    protected synchronized void releaseBroker() {
        if (this._broker != null && this._needsClose) {
            this._needsClose = false;
            this._broker.close();
            this._broker = null;
        }
    }

    protected synchronized PersistenceBroker getBroker() throws PBFactoryException {
        if (this.getBrokerKey() == null) {
            throw new OJBRuntimeException("Can't find associated PBKey. Need PBKey to obtain a validPersistenceBroker instance from intern resources.");
        }
        PersistenceBroker persistenceBroker = PersistenceBrokerThreadMapping.currentPersistenceBroker(this.getBrokerKey());
        if (persistenceBroker == null && this._broker == null) {
            this._broker = PersistenceBrokerFactory.createPersistenceBroker(this.getBrokerKey());
            this._needsClose = true;
            persistenceBroker = this._broker;
        }
        return persistenceBroker;
    }

    public synchronized Collection getData() {
        if (!this.isLoaded()) {
            this.beforeLoading();
            this.setData(this.loadData());
            this.afterLoading();
        }
        return this._data;
    }

    public void setData(Collection collection) {
        this._data = collection;
    }

    public Class getCollectionClass() {
        return this._collectionClass;
    }

    protected void setCollectionClass(Class clazz) {
        this._collectionClass = clazz;
    }

    public void ojbAdd(Object object) {
        this.add(object);
    }

    public void ojbAddAll(ManageableCollection manageableCollection) {
        this.addAll((Collection)((CollectionProxyDefaultImpl)manageableCollection));
    }

    public Iterator ojbIterator() {
        return this.iterator();
    }

    public void afterStore(PersistenceBroker persistenceBroker) throws PersistenceBrokerException {
        Collection collection = this.getData();
        if (collection instanceof ManageableCollection) {
            ((ManageableCollection)((Object)collection)).afterStore(persistenceBroker);
        }
    }

    public PBKey getBrokerKey() {
        return this._brokerKey;
    }

    protected void setBrokerKey(PBKey pBKey) {
        this._brokerKey = pBKey;
    }

    public synchronized void addListener(CollectionProxyListener collectionProxyListener) {
        if (this._listeners == null) {
            this._listeners = new ArrayList();
        }
        this._listeners.add(collectionProxyListener);
    }

    public synchronized void removeListener(CollectionProxyListener collectionProxyListener) {
        if (this._listeners != null) {
            this._listeners.remove(collectionProxyListener);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

