/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.core.proxy;

import java.lang.reflect.Method;
import java.util.ArrayList;
import org.apache.ojb.broker.Identity;
import org.apache.ojb.broker.OJBRuntimeException;
import org.apache.ojb.broker.PBFactoryException;
import org.apache.ojb.broker.PBKey;
import org.apache.ojb.broker.PersistenceBroker;
import org.apache.ojb.broker.PersistenceBrokerException;
import org.apache.ojb.broker.PersistenceBrokerFactory;
import org.apache.ojb.broker.core.PersistenceBrokerThreadMapping;
import org.apache.ojb.broker.core.proxy.IndirectionHandler;
import org.apache.ojb.broker.core.proxy.MaterializationListener;
import org.apache.ojb.broker.util.logging.LoggerFactory;

public class IndirectionHandlerDefaultImpl
implements IndirectionHandler {
    static final long serialVersionUID = -1993879565033755826L;
    private transient PersistenceBroker _broker = null;
    private PBKey _brokerKey;
    private Object _realSubject = null;
    private Identity _id = null;
    private transient ArrayList _listeners;
    private boolean _needsClose;
    static /* synthetic */ Class class$org$apache$ojb$broker$core$proxy$IndirectionHandler;

    public IndirectionHandlerDefaultImpl(PBKey pBKey, Identity identity) {
        this.setBrokerKey(pBKey);
        this.setIdentity(identity);
    }

    public Identity getIdentity() {
        return this._id;
    }

    protected void setIdentity(Identity identity) {
        this._id = identity;
    }

    public PBKey getBrokerKey() {
        return this._brokerKey;
    }

    protected void setBrokerKey(PBKey pBKey) {
        this._brokerKey = pBKey;
    }

    public synchronized void addListener(MaterializationListener materializationListener) {
        if (this._listeners == null) {
            this._listeners = new ArrayList();
        }
        this._listeners.add(materializationListener);
    }

    public synchronized void removeListener(MaterializationListener materializationListener) {
        if (this._listeners != null) {
            this._listeners.remove(materializationListener);
        }
    }

    protected void beforeMaterialization() {
        if (this._listeners != null) {
            for (int i = this._listeners.size() - 1; i >= 0; --i) {
                MaterializationListener materializationListener = (MaterializationListener)this._listeners.get(i);
                materializationListener.beforeMaterialization(this, this._id);
            }
        }
    }

    protected void afterMaterialization() {
        if (this._listeners != null) {
            for (int i = this._listeners.size() - 1; i >= 0; --i) {
                MaterializationListener materializationListener = (MaterializationListener)this._listeners.get(i);
                materializationListener.afterMaterialization(this, this._realSubject);
            }
        }
    }

    protected synchronized PersistenceBroker getBroker() throws PBFactoryException {
        if (this.getBrokerKey() == null) {
            throw new OJBRuntimeException("Can't find associated PBKey. Need PBKey to obtain a validPersistenceBroker instance from intern resources.");
        }
        PersistenceBroker persistenceBroker = PersistenceBrokerThreadMapping.currentPersistenceBroker(this.getBrokerKey());
        if (persistenceBroker == null && this._broker == null) {
            this._broker = PersistenceBrokerFactory.createPersistenceBroker(this.getBrokerKey());
            this._needsClose = true;
            persistenceBroker = this._broker;
        }
        return persistenceBroker;
    }

    protected void releaseBroker() {
        if (this._broker != null && this._needsClose) {
            this._needsClose = false;
            this._broker.close();
            this._broker = null;
        }
    }

    public Object invoke(Object object, Method method, Object[] objectArray) {
        Object object2 = null;
        String string = method.getName();
        try {
            object2 = this.getRealSubject();
            return method.invoke(object2, objectArray);
        }
        catch (Exception exception) {
            throw new PersistenceBrokerException("Error invoking method " + method.getName(), exception);
        }
    }

    public Object getRealSubject() throws PersistenceBrokerException {
        if (this._realSubject == null) {
            this.beforeMaterialization();
            this._realSubject = this.materializeSubject();
            this.afterMaterialization();
        }
        return this._realSubject;
    }

    public void setRealSubject(Object object) {
        this._realSubject = object;
    }

    protected synchronized Object materializeSubject() throws PersistenceBrokerException {
        try {
            Object object = this.getBroker().getObjectByIdentity(this._id);
            if (object == null) {
                LoggerFactory.getLogger(class$org$apache$ojb$broker$core$proxy$IndirectionHandler == null ? (class$org$apache$ojb$broker$core$proxy$IndirectionHandler = IndirectionHandlerDefaultImpl.class$("org.apache.ojb.broker.core.proxy.IndirectionHandler")) : class$org$apache$ojb$broker$core$proxy$IndirectionHandler).warn("Can not materialize object for Identity " + this._id + " - using PBKey " + this._brokerKey);
            }
            Object object2 = object;
            return object2;
        }
        catch (Exception exception) {
            throw new PersistenceBrokerException(exception);
        }
        finally {
            this.releaseBroker();
        }
    }

    public boolean alreadyMaterialized() {
        return this._realSubject != null;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

