/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.core.proxy;

import java.lang.reflect.Proxy;
import org.apache.ojb.broker.PersistenceBrokerException;
import org.apache.ojb.broker.core.proxy.CollectionProxy;
import org.apache.ojb.broker.core.proxy.IndirectionHandler;
import org.apache.ojb.broker.core.proxy.VirtualProxy;
import org.apache.ojb.broker.util.logging.Logger;
import org.apache.ojb.broker.util.logging.LoggerFactory;

public class ProxyHelper {
    private static Logger log = LoggerFactory.getLogger(class$org$apache$ojb$broker$core$proxy$ProxyHelper == null ? (class$org$apache$ojb$broker$core$proxy$ProxyHelper = ProxyHelper.class$("org.apache.ojb.broker.core.proxy.ProxyHelper")) : class$org$apache$ojb$broker$core$proxy$ProxyHelper);
    static /* synthetic */ Class class$org$apache$ojb$broker$core$proxy$ProxyHelper;
    static /* synthetic */ Class class$org$apache$ojb$broker$core$proxy$IndirectionHandler;

    public static final Object getRealObject(Object object) {
        if (ProxyHelper.isNormalOjbProxy(object)) {
            try {
                return ((IndirectionHandler)Proxy.getInvocationHandler(object)).getRealSubject();
            }
            catch (ClassCastException classCastException) {
                String string = "The InvocationHandler for the provided Proxy was not an instance of " + (class$org$apache$ojb$broker$core$proxy$IndirectionHandler == null ? (class$org$apache$ojb$broker$core$proxy$IndirectionHandler = ProxyHelper.class$("org.apache.ojb.broker.core.proxy.IndirectionHandler")) : class$org$apache$ojb$broker$core$proxy$IndirectionHandler).getName();
                log.error(string);
                throw new PersistenceBrokerException(string, classCastException);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                String string = "Could not retrieve real object for given Proxy: " + object;
                log.error(string);
                throw new PersistenceBrokerException(string, illegalArgumentException);
            }
            catch (PersistenceBrokerException persistenceBrokerException) {
                log.error("Could not retrieve real object for given Proxy: " + object);
                throw persistenceBrokerException;
            }
        }
        if (ProxyHelper.isVirtualOjbProxy(object)) {
            try {
                return ((VirtualProxy)object).getRealSubject();
            }
            catch (PersistenceBrokerException persistenceBrokerException) {
                log.error("Could not retrieve real object for VirtualProxy: " + object);
                throw persistenceBrokerException;
            }
        }
        return object;
    }

    public static final Object getRealObjectIfMaterialized(Object object) {
        if (ProxyHelper.isNormalOjbProxy(object)) {
            try {
                IndirectionHandler indirectionHandler = (IndirectionHandler)Proxy.getInvocationHandler(object);
                return indirectionHandler.alreadyMaterialized() ? indirectionHandler.getRealSubject() : null;
            }
            catch (ClassCastException classCastException) {
                String string = "The InvocationHandler for the provided Proxy was not an instance of " + (class$org$apache$ojb$broker$core$proxy$IndirectionHandler == null ? (class$org$apache$ojb$broker$core$proxy$IndirectionHandler = ProxyHelper.class$("org.apache.ojb.broker.core.proxy.IndirectionHandler")) : class$org$apache$ojb$broker$core$proxy$IndirectionHandler).getName();
                log.error(string);
                throw new PersistenceBrokerException(string, classCastException);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                String string = "Could not retrieve real object for given Proxy: " + object;
                log.error(string);
                throw new PersistenceBrokerException(string, illegalArgumentException);
            }
            catch (PersistenceBrokerException persistenceBrokerException) {
                log.error("Could not retrieve real object for given Proxy: " + object);
                throw persistenceBrokerException;
            }
        }
        if (ProxyHelper.isVirtualOjbProxy(object)) {
            try {
                VirtualProxy virtualProxy = (VirtualProxy)object;
                return virtualProxy.alreadyMaterialized() ? virtualProxy.getRealSubject() : null;
            }
            catch (PersistenceBrokerException persistenceBrokerException) {
                log.error("Could not retrieve real object for VirtualProxy: " + object);
                throw persistenceBrokerException;
            }
        }
        return object;
    }

    public static final Class getRealClass(Object object) {
        if (ProxyHelper.isNormalOjbProxy(object)) {
            try {
                IndirectionHandler indirectionHandler = (IndirectionHandler)Proxy.getInvocationHandler(object);
                return indirectionHandler.getIdentity().getObjectsRealClass();
            }
            catch (ClassCastException classCastException) {
                String string = "The InvocationHandler for the provided Proxy was not an instance of " + (class$org$apache$ojb$broker$core$proxy$IndirectionHandler == null ? (class$org$apache$ojb$broker$core$proxy$IndirectionHandler = ProxyHelper.class$("org.apache.ojb.broker.core.proxy.IndirectionHandler")) : class$org$apache$ojb$broker$core$proxy$IndirectionHandler).getName();
                log.error(string);
                throw new PersistenceBrokerException(string, classCastException);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                String string = "Could not retrieve real object for given Proxy: " + object;
                log.error(string);
                throw new PersistenceBrokerException(string, illegalArgumentException);
            }
        }
        if (ProxyHelper.isVirtualOjbProxy(object)) {
            IndirectionHandler indirectionHandler = VirtualProxy.getIndirectionHandler((VirtualProxy)object);
            return indirectionHandler.getIdentity().getObjectsRealClass();
        }
        return object.getClass();
    }

    public static boolean isNormalOjbProxy(Object object) {
        return object instanceof Proxy && Proxy.isProxyClass(object.getClass()) && Proxy.getInvocationHandler(object) instanceof IndirectionHandler;
    }

    public static boolean isVirtualOjbProxy(Object object) {
        return object instanceof VirtualProxy;
    }

    public static boolean isProxy(Object object) {
        return ProxyHelper.isNormalOjbProxy(object) || ProxyHelper.isVirtualOjbProxy(object);
    }

    public static IndirectionHandler getIndirectionHandler(Object object) {
        if (object == null) {
            return null;
        }
        if (ProxyHelper.isNormalOjbProxy(object)) {
            return (IndirectionHandler)Proxy.getInvocationHandler(object);
        }
        if (ProxyHelper.isVirtualOjbProxy(object)) {
            return VirtualProxy.getIndirectionHandler((VirtualProxy)object);
        }
        return null;
    }

    public static boolean isMaterialized(Object object) {
        IndirectionHandler indirectionHandler = ProxyHelper.getIndirectionHandler(object);
        return indirectionHandler == null ? true : indirectionHandler.alreadyMaterialized();
    }

    public static String toString(Object object) {
        IndirectionHandler indirectionHandler = ProxyHelper.getIndirectionHandler(object);
        if (indirectionHandler != null && indirectionHandler.alreadyMaterialized()) {
            return "unmaterialized proxy for " + indirectionHandler.getIdentity();
        }
        return object.toString();
    }

    public static CollectionProxy getCollectionProxy(Object object) {
        if (ProxyHelper.isCollectionProxy(object)) {
            return (CollectionProxy)object;
        }
        return null;
    }

    public static boolean isCollectionProxy(Object object) {
        return object instanceof CollectionProxy;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

