/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.metadata;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.SerializationUtils;
import org.apache.commons.lang.SystemUtils;
import org.apache.ojb.broker.PBKey;
import org.apache.ojb.broker.metadata.JdbcConnectionDescriptor;
import org.apache.ojb.broker.metadata.MetadataException;
import org.apache.ojb.broker.metadata.XmlCapable;
import org.apache.ojb.broker.util.logging.Logger;
import org.apache.ojb.broker.util.logging.LoggerFactory;

public class ConnectionRepository
implements Serializable,
XmlCapable {
    private static final long serialVersionUID = -5581126412817848887L;
    private static Logger log = LoggerFactory.getLogger(class$org$apache$ojb$broker$metadata$ConnectionRepository == null ? (class$org$apache$ojb$broker$metadata$ConnectionRepository = ConnectionRepository.class$("org.apache.ojb.broker.metadata.ConnectionRepository")) : class$org$apache$ojb$broker$metadata$ConnectionRepository);
    private static HashMap jdbcSubProtocolToPlatform = new HashMap();
    private HashMap jcdMap = new HashMap();
    private Hashtable jcdAliasToPBKeyMap = new Hashtable();
    static /* synthetic */ Class class$org$apache$ojb$broker$metadata$ConnectionRepository;
    static /* synthetic */ Class class$org$apache$ojb$broker$metadata$JdbcConnectionDescriptor;

    public JdbcConnectionDescriptor getDescriptor(PBKey pBKey) {
        JdbcConnectionDescriptor jdbcConnectionDescriptor = (JdbcConnectionDescriptor)this.jcdMap.get(pBKey);
        if (jdbcConnectionDescriptor == null) {
            jdbcConnectionDescriptor = this.deepCopyOfFirstFound(pBKey.getAlias());
            if (jdbcConnectionDescriptor != null) {
                jdbcConnectionDescriptor.setUserName(pBKey.getUser());
                jdbcConnectionDescriptor.setPassWord(pBKey.getPassword());
                jdbcConnectionDescriptor.setDefaultConnection(false);
                log.info("Automatic create of new jdbc-connection-descriptor for PBKey " + pBKey);
                this.addDescriptor(jdbcConnectionDescriptor);
            } else {
                log.info("Could not find " + (class$org$apache$ojb$broker$metadata$JdbcConnectionDescriptor == null ? (class$org$apache$ojb$broker$metadata$JdbcConnectionDescriptor = ConnectionRepository.class$("org.apache.ojb.broker.metadata.JdbcConnectionDescriptor")) : class$org$apache$ojb$broker$metadata$JdbcConnectionDescriptor).getName() + " for PBKey " + pBKey);
            }
        }
        return jdbcConnectionDescriptor;
    }

    private JdbcConnectionDescriptor deepCopyOfFirstFound(String string) {
        Iterator iterator = this.jcdMap.values().iterator();
        while (iterator.hasNext()) {
            JdbcConnectionDescriptor jdbcConnectionDescriptor = (JdbcConnectionDescriptor)iterator.next();
            if (!string.equals(jdbcConnectionDescriptor.getJcdAlias())) continue;
            return (JdbcConnectionDescriptor)SerializationUtils.clone((Serializable)jdbcConnectionDescriptor);
        }
        return null;
    }

    public PBKey getStandardPBKeyForJcdAlias(String string) {
        return (PBKey)this.jcdAliasToPBKeyMap.get(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDescriptor(JdbcConnectionDescriptor jdbcConnectionDescriptor) {
        HashMap hashMap = this.jcdMap;
        synchronized (hashMap) {
            if (this.jcdMap.containsKey(jdbcConnectionDescriptor.getPBKey())) {
                throw new MetadataException("Found duplicate connection descriptor using PBKey " + jdbcConnectionDescriptor.getPBKey() + ", remove the old descriptor first, before add the new one. " + jdbcConnectionDescriptor);
            }
            this.jcdMap.put(jdbcConnectionDescriptor.getPBKey(), jdbcConnectionDescriptor);
            if (!this.jcdAliasToPBKeyMap.containsKey(jdbcConnectionDescriptor.getJcdAlias())) {
                this.jcdAliasToPBKeyMap.put(jdbcConnectionDescriptor.getJcdAlias(), jdbcConnectionDescriptor.getPBKey());
            }
            if (log.isDebugEnabled()) {
                log.debug("New descriptor was added: " + jdbcConnectionDescriptor);
            }
        }
    }

    public JdbcConnectionDescriptor addDescriptor(String string, String string2, String string3, String string4, String string5) {
        JdbcConnectionDescriptor jdbcConnectionDescriptor = new JdbcConnectionDescriptor();
        int n = string3.indexOf(58);
        jdbcConnectionDescriptor.setProtocol(string3.substring(0, n));
        int n2 = n;
        n = string3.indexOf(58, n2 + 1);
        String string6 = string3.substring(n2 + 1, n);
        jdbcConnectionDescriptor.setSubProtocol(string6);
        jdbcConnectionDescriptor.setDbAlias(string3.substring(n + 1));
        String string7 = (String)jdbcSubProtocolToPlatform.get(string6);
        jdbcConnectionDescriptor.setDbms(string7);
        jdbcConnectionDescriptor.setJcdAlias(string);
        jdbcConnectionDescriptor.setJdbcLevel(2.0);
        jdbcConnectionDescriptor.setDriver(string2);
        if ("default".equals(string)) {
            jdbcConnectionDescriptor.setDefaultConnection(true);
        }
        if (string4 != null) {
            jdbcConnectionDescriptor.setUserName(string4);
            jdbcConnectionDescriptor.setPassWord(string5);
        }
        this.addDescriptor(jdbcConnectionDescriptor);
        return jdbcConnectionDescriptor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDescriptor(Object object) {
        PBKey pBKey;
        if (object instanceof PBKey) {
            pBKey = (PBKey)object;
        } else if (object instanceof JdbcConnectionDescriptor) {
            pBKey = ((JdbcConnectionDescriptor)object).getPBKey();
        } else {
            throw new MetadataException("Could not remove descriptor, given object was no vaild key: " + object);
        }
        Object var3_3 = null;
        HashMap hashMap = this.jcdMap;
        synchronized (hashMap) {
            var3_3 = this.jcdMap.remove(pBKey);
            this.jcdAliasToPBKeyMap.remove(pBKey.getAlias());
        }
        log.info("Remove descriptor: " + var3_3);
    }

    public List getAllDescriptor() {
        return (List)SerializationUtils.clone(new ArrayList(this.jcdMap.values()));
    }

    public String toXML() {
        String string = SystemUtils.LINE_SEPARATOR;
        HashMap hashMap = (HashMap)this.jcdMap.clone();
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = hashMap.values().iterator();
        while (iterator.hasNext()) {
            JdbcConnectionDescriptor jdbcConnectionDescriptor = (JdbcConnectionDescriptor)iterator.next();
            stringBuffer.append(jdbcConnectionDescriptor.toXML());
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        jdbcSubProtocolToPlatform.put("db2", "Db2");
        jdbcSubProtocolToPlatform.put("firebirdsql", "Firebird");
        jdbcSubProtocolToPlatform.put("hsqldb", "Hsqldb");
        jdbcSubProtocolToPlatform.put("informix-sqli", "Informix");
        jdbcSubProtocolToPlatform.put("sapdb", "MaxDB");
        jdbcSubProtocolToPlatform.put("odbc", "MsAccess");
        jdbcSubProtocolToPlatform.put("inetdae7a", "MsSQLServer");
        jdbcSubProtocolToPlatform.put("inetdae7", "MsSQLServer");
        jdbcSubProtocolToPlatform.put("inetdae6", "MsSQLServer");
        jdbcSubProtocolToPlatform.put("inetdae", "MsSQLServer");
        jdbcSubProtocolToPlatform.put("inetpool", "MsSQLServer");
        jdbcSubProtocolToPlatform.put("mysql", "MySQL");
        jdbcSubProtocolToPlatform.put("oracle", "Oracle");
        jdbcSubProtocolToPlatform.put("inetora", "Oracle");
        jdbcSubProtocolToPlatform.put("postgresql", "PostgreSQL");
        jdbcSubProtocolToPlatform.put("sybase", "Sybase");
    }
}

