/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.metadata;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Properties;
import org.apache.commons.lang.SystemUtils;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.apache.ojb.broker.metadata.AttributeContainer;
import org.apache.ojb.broker.metadata.JdbcConnectionDescriptor;
import org.apache.ojb.broker.metadata.RepositoryTags;
import org.apache.ojb.broker.metadata.XmlCapable;

public class SequenceDescriptor
implements Serializable,
XmlCapable,
AttributeContainer {
    private static final long serialVersionUID = -5161713731380949398L;
    private JdbcConnectionDescriptor jcd;
    private Class sequenceManagerClass;
    private Properties configurationProperties;

    public SequenceDescriptor(JdbcConnectionDescriptor jdbcConnectionDescriptor) {
        this.jcd = jdbcConnectionDescriptor;
        this.configurationProperties = new Properties();
    }

    public SequenceDescriptor(JdbcConnectionDescriptor jdbcConnectionDescriptor, Class clazz) {
        this(jdbcConnectionDescriptor);
        this.sequenceManagerClass = clazz;
    }

    public JdbcConnectionDescriptor getJdbcConnectionDescriptor() {
        return this.jcd;
    }

    public void setJdbcConnectionDescriptor(JdbcConnectionDescriptor jdbcConnectionDescriptor) {
        this.jcd = jdbcConnectionDescriptor;
    }

    public Class getSequenceManagerClass() {
        return this.sequenceManagerClass;
    }

    public void setSequenceManagerClass(Class clazz) {
        this.sequenceManagerClass = clazz;
    }

    public void addAttribute(String string, String string2) {
        this.configurationProperties.setProperty(string, string2);
    }

    public String getAttribute(String string) {
        return this.getAttribute(string, null);
    }

    public String getAttribute(String string, String string2) {
        String string3 = this.configurationProperties.getProperty(string);
        if (string3 == null) {
            string3 = string2;
        }
        return string3;
    }

    public Properties getConfigurationProperties() {
        return this.configurationProperties;
    }

    public void setConfigurationProperties(Properties properties) {
        this.configurationProperties = properties;
    }

    public String toString() {
        ToStringBuilder toStringBuilder = new ToStringBuilder((Object)this, ToStringStyle.MULTI_LINE_STYLE);
        toStringBuilder.append("   sequenceManagerClass", (Object)this.getSequenceManagerClass()).append("   Properties", (Object)this.getConfigurationProperties());
        return toStringBuilder.toString();
    }

    public String toXML() {
        RepositoryTags repositoryTags = RepositoryTags.getInstance();
        String string = SystemUtils.LINE_SEPARATOR;
        StringBuffer stringBuffer = new StringBuffer(1024);
        stringBuffer.append("      ");
        stringBuffer.append(repositoryTags.getOpeningTagNonClosingById(88));
        stringBuffer.append(string);
        stringBuffer.append("         ");
        stringBuffer.append(repositoryTags.getAttribute(89, "" + this.getSequenceManagerClass().getName()));
        stringBuffer.append("      >");
        stringBuffer.append(string);
        stringBuffer.append("         <!-- ");
        stringBuffer.append(string);
        stringBuffer.append("         Add sequence manger properties here, using custom attributes");
        stringBuffer.append(string);
        stringBuffer.append("         e.g. <attribute attribute-name=\"grabSize\" attribute-value=\"20\"/>");
        stringBuffer.append(string);
        stringBuffer.append("         -->");
        stringBuffer.append(string);
        stringBuffer.append(this.buildAttributes());
        stringBuffer.append("      ");
        stringBuffer.append(repositoryTags.getClosingTagById(88));
        stringBuffer.append(string);
        return stringBuffer.toString();
    }

    private String buildAttributes() {
        String string = SystemUtils.LINE_SEPARATOR;
        Properties properties = this.getConfigurationProperties();
        if (properties == null || properties.isEmpty()) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        Enumeration<Object> enumeration = properties.keys();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            String string3 = properties.getProperty(string2);
            stringBuffer.append("         <attribute attribute-name=\"");
            stringBuffer.append(string2);
            stringBuffer.append("\" attribute-value=\"");
            stringBuffer.append(string3);
            stringBuffer.append("\"/>");
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }
}

