/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.platforms;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;
import org.apache.ojb.broker.metadata.JdbcConnectionDescriptor;
import org.apache.ojb.broker.metadata.JdbcType;
import org.apache.ojb.broker.platforms.Oracle9iLobHandler;
import org.apache.ojb.broker.platforms.PlatformException;
import org.apache.ojb.broker.platforms.PlatformOracleImpl;
import org.apache.ojb.broker.util.ClassHelper;
import org.apache.ojb.broker.util.JdbcTypesHelper;

public class PlatformOracle9iImpl
extends PlatformOracleImpl {
    protected static final int STATEMENT_CACHE_SIZE = 100;
    protected static final int ROW_PREFETCH_SIZE = 100;
    protected static final int STATEMENTS_PER_BATCH = 20;
    protected static Map m_batchStatementsInProgress = Collections.synchronizedMap(new WeakHashMap(20));
    protected static final Class[] PARAM_TYPE_INTEGER = new Class[]{Integer.TYPE};
    protected static final Class[] PARAM_TYPE_BOOLEAN = new Class[]{Boolean.TYPE};
    protected static final Class[] PARAM_TYPE_STRING = new Class[]{class$java$lang$String == null ? (class$java$lang$String = PlatformOracle9iImpl.class$("java.lang.String")) : class$java$lang$String};
    protected static final Object[] PARAM_STATEMENT_CACHE_SIZE = new Object[]{new Integer(100)};
    protected static final Object[] PARAM_ROW_PREFETCH_SIZE = new Object[]{new Integer(100)};
    protected static final Object[] PARAM_STATEMENT_BATCH_SIZE = new Object[]{new Integer(20)};
    protected static final Object[] PARAM_BOOLEAN_TRUE = new Object[]{Boolean.TRUE};
    protected static final JdbcType BASE_CLOB = JdbcTypesHelper.getJdbcTypeByName("clob");
    protected static final JdbcType BASE_BLOB = JdbcTypesHelper.getJdbcTypeByName("blob");
    static /* synthetic */ Class class$java$lang$String;

    public void initializeJdbcConnection(JdbcConnectionDescriptor jdbcConnectionDescriptor, Connection connection) throws PlatformException {
        boolean bl;
        super.initializeJdbcConnection(jdbcConnectionDescriptor, connection);
        Method method = ClassHelper.getMethod(connection, "setStatementCacheSize", PARAM_TYPE_INTEGER);
        Method method2 = ClassHelper.getMethod(connection, "setImplicitCachingEnabled", PARAM_TYPE_BOOLEAN);
        boolean bl2 = bl = method != null && method2 != null;
        if (bl) {
            try {
                method.invoke((Object)connection, PARAM_STATEMENT_CACHE_SIZE);
                method2.invoke((Object)connection, PARAM_BOOLEAN_TRUE);
            }
            catch (Exception exception) {
                throw new PlatformException(exception.getLocalizedMessage(), exception);
            }
        }
    }

    public void afterStatementCreate(Statement statement) throws PlatformException {
        boolean bl;
        super.afterStatementCreate(statement);
        Method method = ClassHelper.getMethod(statement, "setRowPrefetch", PARAM_TYPE_INTEGER);
        boolean bl2 = bl = method != null;
        if (bl) {
            try {
                method.invoke((Object)statement, PARAM_ROW_PREFETCH_SIZE);
            }
            catch (Exception exception) {
                throw new PlatformException(exception.getLocalizedMessage(), exception);
            }
        }
    }

    public void beforeBatch(PreparedStatement preparedStatement) throws PlatformException {
        boolean bl;
        Method method = ClassHelper.getMethod(preparedStatement, "setExecuteBatch", PARAM_TYPE_INTEGER);
        Method method2 = ClassHelper.getMethod(preparedStatement, "sendBatch", null);
        boolean bl2 = bl = method != null && method2 != null;
        if (bl) {
            try {
                method.invoke((Object)preparedStatement, PARAM_STATEMENT_BATCH_SIZE);
                m_batchStatementsInProgress.put(preparedStatement, method2);
            }
            catch (Exception exception) {
                throw new PlatformException(exception.getLocalizedMessage(), exception);
            }
        } else {
            super.beforeBatch(preparedStatement);
        }
    }

    public void addBatch(PreparedStatement preparedStatement) throws PlatformException {
        boolean bl = m_batchStatementsInProgress.containsKey(preparedStatement);
        if (bl) {
            try {
                preparedStatement.executeUpdate();
            }
            catch (SQLException sQLException) {
                throw new PlatformException(sQLException.getLocalizedMessage(), sQLException);
            }
        } else {
            super.addBatch(preparedStatement);
        }
    }

    public int[] executeBatch(PreparedStatement preparedStatement) throws PlatformException {
        Method method = (Method)m_batchStatementsInProgress.remove(preparedStatement);
        boolean bl = method != null;
        int[] nArray = null;
        if (bl) {
            try {
                method.invoke((Object)preparedStatement, null);
            }
            catch (Exception exception) {
                throw new PlatformException(exception.getLocalizedMessage(), exception);
            }
        } else {
            nArray = super.executeBatch(preparedStatement);
        }
        return nArray;
    }

    public void setObjectForStatement(PreparedStatement preparedStatement, int n, Object object, int n2) throws SQLException {
        Object object2;
        boolean bl = false;
        boolean bl2 = false;
        Method method = null;
        Method method2 = null;
        if (n2 == 2005) {
            try {
                object2 = ClassHelper.getClass("oracle.sql.CLOB", false);
                method2 = ClassHelper.getMethod(preparedStatement, "setCLOB", new Class[]{Integer.TYPE, object2});
                bl2 = method2 != null;
            }
            catch (Exception exception) {}
        } else if (n2 == 2004) {
            try {
                object2 = ClassHelper.getClass("oracle.sql.BLOB", false);
                method = ClassHelper.getMethod(preparedStatement, "setBLOB", new Class[]{Integer.TYPE, object2});
                bl = method != null;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if ((n2 == -3 || n2 == -4) && object instanceof byte[]) {
            object2 = (byte[])object;
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream((byte[])object2);
            super.changePreparedStatementResultSetType(preparedStatement);
            preparedStatement.setBinaryStream(n, (InputStream)byteArrayInputStream, ((Object)object2).length);
        } else if (object instanceof Double) {
            preparedStatement.setDouble(n, (Double)object);
        } else if (n2 == -5 && object instanceof Integer) {
            preparedStatement.setLong(n, ((Integer)object).intValue());
        } else if (n2 == 4 && object instanceof Long) {
            preparedStatement.setLong(n, (Long)object);
        } else if (n2 == 2005 && bl2 && object instanceof String) {
            try {
                object2 = Oracle9iLobHandler.createCLOBFromString(preparedStatement.getConnection(), (String)object);
                method2.invoke((Object)preparedStatement, new Integer(n), object2);
            }
            catch (Exception exception) {
                throw new SQLException(exception.getLocalizedMessage());
            }
        } else if (n2 == 2004 && bl && object instanceof byte[]) {
            try {
                object2 = Oracle9iLobHandler.createBLOBFromByteArray(preparedStatement.getConnection(), (byte[])object);
                method.invoke((Object)preparedStatement, new Integer(n), object2);
            }
            catch (Exception exception) {
                throw new SQLException(exception.getLocalizedMessage());
            }
        } else {
            super.setObjectForStatement(preparedStatement, n, object, n2);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

