/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.BooleanUtils;
import org.apache.ojb.broker.OJBRuntimeException;
import org.apache.ojb.broker.metadata.JdbcType;
import org.apache.ojb.broker.util.sequence.SequenceManagerException;

public final class JdbcTypesHelper {
    private static Map jdbcObjectTypesFromType = new HashMap();
    private static Map jdbcObjectTypesFromName = new HashMap();
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$util$Date;
    static /* synthetic */ Class class$java$sql$Date;
    static /* synthetic */ Class class$java$sql$Time;
    static /* synthetic */ Class class$java$sql$Timestamp;
    static /* synthetic */ Class class$java$math$BigDecimal;
    static /* synthetic */ Class class$java$sql$Ref;
    static /* synthetic */ Class class$java$sql$Struct;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$net$URL;
    static /* synthetic */ Class class$java$sql$Types;

    public static JdbcType getJdbcTypeByTypesIndex(Integer n) {
        return (JdbcType)jdbcObjectTypesFromType.get(n);
    }

    public static JdbcType getJdbcTypeByName(String string) {
        JdbcType jdbcType = null;
        jdbcType = (JdbcType)jdbcObjectTypesFromName.get(string.toLowerCase());
        if (jdbcType == null) {
            throw new OJBRuntimeException("The type " + string + " can not be handled by OJB." + " Please specify only types as defined by java.sql.Types.");
        }
        return jdbcType;
    }

    public static JdbcType getJdbcTypeByReflection(String string) {
        JdbcType jdbcType;
        if (string.equalsIgnoreCase((class$java$lang$Character == null ? (class$java$lang$Character = JdbcTypesHelper.class$("java.lang.Character")) : class$java$lang$Character).getName()) || string.equalsIgnoreCase("char")) {
            jdbcType = JdbcTypesHelper.getJdbcTypeByName("char");
        } else if (string.equalsIgnoreCase((class$java$lang$Short == null ? (class$java$lang$Short = JdbcTypesHelper.class$("java.lang.Short")) : class$java$lang$Short).getName()) || string.equalsIgnoreCase("short")) {
            jdbcType = JdbcTypesHelper.getJdbcTypeByName("smallint");
        } else if (string.equalsIgnoreCase((class$java$lang$Integer == null ? (class$java$lang$Integer = JdbcTypesHelper.class$("java.lang.Integer")) : class$java$lang$Integer).getName()) || string.equalsIgnoreCase("int")) {
            jdbcType = JdbcTypesHelper.getJdbcTypeByName("integer");
        } else if (string.equalsIgnoreCase((class$java$lang$Long == null ? (class$java$lang$Long = JdbcTypesHelper.class$("java.lang.Long")) : class$java$lang$Long).getName()) || string.equalsIgnoreCase("long")) {
            jdbcType = JdbcTypesHelper.getJdbcTypeByName("bigint");
        } else if (string.equalsIgnoreCase((class$java$lang$Byte == null ? (class$java$lang$Byte = JdbcTypesHelper.class$("java.lang.Byte")) : class$java$lang$Byte).getName()) || string.equalsIgnoreCase("byte")) {
            jdbcType = JdbcTypesHelper.getJdbcTypeByName("tinyint");
        } else if (string.equalsIgnoreCase((class$java$lang$Float == null ? (class$java$lang$Float = JdbcTypesHelper.class$("java.lang.Float")) : class$java$lang$Float).getName()) || string.equalsIgnoreCase("float")) {
            jdbcType = JdbcTypesHelper.getJdbcTypeByName("real");
        } else if (string.equalsIgnoreCase((class$java$lang$Double == null ? (class$java$lang$Double = JdbcTypesHelper.class$("java.lang.Double")) : class$java$lang$Double).getName()) || string.equalsIgnoreCase("double")) {
            jdbcType = JdbcTypesHelper.getJdbcTypeByName("float");
        } else if (string.equalsIgnoreCase((class$java$lang$String == null ? (class$java$lang$String = JdbcTypesHelper.class$("java.lang.String")) : class$java$lang$String).getName())) {
            jdbcType = JdbcTypesHelper.getJdbcTypeByName("varchar");
        } else if (string.equalsIgnoreCase((class$java$util$Date == null ? (class$java$util$Date = JdbcTypesHelper.class$("java.util.Date")) : class$java$util$Date).getName())) {
            jdbcType = JdbcTypesHelper.getJdbcTypeByName("date");
        } else if (string.equalsIgnoreCase((class$java$sql$Date == null ? (class$java$sql$Date = JdbcTypesHelper.class$("java.sql.Date")) : class$java$sql$Date).getName())) {
            jdbcType = JdbcTypesHelper.getJdbcTypeByName("date");
        } else if (string.equalsIgnoreCase((class$java$sql$Time == null ? (class$java$sql$Time = JdbcTypesHelper.class$("java.sql.Time")) : class$java$sql$Time).getName())) {
            jdbcType = JdbcTypesHelper.getJdbcTypeByName("time");
        } else if (string.equalsIgnoreCase((class$java$sql$Timestamp == null ? (class$java$sql$Timestamp = JdbcTypesHelper.class$("java.sql.Timestamp")) : class$java$sql$Timestamp).getName())) {
            jdbcType = JdbcTypesHelper.getJdbcTypeByName("timestamp");
        } else if (string.equalsIgnoreCase((class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = JdbcTypesHelper.class$("java.math.BigDecimal")) : class$java$math$BigDecimal).getName())) {
            jdbcType = JdbcTypesHelper.getJdbcTypeByName("decimal");
        } else if (string.equalsIgnoreCase((class$java$sql$Ref == null ? (class$java$sql$Ref = JdbcTypesHelper.class$("java.sql.Ref")) : class$java$sql$Ref).getName())) {
            jdbcType = JdbcTypesHelper.getJdbcTypeByName("ref");
        } else if (string.equalsIgnoreCase((class$java$sql$Struct == null ? (class$java$sql$Struct = JdbcTypesHelper.class$("java.sql.Struct")) : class$java$sql$Struct).getName())) {
            jdbcType = JdbcTypesHelper.getJdbcTypeByName("struct");
        } else if (string.equalsIgnoreCase((class$java$lang$Boolean == null ? (class$java$lang$Boolean = JdbcTypesHelper.class$("java.lang.Boolean")) : class$java$lang$Boolean).getName()) || string.equalsIgnoreCase("boolean")) {
            jdbcType = JdbcTypesHelper.getJdbcTypeByName("bit");
        } else if (string.equalsIgnoreCase((class$java$net$URL == null ? (class$java$net$URL = JdbcTypesHelper.class$("java.net.URL")) : class$java$net$URL).getName())) {
            jdbcType = JdbcTypesHelper.getJdbcTypeByName("datalink");
        } else {
            throw new OJBRuntimeException("The type " + string + " can not be handled by OJB automatically." + " Please specify a type as defined by java.sql.Types in your field-descriptor");
        }
        return jdbcType;
    }

    public static Object getObjectFromColumn(ResultSet resultSet, Integer n, int n2) throws SQLException {
        return JdbcTypesHelper.getObjectFromColumn(resultSet, null, n, null, n2);
    }

    private static Object getObjectFromColumn(ResultSet resultSet, CallableStatement callableStatement, Integer n, String string, int n2) throws SQLException {
        return JdbcTypesHelper.getJdbcTypeByTypesIndex(n).getObjectFromColumn(resultSet, callableStatement, string, n2);
    }

    public static String getJdbcTypeAsString(int n) {
        Field[] fieldArray = (class$java$sql$Types == null ? (class$java$sql$Types = JdbcTypesHelper.class$("java.sql.Types")) : class$java$sql$Types).getFields();
        for (int i = 0; i < fieldArray.length; ++i) {
            try {
                Field field = fieldArray[i];
                int n2 = field.getInt(null);
                if (n2 != n) continue;
                return field.getName();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return "UNKNOWN_TYPE";
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        jdbcObjectTypesFromType.put(new Integer(2003), new T_Array());
        jdbcObjectTypesFromType.put(new Integer(-5), new T_BigInt());
        jdbcObjectTypesFromType.put(new Integer(-2), new T_Binary());
        jdbcObjectTypesFromType.put(new Integer(-7), new T_Bit());
        jdbcObjectTypesFromType.put(new Integer(2004), new T_Blob());
        jdbcObjectTypesFromType.put(new Integer(1), new T_Char());
        jdbcObjectTypesFromType.put(new Integer(2005), new T_Clob());
        jdbcObjectTypesFromType.put(new Integer(91), new T_Date());
        jdbcObjectTypesFromType.put(new Integer(3), new T_Decimal());
        jdbcObjectTypesFromType.put(new Integer(8), new T_Double());
        jdbcObjectTypesFromType.put(new Integer(6), new T_Float());
        jdbcObjectTypesFromType.put(new Integer(4), new T_Integer());
        jdbcObjectTypesFromType.put(new Integer(-4), new T_LongVarBinary());
        jdbcObjectTypesFromType.put(new Integer(-1), new T_LongVarChar());
        jdbcObjectTypesFromType.put(new Integer(2), new T_Numeric());
        jdbcObjectTypesFromType.put(new Integer(7), new T_Real());
        jdbcObjectTypesFromType.put(new Integer(2006), new T_Ref());
        jdbcObjectTypesFromType.put(new Integer(5), new T_SmallInt());
        jdbcObjectTypesFromType.put(new Integer(2002), new T_Struct());
        jdbcObjectTypesFromType.put(new Integer(92), new T_Time());
        jdbcObjectTypesFromType.put(new Integer(93), new T_Timestamp());
        jdbcObjectTypesFromType.put(new Integer(-6), new T_TinyInt());
        jdbcObjectTypesFromType.put(new Integer(-3), new T_VarBinary());
        jdbcObjectTypesFromType.put(new Integer(12), new T_Varchar());
        jdbcObjectTypesFromType.put(new Integer(16), new T_Boolean());
        jdbcObjectTypesFromType.put(new Integer(70), new T_Datalink());
        jdbcObjectTypesFromName.put("array", jdbcObjectTypesFromType.get(new Integer(2003)));
        jdbcObjectTypesFromName.put("bigint", jdbcObjectTypesFromType.get(new Integer(-5)));
        jdbcObjectTypesFromName.put("binary", jdbcObjectTypesFromType.get(new Integer(-2)));
        jdbcObjectTypesFromName.put("bit", jdbcObjectTypesFromType.get(new Integer(-7)));
        jdbcObjectTypesFromName.put("blob", jdbcObjectTypesFromType.get(new Integer(2004)));
        jdbcObjectTypesFromName.put("char", jdbcObjectTypesFromType.get(new Integer(1)));
        jdbcObjectTypesFromName.put("clob", jdbcObjectTypesFromType.get(new Integer(2005)));
        jdbcObjectTypesFromName.put("date", jdbcObjectTypesFromType.get(new Integer(91)));
        jdbcObjectTypesFromName.put("decimal", jdbcObjectTypesFromType.get(new Integer(3)));
        jdbcObjectTypesFromName.put("double", jdbcObjectTypesFromType.get(new Integer(8)));
        jdbcObjectTypesFromName.put("float", jdbcObjectTypesFromType.get(new Integer(6)));
        jdbcObjectTypesFromName.put("integer", jdbcObjectTypesFromType.get(new Integer(4)));
        jdbcObjectTypesFromName.put("longvarbinary", jdbcObjectTypesFromType.get(new Integer(-4)));
        jdbcObjectTypesFromName.put("longvarchar", jdbcObjectTypesFromType.get(new Integer(-1)));
        jdbcObjectTypesFromName.put("numeric", jdbcObjectTypesFromType.get(new Integer(2)));
        jdbcObjectTypesFromName.put("real", jdbcObjectTypesFromType.get(new Integer(7)));
        jdbcObjectTypesFromName.put("ref", jdbcObjectTypesFromType.get(new Integer(2006)));
        jdbcObjectTypesFromName.put("smallint", jdbcObjectTypesFromType.get(new Integer(5)));
        jdbcObjectTypesFromName.put("struct", jdbcObjectTypesFromType.get(new Integer(2002)));
        jdbcObjectTypesFromName.put("time", jdbcObjectTypesFromType.get(new Integer(92)));
        jdbcObjectTypesFromName.put("timestamp", jdbcObjectTypesFromType.get(new Integer(93)));
        jdbcObjectTypesFromName.put("tinyint", jdbcObjectTypesFromType.get(new Integer(-6)));
        jdbcObjectTypesFromName.put("varbinary", jdbcObjectTypesFromType.get(new Integer(-3)));
        jdbcObjectTypesFromName.put("varchar", jdbcObjectTypesFromType.get(new Integer(12)));
        jdbcObjectTypesFromName.put("boolean", jdbcObjectTypesFromType.get(new Integer(16)));
        jdbcObjectTypesFromName.put("datalink", jdbcObjectTypesFromType.get(new Integer(70)));
    }

    public static final class T_Datalink
    extends BaseType {
        public Object sequenceKeyConversion(Long l) throws SequenceManagerException {
            throw new SequenceManagerException("Not supported sequence key type 'DATALINK'");
        }

        Object readValueFromStatement(CallableStatement callableStatement, int n) throws SQLException {
            return callableStatement.getURL(n);
        }

        Object readValueFromResultSet(ResultSet resultSet, String string) throws SQLException {
            return resultSet.getURL(string);
        }

        Object readValueFromResultSet(ResultSet resultSet, int n) throws SQLException {
            return resultSet.getURL(n);
        }

        public int getType() {
            return 70;
        }
    }

    public static final class T_Ref
    extends BaseType {
        public Object sequenceKeyConversion(Long l) throws SequenceManagerException {
            throw new SequenceManagerException("Not supported sequence key type 'REF'");
        }

        Object readValueFromStatement(CallableStatement callableStatement, int n) throws SQLException {
            return callableStatement.getRef(n);
        }

        Object readValueFromResultSet(ResultSet resultSet, String string) throws SQLException {
            return resultSet.getRef(string);
        }

        Object readValueFromResultSet(ResultSet resultSet, int n) throws SQLException {
            return resultSet.getRef(n);
        }

        public int getType() {
            return 2006;
        }
    }

    public static final class T_Struct
    extends BaseType {
        public Object sequenceKeyConversion(Long l) throws SequenceManagerException {
            throw new SequenceManagerException("Not supported sequence key type 'STRUCT'");
        }

        Object readValueFromStatement(CallableStatement callableStatement, int n) throws SQLException {
            return callableStatement.getObject(n);
        }

        Object readValueFromResultSet(ResultSet resultSet, String string) throws SQLException {
            return resultSet.getObject(string);
        }

        Object readValueFromResultSet(ResultSet resultSet, int n) throws SQLException {
            return resultSet.getObject(n);
        }

        public int getType() {
            return 2002;
        }
    }

    public static final class T_Array
    extends BaseType {
        public Object sequenceKeyConversion(Long l) throws SequenceManagerException {
            throw new SequenceManagerException("Not supported sequence key type 'ARRAY'");
        }

        Object readValueFromStatement(CallableStatement callableStatement, int n) throws SQLException {
            return callableStatement.getArray(n);
        }

        Object readValueFromResultSet(ResultSet resultSet, String string) throws SQLException {
            return resultSet.getArray(string);
        }

        Object readValueFromResultSet(ResultSet resultSet, int n) throws SQLException {
            return resultSet.getArray(n);
        }

        public int getType() {
            return 2003;
        }
    }

    public static final class T_Blob
    extends BaseType {
        public Object sequenceKeyConversion(Long l) throws SequenceManagerException {
            throw new SequenceManagerException("Not supported sequence key type 'BLOB'");
        }

        Object readValueFromStatement(CallableStatement callableStatement, int n) throws SQLException {
            Blob blob = callableStatement.getBlob(n);
            return callableStatement.wasNull() ? null : blob.getBytes(1L, (int)blob.length());
        }

        Object readValueFromResultSet(ResultSet resultSet, String string) throws SQLException {
            Blob blob = resultSet.getBlob(string);
            return resultSet.wasNull() ? null : blob.getBytes(1L, (int)blob.length());
        }

        Object readValueFromResultSet(ResultSet resultSet, int n) throws SQLException {
            Blob blob = resultSet.getBlob(n);
            return resultSet.wasNull() ? null : blob.getBytes(1L, (int)blob.length());
        }

        public int getType() {
            return 2004;
        }
    }

    public static final class T_Clob
    extends BaseType {
        protected static final int BUFSZ = 32768;

        protected static String safeClobToString(Clob clob) throws SQLException {
            long l = clob.length();
            if (l == 0L) {
                return "";
            }
            StringBuffer stringBuffer = new StringBuffer();
            char[] cArray = new char[32768];
            Reader reader = clob.getCharacterStream();
            try {
                int n;
                while ((n = reader.read(cArray)) != -1) {
                    stringBuffer.append(cArray, 0, n);
                }
                reader.close();
            }
            catch (IOException iOException) {
                throw new SQLException(iOException.getLocalizedMessage());
            }
            return stringBuffer.toString();
        }

        public Object sequenceKeyConversion(Long l) throws SequenceManagerException {
            throw new SequenceManagerException("Not supported sequence key type 'CLOB'");
        }

        Object readValueFromStatement(CallableStatement callableStatement, int n) throws SQLException {
            Clob clob = callableStatement.getClob(n);
            return callableStatement.wasNull() ? null : T_Clob.safeClobToString(clob);
        }

        Object readValueFromResultSet(ResultSet resultSet, String string) throws SQLException {
            Clob clob = resultSet.getClob(string);
            return resultSet.wasNull() ? null : T_Clob.safeClobToString(clob);
        }

        Object readValueFromResultSet(ResultSet resultSet, int n) throws SQLException {
            Clob clob = resultSet.getClob(n);
            return resultSet.wasNull() ? null : T_Clob.safeClobToString(clob);
        }

        public int getType() {
            return 2005;
        }
    }

    public static final class T_Timestamp
    extends BaseType {
        public Object sequenceKeyConversion(Long l) throws SequenceManagerException {
            return new Timestamp(l);
        }

        Object readValueFromStatement(CallableStatement callableStatement, int n) throws SQLException {
            return callableStatement.getTimestamp(n);
        }

        Object readValueFromResultSet(ResultSet resultSet, String string) throws SQLException {
            return resultSet.getTimestamp(string);
        }

        Object readValueFromResultSet(ResultSet resultSet, int n) throws SQLException {
            return resultSet.getTimestamp(n);
        }

        public int getType() {
            return 93;
        }
    }

    public static final class T_Time
    extends BaseType {
        public Object sequenceKeyConversion(Long l) throws SequenceManagerException {
            return new Time(l);
        }

        Object readValueFromStatement(CallableStatement callableStatement, int n) throws SQLException {
            return callableStatement.getTime(n);
        }

        Object readValueFromResultSet(ResultSet resultSet, String string) throws SQLException {
            return resultSet.getTime(string);
        }

        Object readValueFromResultSet(ResultSet resultSet, int n) throws SQLException {
            return resultSet.getTime(n);
        }

        public int getType() {
            return 92;
        }
    }

    public static final class T_Date
    extends BaseType {
        public Object sequenceKeyConversion(Long l) throws SequenceManagerException {
            return new Date(l);
        }

        Object readValueFromStatement(CallableStatement callableStatement, int n) throws SQLException {
            return callableStatement.getDate(n);
        }

        Object readValueFromResultSet(ResultSet resultSet, String string) throws SQLException {
            return resultSet.getDate(string);
        }

        Object readValueFromResultSet(ResultSet resultSet, int n) throws SQLException {
            return resultSet.getDate(n);
        }

        public int getType() {
            return 91;
        }
    }

    public static final class T_LongVarBinary
    extends BaseType {
        protected static final int BUFSZ = 2048;

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        protected static byte[] retrieveStreamDataFromRs(InputStream inputStream) throws SQLException {
            if (inputStream == null) {
                return null;
            }
            byte[] byArray = null;
            ByteArrayOutputStream byteArrayOutputStream = null;
            try {
                try {
                    int n;
                    byteArrayOutputStream = new ByteArrayOutputStream();
                    byte[] byArray2 = new byte[2048];
                    while ((n = inputStream.read(byArray2, 0, byArray2.length)) > 0) {
                        byteArrayOutputStream.write(byArray2, 0, n);
                    }
                    byArray = byteArrayOutputStream.toByteArray();
                }
                catch (IOException iOException) {
                    throw new SQLException("I/O exception retrieving LONGVARBINARY: " + iOException.getLocalizedMessage());
                }
                Object var6_6 = null;
                if (byteArrayOutputStream == null) return byArray;
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                if (byteArrayOutputStream == null) throw throwable;
                try {
                    byteArrayOutputStream.close();
                    throw throwable;
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw throwable;
            }
            try {}
            catch (Exception exception) {}
            byteArrayOutputStream.close();
            return byArray;
        }

        public Object sequenceKeyConversion(Long l) throws SequenceManagerException {
            return l.toString().getBytes();
        }

        Object readValueFromStatement(CallableStatement callableStatement, int n) throws SQLException {
            return callableStatement.getBytes(n);
        }

        Object readValueFromResultSet(ResultSet resultSet, String string) throws SQLException {
            return T_LongVarBinary.retrieveStreamDataFromRs(resultSet.getBinaryStream(string));
        }

        Object readValueFromResultSet(ResultSet resultSet, int n) throws SQLException {
            return T_LongVarBinary.retrieveStreamDataFromRs(resultSet.getBinaryStream(n));
        }

        public int getType() {
            return -4;
        }
    }

    public static final class T_VarBinary
    extends BaseType {
        public Object sequenceKeyConversion(Long l) throws SequenceManagerException {
            return l.toString().getBytes();
        }

        Object readValueFromStatement(CallableStatement callableStatement, int n) throws SQLException {
            return callableStatement.getBytes(n);
        }

        Object readValueFromResultSet(ResultSet resultSet, String string) throws SQLException {
            return resultSet.getBytes(string);
        }

        Object readValueFromResultSet(ResultSet resultSet, int n) throws SQLException {
            return resultSet.getBytes(n);
        }

        public int getType() {
            return -3;
        }
    }

    public static final class T_Binary
    extends BaseType {
        public Object sequenceKeyConversion(Long l) throws SequenceManagerException {
            return l.toString().getBytes();
        }

        Object readValueFromStatement(CallableStatement callableStatement, int n) throws SQLException {
            return callableStatement.getBytes(n);
        }

        Object readValueFromResultSet(ResultSet resultSet, String string) throws SQLException {
            return resultSet.getBytes(string);
        }

        Object readValueFromResultSet(ResultSet resultSet, int n) throws SQLException {
            return resultSet.getBytes(n);
        }

        public int getType() {
            return -2;
        }
    }

    public static final class T_Double
    extends BaseType {
        public Object sequenceKeyConversion(Long l) throws SequenceManagerException {
            return new Double(l.doubleValue());
        }

        Object readValueFromStatement(CallableStatement callableStatement, int n) throws SQLException {
            double d = callableStatement.getDouble(n);
            return callableStatement.wasNull() ? null : new Double(d);
        }

        Object readValueFromResultSet(ResultSet resultSet, String string) throws SQLException {
            double d = resultSet.getDouble(string);
            return resultSet.wasNull() ? null : new Double(d);
        }

        Object readValueFromResultSet(ResultSet resultSet, int n) throws SQLException {
            double d = resultSet.getDouble(n);
            return resultSet.wasNull() ? null : new Double(d);
        }

        public int getType() {
            return 8;
        }
    }

    public static final class T_Float
    extends BaseType {
        public Object sequenceKeyConversion(Long l) throws SequenceManagerException {
            return new Double(l.doubleValue());
        }

        Object readValueFromStatement(CallableStatement callableStatement, int n) throws SQLException {
            double d = callableStatement.getDouble(n);
            return callableStatement.wasNull() ? null : new Double(d);
        }

        Object readValueFromResultSet(ResultSet resultSet, String string) throws SQLException {
            double d = resultSet.getDouble(string);
            return resultSet.wasNull() ? null : new Double(d);
        }

        Object readValueFromResultSet(ResultSet resultSet, int n) throws SQLException {
            double d = resultSet.getDouble(n);
            return resultSet.wasNull() ? null : new Double(d);
        }

        public int getType() {
            return 6;
        }
    }

    public static final class T_Real
    extends BaseType {
        public Object sequenceKeyConversion(Long l) throws SequenceManagerException {
            return new Float(l.floatValue());
        }

        Object readValueFromStatement(CallableStatement callableStatement, int n) throws SQLException {
            float f = callableStatement.getFloat(n);
            return callableStatement.wasNull() ? null : new Float(f);
        }

        Object readValueFromResultSet(ResultSet resultSet, String string) throws SQLException {
            float f = resultSet.getFloat(string);
            return resultSet.wasNull() ? null : new Float(f);
        }

        Object readValueFromResultSet(ResultSet resultSet, int n) throws SQLException {
            float f = resultSet.getFloat(n);
            return resultSet.wasNull() ? null : new Float(f);
        }

        public int getType() {
            return 7;
        }
    }

    public static final class T_BigInt
    extends BaseType {
        public Object sequenceKeyConversion(Long l) throws SequenceManagerException {
            return l;
        }

        Object readValueFromStatement(CallableStatement callableStatement, int n) throws SQLException {
            long l = callableStatement.getLong(n);
            return callableStatement.wasNull() ? null : new Long(l);
        }

        Object readValueFromResultSet(ResultSet resultSet, String string) throws SQLException {
            long l = resultSet.getLong(string);
            return resultSet.wasNull() ? null : new Long(l);
        }

        Object readValueFromResultSet(ResultSet resultSet, int n) throws SQLException {
            long l = resultSet.getLong(n);
            return resultSet.wasNull() ? null : new Long(l);
        }

        public int getType() {
            return -5;
        }
    }

    public static final class T_Integer
    extends BaseType {
        public Object sequenceKeyConversion(Long l) throws SequenceManagerException {
            return new Integer(l.intValue());
        }

        Object readValueFromStatement(CallableStatement callableStatement, int n) throws SQLException {
            int n2 = callableStatement.getInt(n);
            return callableStatement.wasNull() ? null : new Integer(n2);
        }

        Object readValueFromResultSet(ResultSet resultSet, String string) throws SQLException {
            int n = resultSet.getInt(string);
            return resultSet.wasNull() ? null : new Integer(n);
        }

        Object readValueFromResultSet(ResultSet resultSet, int n) throws SQLException {
            int n2 = resultSet.getInt(n);
            return resultSet.wasNull() ? null : new Integer(n2);
        }

        public int getType() {
            return 4;
        }
    }

    public static final class T_SmallInt
    extends BaseType {
        public Object sequenceKeyConversion(Long l) throws SequenceManagerException {
            return new Short(l.shortValue());
        }

        Object readValueFromStatement(CallableStatement callableStatement, int n) throws SQLException {
            short s = callableStatement.getShort(n);
            return callableStatement.wasNull() ? null : new Short(s);
        }

        Object readValueFromResultSet(ResultSet resultSet, String string) throws SQLException {
            short s = resultSet.getShort(string);
            return resultSet.wasNull() ? null : new Short(s);
        }

        Object readValueFromResultSet(ResultSet resultSet, int n) throws SQLException {
            short s = resultSet.getShort(n);
            return resultSet.wasNull() ? null : new Short(s);
        }

        public int getType() {
            return 5;
        }
    }

    public static final class T_TinyInt
    extends BaseType {
        public Object sequenceKeyConversion(Long l) throws SequenceManagerException {
            return new Byte(l.byteValue());
        }

        Object readValueFromStatement(CallableStatement callableStatement, int n) throws SQLException {
            byte by = callableStatement.getByte(n);
            return callableStatement.wasNull() ? null : new Byte(by);
        }

        Object readValueFromResultSet(ResultSet resultSet, String string) throws SQLException {
            byte by = resultSet.getByte(string);
            return resultSet.wasNull() ? null : new Byte(by);
        }

        Object readValueFromResultSet(ResultSet resultSet, int n) throws SQLException {
            byte by = resultSet.getByte(n);
            return resultSet.wasNull() ? null : new Byte(by);
        }

        public int getType() {
            return -6;
        }
    }

    public static final class T_Boolean
    extends BaseType {
        public Object sequenceKeyConversion(Long l) throws SequenceManagerException {
            throw new SequenceManagerException("Not supported sequence key type 'BOOLEAN'");
        }

        Object readValueFromStatement(CallableStatement callableStatement, int n) throws SQLException {
            boolean bl = callableStatement.getBoolean(n);
            return callableStatement.wasNull() ? null : BooleanUtils.toBooleanObject((boolean)bl);
        }

        Object readValueFromResultSet(ResultSet resultSet, String string) throws SQLException {
            boolean bl = resultSet.getBoolean(string);
            return resultSet.wasNull() ? null : BooleanUtils.toBooleanObject((boolean)bl);
        }

        Object readValueFromResultSet(ResultSet resultSet, int n) throws SQLException {
            boolean bl = resultSet.getBoolean(n);
            return resultSet.wasNull() ? null : BooleanUtils.toBooleanObject((boolean)bl);
        }

        public int getType() {
            return 16;
        }
    }

    public static final class T_Bit
    extends BaseType {
        public Object sequenceKeyConversion(Long l) throws SequenceManagerException {
            throw new SequenceManagerException("Not supported sequence key type 'BIT'");
        }

        Object readValueFromStatement(CallableStatement callableStatement, int n) throws SQLException {
            boolean bl = callableStatement.getBoolean(n);
            return callableStatement.wasNull() ? null : BooleanUtils.toBooleanObject((boolean)bl);
        }

        Object readValueFromResultSet(ResultSet resultSet, String string) throws SQLException {
            boolean bl = resultSet.getBoolean(string);
            return resultSet.wasNull() ? null : BooleanUtils.toBooleanObject((boolean)bl);
        }

        Object readValueFromResultSet(ResultSet resultSet, int n) throws SQLException {
            boolean bl = resultSet.getBoolean(n);
            return resultSet.wasNull() ? null : BooleanUtils.toBooleanObject((boolean)bl);
        }

        public int getType() {
            return -7;
        }
    }

    public static final class T_Decimal
    extends BaseType {
        public Object sequenceKeyConversion(Long l) throws SequenceManagerException {
            return new BigDecimal((double)l.longValue());
        }

        Object readValueFromStatement(CallableStatement callableStatement, int n) throws SQLException {
            return callableStatement.getBigDecimal(n);
        }

        Object readValueFromResultSet(ResultSet resultSet, String string) throws SQLException {
            return resultSet.getBigDecimal(string);
        }

        Object readValueFromResultSet(ResultSet resultSet, int n) throws SQLException {
            return resultSet.getBigDecimal(n);
        }

        public int getType() {
            return 3;
        }
    }

    public static final class T_Numeric
    extends BaseType {
        public Object sequenceKeyConversion(Long l) throws SequenceManagerException {
            return new BigDecimal((double)l.longValue());
        }

        Object readValueFromStatement(CallableStatement callableStatement, int n) throws SQLException {
            return callableStatement.getBigDecimal(n);
        }

        Object readValueFromResultSet(ResultSet resultSet, String string) throws SQLException {
            return resultSet.getBigDecimal(string);
        }

        Object readValueFromResultSet(ResultSet resultSet, int n) throws SQLException {
            return resultSet.getBigDecimal(n);
        }

        public int getType() {
            return 2;
        }
    }

    public static final class T_LongVarChar
    extends BaseType {
        public Object sequenceKeyConversion(Long l) throws SequenceManagerException {
            return l.toString();
        }

        Object readValueFromStatement(CallableStatement callableStatement, int n) throws SQLException {
            return callableStatement.getString(n);
        }

        Object readValueFromResultSet(ResultSet resultSet, String string) throws SQLException {
            return resultSet.getString(string);
        }

        Object readValueFromResultSet(ResultSet resultSet, int n) throws SQLException {
            return resultSet.getString(n);
        }

        public int getType() {
            return -1;
        }
    }

    public static final class T_Varchar
    extends BaseType {
        public Object sequenceKeyConversion(Long l) throws SequenceManagerException {
            return l.toString();
        }

        Object readValueFromStatement(CallableStatement callableStatement, int n) throws SQLException {
            return callableStatement.getString(n);
        }

        Object readValueFromResultSet(ResultSet resultSet, String string) throws SQLException {
            return resultSet.getString(string);
        }

        Object readValueFromResultSet(ResultSet resultSet, int n) throws SQLException {
            return resultSet.getString(n);
        }

        public int getType() {
            return 12;
        }
    }

    public static final class T_Char
    extends BaseType {
        public Object sequenceKeyConversion(Long l) throws SequenceManagerException {
            return l.toString();
        }

        Object readValueFromStatement(CallableStatement callableStatement, int n) throws SQLException {
            return callableStatement.getString(n);
        }

        Object readValueFromResultSet(ResultSet resultSet, String string) throws SQLException {
            return resultSet.getString(string);
        }

        Object readValueFromResultSet(ResultSet resultSet, int n) throws SQLException {
            return resultSet.getString(n);
        }

        public int getType() {
            return 1;
        }
    }

    public static abstract class BaseType
    implements JdbcType {
        abstract Object readValueFromResultSet(ResultSet var1, String var2) throws SQLException;

        abstract Object readValueFromResultSet(ResultSet var1, int var2) throws SQLException;

        abstract Object readValueFromStatement(CallableStatement var1, int var2) throws SQLException;

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            boolean bl = false;
            if (object instanceof JdbcType) {
                bl = this.getType() == ((JdbcType)object).getType();
            }
            return bl;
        }

        public int hashCode() {
            return this.getType();
        }

        public Object getObjectFromColumn(CallableStatement callableStatement, int n) throws SQLException {
            return this.getObjectFromColumn(null, callableStatement, null, n);
        }

        public Object getObjectFromColumn(ResultSet resultSet, String string) throws SQLException {
            return this.getObjectFromColumn(resultSet, null, string, Integer.MIN_VALUE);
        }

        public Object getObjectFromColumn(ResultSet resultSet, CallableStatement callableStatement, String string, int n) throws SQLException {
            if (callableStatement != null) {
                if (n == Integer.MIN_VALUE) {
                    throw new UnsupportedOperationException("Not implemented yet");
                }
                return this.readValueFromStatement(callableStatement, n);
            }
            return n == Integer.MIN_VALUE ? this.readValueFromResultSet(resultSet, string) : this.readValueFromResultSet(resultSet, n);
        }

        public String toString() {
            return super.toString() + "[" + JdbcTypesHelper.getJdbcTypeAsString(this.getType()) + " JDBC TYPE]";
        }
    }
}

