/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.util.logging;

import java.util.HashMap;
import java.util.Map;
import org.apache.ojb.broker.util.ClassHelper;
import org.apache.ojb.broker.util.logging.Logger;
import org.apache.ojb.broker.util.logging.LoggingConfiguration;
import org.apache.ojb.broker.util.logging.PoorMansLoggerImpl;

public class LoggerFactoryImpl {
    public static final LoggerFactoryImpl INSTANCE = new LoggerFactoryImpl();
    private Logger defaultLogger = null;
    private Logger bootLogger = null;
    private Map cache = new HashMap();
    private LoggingConfiguration conf;
    static /* synthetic */ Class class$java$lang$String;

    private LoggerFactoryImpl() {
    }

    public static LoggerFactoryImpl getInstance() {
        return INSTANCE;
    }

    private LoggingConfiguration getConfiguration() {
        if (this.conf == null) {
            this.conf = new LoggingConfiguration();
        }
        return this.conf;
    }

    public Logger getBootLogger() {
        if (this.bootLogger == null) {
            this.bootLogger = new PoorMansLoggerImpl("BOOT");
            String string = System.getProperty("OJB.bootLogLevel", "WARN");
            ((PoorMansLoggerImpl)this.bootLogger).setLevel(string);
        }
        return this.bootLogger;
    }

    public Logger getDefaultLogger() {
        if (this.defaultLogger == null) {
            this.defaultLogger = this.getLogger("DEFAULT");
        }
        return this.defaultLogger;
    }

    public Logger getLogger(Class clazz) {
        return this.getLogger(clazz.getName());
    }

    public Logger getLogger(String string) {
        if (this.cache.containsKey(string)) {
            return (Logger)this.cache.get(string);
        }
        Logger logger = null;
        Class clazz = null;
        try {
            LoggingConfiguration loggingConfiguration = this.getConfiguration();
            clazz = loggingConfiguration.getLoggerClass();
            this.getBootLogger().debug("Using logger class " + clazz + " for " + string);
            logger = (Logger)ClassHelper.newInstance(clazz, class$java$lang$String == null ? (class$java$lang$String = LoggerFactoryImpl.class$("java.lang.String")) : class$java$lang$String, (Object)string);
            try {
                this.getBootLogger().debug("Initializing logger instance " + string);
                logger.configure(loggingConfiguration);
            }
            catch (Exception exception) {
                logger = this.getBootLogger();
                logger.error("[" + this.getClass().getName() + "] Could not initialize logger for class " + clazz.getName(), exception);
            }
            this.cache.put(string, logger);
        }
        catch (Throwable throwable) {
            logger = this.getBootLogger();
            logger.error("[" + this.getClass().getName() + "] Could not set logger for class " + clazz.getName(), throwable);
        }
        return logger;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

