/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.util.pooling;

import java.io.Serializable;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.dbcp.AbandonedConfig;
import org.apache.commons.pool.impl.GenericKeyedObjectPool;
import org.apache.commons.pool.impl.GenericObjectPool;

public class PoolConfiguration
extends Properties
implements Serializable {
    private static final long serialVersionUID = -3850488378321541047L;
    public static final String EMPTY = "";
    public static final String MAX_ACTIVE = "maxActive";
    public static final String MAX_IDLE = "maxIdle";
    public static final String MAX_WAIT = "maxWait";
    public static final String WHEN_EXHAUSTED_ACTION = "whenExhaustedAction";
    public static final String TEST_ON_BORROW = "testOnBorrow";
    public static final String TEST_ON_RETURN = "testOnReturn";
    public static final String TEST_WHILE_IDLE = "testWhileIdle";
    public static final String TIME_BETWEEN_EVICTION_RUNS_MILLIS = "timeBetweenEvictionRunsMillis";
    public static final String NUM_TESTS_PER_EVICTION_RUN = "numTestsPerEvictionRun";
    public static final String MIN_EVICTABLE_IDLE_TIME_MILLIS = "minEvictableIdleTimeMillis";
    public static final String LOG_ABANDONED = "logAbandoned";
    public static final String REMOVE_ABANDONED = "removeAbandoned";
    public static final String REMOVE_ABANDONED_TIMEOUT = "removeAbandonedTimeout";
    public static final String VALIDATION_QUERY = "validationQuery";
    public static final int DEFAULT_MAX_ACTIVE = 21;
    public static final int DEFAULT_MAX_IDLE = -1;
    public static final long DEFAULT_MAX_WAIT = 5000L;
    public static final byte DEFAULT_WHEN_EXHAUSTED_ACTION = 0;
    public static final boolean DEFAULT_TEST_ON_BORROW = true;
    public static final boolean DEFAULT_TEST_ON_RETURN = false;
    public static final boolean DEFAULT_TEST_WHILE_IDLE = false;
    public static final long DEFAULT_TIME_BETWEEN_EVICTION_RUNS_MILLIS = -1L;
    public static final int DEFAULT_NUM_TESTS_PER_EVICTION_RUN = 10;
    public static final long DEFAULT_MIN_EVICTABLE_IDLE_TIME_MILLIS = 600000L;
    public static final boolean DEFAULT_LOG_ABANDONED = false;
    public static final boolean DEFAULT_REMOVE_ABANDONED = false;
    public static final int DEFAULT_REMOVE_ABANDONED_TIMEOUT = 300;

    public PoolConfiguration() {
        this.setMaxActive(21);
        this.setMaxIdle(-1);
        this.setMaxWait(5000L);
        this.setWhenExhaustedAction((byte)0);
        this.setTestOnBorrow(true);
        this.setTestOnReturn(false);
        this.setTestWhileIdle(false);
        this.setMinEvictableIdleTimeMillis(600000L);
        this.setTimeBetweenEvictionRunsMillis(-1L);
        this.setNumTestsPerEvictionRun(10);
        this.setLogAbandoned(false);
        this.setRemoveAbandoned(false);
        this.setRemoveAbandonedTimeout(300);
    }

    public PoolConfiguration(Properties properties) {
        this();
        this.putAll((Map<?, ?>)properties);
    }

    public GenericObjectPool.Config getObjectPoolConfig() {
        GenericObjectPool.Config config = new GenericObjectPool.Config();
        config.maxActive = this.getMaxActive();
        config.maxIdle = this.getMaxIdle();
        config.maxWait = this.getMaxWait();
        config.minEvictableIdleTimeMillis = this.getMinEvictableIdleTimeMillis();
        config.numTestsPerEvictionRun = this.getNumTestsPerEvictionRun();
        config.testOnBorrow = this.isTestOnBorrow();
        config.testOnReturn = this.isTestOnReturn();
        config.testWhileIdle = this.isTestWhileIdle();
        config.timeBetweenEvictionRunsMillis = this.getTimeBetweenEvictionRunsMillis();
        config.whenExhaustedAction = this.getWhenExhaustedAction();
        return config;
    }

    public GenericKeyedObjectPool.Config getKeyedObjectPoolConfig() {
        GenericKeyedObjectPool.Config config = new GenericKeyedObjectPool.Config();
        config.maxActive = this.getMaxActive();
        config.maxIdle = this.getMaxIdle();
        config.maxWait = this.getMaxWait();
        config.minEvictableIdleTimeMillis = this.getMinEvictableIdleTimeMillis();
        config.numTestsPerEvictionRun = this.getNumTestsPerEvictionRun();
        config.testOnBorrow = this.isTestOnBorrow();
        config.testOnReturn = this.isTestOnReturn();
        config.testWhileIdle = this.isTestWhileIdle();
        config.timeBetweenEvictionRunsMillis = this.getTimeBetweenEvictionRunsMillis();
        config.whenExhaustedAction = this.getWhenExhaustedAction();
        return config;
    }

    public AbandonedConfig getAbandonedConfig() {
        AbandonedConfig abandonedConfig = new AbandonedConfig();
        abandonedConfig.setLogAbandoned(this.isLogAbandoned());
        abandonedConfig.setRemoveAbandoned(this.isRemoveAbandoned());
        abandonedConfig.setRemoveAbandonedTimeout(this.getRemoveAbandonedTimeout());
        return abandonedConfig;
    }

    public boolean isLogAbandoned() {
        return Boolean.valueOf(this.getProperty(LOG_ABANDONED));
    }

    public void setLogAbandoned(boolean bl) {
        this.setProperty(LOG_ABANDONED, EMPTY + bl);
    }

    public boolean isRemoveAbandoned() {
        return Boolean.valueOf(this.getProperty(REMOVE_ABANDONED));
    }

    public void setRemoveAbandoned(boolean bl) {
        this.setProperty(REMOVE_ABANDONED, EMPTY + bl);
    }

    public int getRemoveAbandonedTimeout() {
        return Integer.parseInt(this.getProperty(REMOVE_ABANDONED_TIMEOUT));
    }

    public void setRemoveAbandonedTimeout(int n) {
        this.setProperty(REMOVE_ABANDONED_TIMEOUT, EMPTY + n);
    }

    public String getValidationQuery() {
        return this.getProperty(VALIDATION_QUERY);
    }

    public void setValidationQuery(String string) {
        if (string != null) {
            this.setProperty(VALIDATION_QUERY, string);
        }
    }

    public int getMaxActive() {
        return Integer.parseInt(this.getProperty(MAX_ACTIVE));
    }

    public void setMaxActive(int n) {
        this.setProperty(MAX_ACTIVE, EMPTY + n);
    }

    public int getMaxIdle() {
        return Integer.parseInt(this.getProperty(MAX_IDLE));
    }

    public void setMaxIdle(int n) {
        this.setProperty(MAX_IDLE, EMPTY + n);
    }

    public long getMaxWait() {
        return Long.parseLong(this.getProperty(MAX_WAIT));
    }

    public void setMaxWait(long l) {
        this.setProperty(MAX_WAIT, EMPTY + l);
    }

    public byte getWhenExhaustedAction() {
        return new Byte(this.getProperty(WHEN_EXHAUSTED_ACTION));
    }

    public void setWhenExhaustedAction(byte by) {
        this.setProperty(WHEN_EXHAUSTED_ACTION, EMPTY + by);
    }

    public boolean isTestOnBorrow() {
        return Boolean.valueOf(this.getProperty(TEST_ON_BORROW));
    }

    public void setTestOnBorrow(boolean bl) {
        this.setProperty(TEST_ON_BORROW, EMPTY + bl);
    }

    public boolean isTestOnReturn() {
        return Boolean.valueOf(this.getProperty(TEST_ON_RETURN));
    }

    public void setTestOnReturn(boolean bl) {
        this.setProperty(TEST_ON_RETURN, EMPTY + bl);
    }

    public boolean isTestWhileIdle() {
        return Boolean.valueOf(this.getProperty(TEST_WHILE_IDLE));
    }

    public void setTestWhileIdle(boolean bl) {
        this.setProperty(TEST_WHILE_IDLE, EMPTY + bl);
    }

    public long getMinEvictableIdleTimeMillis() {
        return Long.parseLong(this.getProperty(MIN_EVICTABLE_IDLE_TIME_MILLIS));
    }

    public void setMinEvictableIdleTimeMillis(long l) {
        this.setProperty(MIN_EVICTABLE_IDLE_TIME_MILLIS, EMPTY + l);
    }

    public long getTimeBetweenEvictionRunsMillis() {
        return Long.parseLong(this.getProperty(TIME_BETWEEN_EVICTION_RUNS_MILLIS));
    }

    public void setTimeBetweenEvictionRunsMillis(long l) {
        this.setProperty(TIME_BETWEEN_EVICTION_RUNS_MILLIS, EMPTY + l);
    }

    public int getNumTestsPerEvictionRun() {
        return Integer.parseInt(this.getProperty(NUM_TESTS_PER_EVICTION_RUN));
    }

    public void setNumTestsPerEvictionRun(int n) {
        this.setProperty(NUM_TESTS_PER_EVICTION_RUN, EMPTY + n);
    }
}

