/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.util.sequence;

import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Iterator;
import java.util.Vector;
import org.apache.ojb.broker.PersistenceBroker;
import org.apache.ojb.broker.PersistenceBrokerException;
import org.apache.ojb.broker.accesslayer.JdbcAccess;
import org.apache.ojb.broker.accesslayer.ResultSetAndStatement;
import org.apache.ojb.broker.core.proxy.ProxyHelper;
import org.apache.ojb.broker.metadata.ClassDescriptor;
import org.apache.ojb.broker.metadata.FieldDescriptor;
import org.apache.ojb.broker.metadata.ObjectReferenceDescriptor;
import org.apache.ojb.broker.metadata.fieldaccess.PersistentField;
import org.apache.ojb.broker.util.logging.Logger;
import org.apache.ojb.broker.util.logging.LoggerFactory;
import org.apache.ojb.broker.util.sequence.SequenceManager;
import org.apache.ojb.broker.util.sequence.SequenceManagerException;

public class SequenceManagerMySQLImpl
implements SequenceManager {
    private Logger log = LoggerFactory.getLogger(class$org$apache$ojb$broker$util$sequence$SequenceManagerMySQLImpl == null ? (class$org$apache$ojb$broker$util$sequence$SequenceManagerMySQLImpl = SequenceManagerMySQLImpl.class$("org.apache.ojb.broker.util.sequence.SequenceManagerMySQLImpl")) : class$org$apache$ojb$broker$util$sequence$SequenceManagerMySQLImpl);
    protected PersistenceBroker broker;
    static /* synthetic */ Class class$org$apache$ojb$broker$util$sequence$SequenceManagerMySQLImpl;

    public SequenceManagerMySQLImpl(PersistenceBroker persistenceBroker) {
        this.broker = persistenceBroker;
    }

    private synchronized int getNextId(FieldDescriptor fieldDescriptor) {
        return 0;
    }

    public int getUniqueId(FieldDescriptor fieldDescriptor) {
        return this.getNextId(fieldDescriptor);
    }

    protected String getUniqueString(FieldDescriptor fieldDescriptor) {
        return Integer.toString(this.getUniqueId(fieldDescriptor));
    }

    protected long getUniqueLong(FieldDescriptor fieldDescriptor) {
        return this.getUniqueId(fieldDescriptor);
    }

    protected Object getUniqueObject(FieldDescriptor fieldDescriptor) {
        return null;
    }

    public void afterStore(JdbcAccess jdbcAccess, ClassDescriptor classDescriptor, Object object) throws SequenceManagerException {
        FieldDescriptor fieldDescriptor;
        FieldDescriptor[] fieldDescriptorArray = classDescriptor.getAutoIncrementFields();
        FieldDescriptor fieldDescriptor2 = fieldDescriptor = fieldDescriptorArray.length > 0 ? fieldDescriptorArray[0] : null;
        if (fieldDescriptor != null) {
            ResultSetAndStatement resultSetAndStatement = null;
            try {
                resultSetAndStatement = jdbcAccess.executeSQL("SELECT LAST_INSERT_ID() as newid FROM " + classDescriptor.getFullTableName(), classDescriptor, false);
                int n = 0;
                if (resultSetAndStatement.m_rs.next()) {
                    n = resultSetAndStatement.m_rs.getInt("newid");
                }
                resultSetAndStatement.m_rs.close();
                if (this.log.isDebugEnabled()) {
                    this.log.debug("After store - newid=" + n);
                }
                PersistentField persistentField = fieldDescriptor.getPersistentField();
                persistentField.set(object, new Integer(n));
            }
            catch (PersistenceBrokerException persistenceBrokerException) {
                throw new SequenceManagerException((Throwable)((Object)persistenceBrokerException));
            }
            catch (SQLException sQLException) {
                throw new SequenceManagerException(sQLException);
            }
            finally {
                resultSetAndStatement.close();
            }
        }
    }

    public void setReferenceFKs(Object object, ClassDescriptor classDescriptor) throws SequenceManagerException {
        Vector vector = classDescriptor.getObjectReferenceDescriptors();
        Iterator iterator = vector.iterator();
        while (iterator.hasNext()) {
            ObjectReferenceDescriptor objectReferenceDescriptor = (ObjectReferenceDescriptor)iterator.next();
            Object object2 = objectReferenceDescriptor.getPersistentField().get(object);
            if (object2 == null) continue;
            this.assertFkAssignment(object, classDescriptor, object2, objectReferenceDescriptor);
        }
    }

    private void assertFkAssignment(Object object, ClassDescriptor classDescriptor, Object object2, ObjectReferenceDescriptor objectReferenceDescriptor) {
        Class clazz = ProxyHelper.getRealClass(object2);
        ClassDescriptor classDescriptor2 = this.broker.getDescriptorRepository().getDescriptorFor(clazz);
        ClassDescriptor classDescriptor3 = classDescriptor;
        FieldDescriptor[] fieldDescriptorArray = objectReferenceDescriptor.getForeignKeyFieldDescriptors(classDescriptor3);
        if (fieldDescriptorArray != null) {
            FieldDescriptor fieldDescriptor = classDescriptor2.getAutoIncrementFields()[0];
            FieldDescriptor fieldDescriptor2 = null;
            for (int i = 0; i < fieldDescriptorArray.length; ++i) {
                fieldDescriptor2 = fieldDescriptorArray[i];
                fieldDescriptor2.getPersistentField().set(object, fieldDescriptor.getPersistentField().get(object2));
            }
        }
    }

    public Object getUniqueValue(FieldDescriptor fieldDescriptor) throws SequenceManagerException {
        Object[] objectArray = null;
        switch (fieldDescriptor.getJdbcType().getType()) {
            case 2003: {
                Object[] objectArray2;
                objectArray = objectArray2 = new Object[]{this.getUniqueString(fieldDescriptor)};
                break;
            }
            case -5: {
                objectArray = new Long(this.getUniqueLong(fieldDescriptor));
                break;
            }
            case -2: {
                objectArray = this.getUniqueString(fieldDescriptor).getBytes();
                break;
            }
            case 1: {
                objectArray = this.getUniqueString(fieldDescriptor);
                break;
            }
            case 91: {
                objectArray = new Date(this.getUniqueLong(fieldDescriptor));
                break;
            }
            case 3: {
                objectArray = new BigDecimal((double)this.getUniqueLong(fieldDescriptor));
                break;
            }
            case 8: {
                objectArray = new Double(this.getUniqueLong(fieldDescriptor));
                break;
            }
            case 6: {
                objectArray = new Double(this.getUniqueLong(fieldDescriptor));
                break;
            }
            case 4: {
                objectArray = new Integer(this.getUniqueId(fieldDescriptor));
                break;
            }
            case 2000: {
                objectArray = this.getUniqueObject(fieldDescriptor);
                break;
            }
            case -4: {
                objectArray = this.getUniqueString(fieldDescriptor).getBytes();
                break;
            }
            case -1: {
                objectArray = this.getUniqueString(fieldDescriptor);
                break;
            }
            case 2: {
                objectArray = new BigDecimal((double)this.getUniqueLong(fieldDescriptor));
                break;
            }
            case 7: {
                objectArray = new Float(this.getUniqueLong(fieldDescriptor));
                break;
            }
            case 5: {
                objectArray = new Short((short)this.getUniqueId(fieldDescriptor));
                break;
            }
            case 92: {
                objectArray = new Time(this.getUniqueLong(fieldDescriptor));
                break;
            }
            case 93: {
                objectArray = new Timestamp(this.getUniqueLong(fieldDescriptor));
                break;
            }
            case -6: {
                objectArray = new Byte((byte)this.getUniqueId(fieldDescriptor));
                break;
            }
            case -3: {
                objectArray = this.getUniqueString(fieldDescriptor).getBytes();
                break;
            }
            case 12: {
                objectArray = this.getUniqueString(fieldDescriptor);
                break;
            }
            default: {
                objectArray = this.getUniqueString(fieldDescriptor);
            }
        }
        objectArray = fieldDescriptor.getFieldConversion().sqlToJava(objectArray);
        return objectArray;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

