/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.jdo.jdoql;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.jdo.JDOUserException;
import org.apache.ojb.broker.metadata.ClassDescriptor;
import org.apache.ojb.broker.metadata.CollectionDescriptor;
import org.apache.ojb.broker.metadata.FieldDescriptor;
import org.apache.ojb.broker.metadata.MetadataManager;
import org.apache.ojb.broker.metadata.ObjectReferenceDescriptor;
import org.apache.ojb.broker.util.ClassHelper;
import org.apache.ojb.jdo.QueryImpl;
import org.apache.ojb.jdo.jdoql.Acceptor;
import org.apache.ojb.jdo.jdoql.BinaryExpression;
import org.apache.ojb.jdo.jdoql.Expression;
import org.apache.ojb.jdo.jdoql.FieldAccess;
import org.apache.ojb.jdo.jdoql.Import;
import org.apache.ojb.jdo.jdoql.LocalVariable;
import org.apache.ojb.jdo.jdoql.LocalVariableAccess;
import org.apache.ojb.jdo.jdoql.MethodInvocation;
import org.apache.ojb.jdo.jdoql.NameExpression;
import org.apache.ojb.jdo.jdoql.NullLiteral;
import org.apache.ojb.jdo.jdoql.ThisExpression;
import org.apache.ojb.jdo.jdoql.Type;
import org.apache.ojb.jdo.jdoql.UnaryExpression;
import org.apache.ojb.jdo.jdoql.VisitorBase;

public class QueryTreeResolver
extends VisitorBase {
    private static HashMap _primitiveTypes = new HashMap();
    private QueryImpl _query;
    static /* synthetic */ Class class$java$math$BigInteger;
    static /* synthetic */ Class class$java$math$BigDecimal;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$util$Date;
    static /* synthetic */ Class class$java$util$Collection;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resolveAndCheck(QueryImpl queryImpl) throws JDOUserException {
        this._query = queryImpl;
        try {
            this.checkImports(queryImpl.getImports());
            this.visit(queryImpl.getVariables());
            this.visit(queryImpl.getParameters());
            if (queryImpl.getFilterExpression() != null) {
                queryImpl.getFilterExpression().accept(this);
            }
            this.visit(queryImpl.getOrderings());
        }
        finally {
            this._query = null;
        }
    }

    private void checkImports(Collection collection) throws JDOUserException {
        HashMap hashMap = new HashMap();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Import import_ = (Import)iterator.next();
            if (import_.isOnDemand()) continue;
            String string = import_.getSpec().substring(import_.getSpec().lastIndexOf(46));
            if (hashMap.containsKey(string)) {
                throw new JDOUserException("Multiple direct imports of classes with the same unqualified name " + string);
            }
            hashMap.put(string, null);
        }
    }

    private void visit(Map map) throws JDOUserException {
        if (map != null) {
            Iterator iterator = map.values().iterator();
            while (iterator.hasNext()) {
                ((Acceptor)iterator.next()).accept(this);
            }
        }
    }

    private void visit(Collection collection) throws JDOUserException {
        if (collection != null) {
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                ((Acceptor)iterator.next()).accept(this);
            }
        }
    }

    public void visit(BinaryExpression binaryExpression) throws JDOUserException {
        super.visit(binaryExpression);
        Class clazz = binaryExpression.getLeftSide().getType();
        Class clazz2 = binaryExpression.getRightSide().getType();
        boolean bl = false;
        switch (binaryExpression.getOperator()) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                if (binaryExpression.getOperator() == 2 && clazz == (class$java$lang$String == null ? (class$java$lang$String = QueryTreeResolver.class$("java.lang.String")) : class$java$lang$String) && clazz2 == (class$java$lang$String == null ? (class$java$lang$String = QueryTreeResolver.class$("java.lang.String")) : class$java$lang$String)) {
                    binaryExpression.setType(class$java$lang$String == null ? (class$java$lang$String = QueryTreeResolver.class$("java.lang.String")) : class$java$lang$String);
                    bl = true;
                    break;
                }
                if (!QueryTreeResolver.isNumeric(clazz) || !QueryTreeResolver.isNumeric(clazz2)) break;
                binaryExpression.setType(QueryTreeResolver.getBroaderType(clazz, clazz2));
                bl = true;
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                if (QueryTreeResolver.isInteger(clazz) && QueryTreeResolver.isInteger(clazz2)) {
                    binaryExpression.setType(QueryTreeResolver.getBroaderType(clazz, clazz2));
                    bl = true;
                    break;
                }
                if (clazz != Boolean.TYPE || clazz2 != Boolean.TYPE) break;
                binaryExpression.setType(Boolean.TYPE);
                bl = true;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                if (QueryTreeResolver.isNumeric(clazz) && QueryTreeResolver.isNumeric(clazz2)) {
                    binaryExpression.setType(Boolean.TYPE);
                    bl = true;
                    break;
                }
                if (clazz == (class$java$lang$String == null ? (class$java$lang$String = QueryTreeResolver.class$("java.lang.String")) : class$java$lang$String) && clazz2 == (class$java$lang$String == null ? (class$java$lang$String = QueryTreeResolver.class$("java.lang.String")) : class$java$lang$String)) {
                    binaryExpression.setType(Boolean.TYPE);
                    bl = true;
                    break;
                }
                if (clazz != (class$java$util$Date == null ? (class$java$util$Date = QueryTreeResolver.class$("java.util.Date")) : class$java$util$Date) || clazz2 != (class$java$util$Date == null ? (class$java$util$Date = QueryTreeResolver.class$("java.util.Date")) : class$java$util$Date)) break;
                binaryExpression.setType(Boolean.TYPE);
                bl = true;
                break;
            }
            case 8: 
            case 9: {
                if (QueryTreeResolver.isNumeric(clazz) && QueryTreeResolver.isNumeric(clazz2)) {
                    binaryExpression.setType(Boolean.TYPE);
                    bl = true;
                    break;
                }
                if (clazz == Boolean.TYPE && clazz2 == Boolean.TYPE) {
                    binaryExpression.setType(Boolean.TYPE);
                    bl = true;
                    break;
                }
                if (clazz.isPrimitive() || clazz2.isPrimitive()) break;
                binaryExpression.setType(Boolean.TYPE);
                bl = true;
                break;
            }
            case 13: 
            case 14: {
                if (clazz != Boolean.TYPE || clazz2 != Boolean.TYPE) break;
                binaryExpression.setType(Boolean.TYPE);
                bl = true;
            }
        }
        if (!bl) {
            throw new JDOUserException("Binary expression cannot be applied to expressions of types " + clazz.getName() + " and " + clazz2.getName());
        }
    }

    public void visit(MethodInvocation methodInvocation) throws JDOUserException {
        super.visit(methodInvocation);
        Class clazz = methodInvocation.getBaseExpression().getType();
        String string = methodInvocation.getName();
        if ((class$java$util$Collection == null ? (class$java$util$Collection = QueryTreeResolver.class$("java.util.Collection")) : class$java$util$Collection).isAssignableFrom(clazz)) {
            if ("contains".equals(string)) {
                if (methodInvocation.getArguments().size() != 1) {
                    throw new JDOUserException("Illegal number of arguments to method Collection.contains");
                }
            } else if ("isEmpty".equals(string)) {
                if (!methodInvocation.getArguments().isEmpty()) {
                    throw new JDOUserException("Illegal number of arguments to method Collection.isEmpty");
                }
            } else {
                throw new JDOUserException("Only methods 'contains' and 'isEmpty' are allowed to be called at collection objects");
            }
            methodInvocation.setType(Boolean.TYPE);
        } else if (clazz == (class$java$lang$String == null ? (class$java$lang$String = QueryTreeResolver.class$("java.lang.String")) : class$java$lang$String)) {
            if (!"startsWith".equals(string) && !"endsWith".equals(string)) {
                throw new JDOUserException("Only methods 'contains' and 'isEmpty' are allowed to be called at collection objects");
            }
            if (methodInvocation.getArguments().size() != 1) {
                throw new JDOUserException("Illegal number of arguments to method String." + string);
            }
            if (((Expression)methodInvocation.getArguments().get(0)).getType() != (class$java$lang$String == null ? (class$java$lang$String = QueryTreeResolver.class$("java.lang.String")) : class$java$lang$String)) {
                throw new JDOUserException("Illegal argument to method Collection." + string);
            }
            methodInvocation.setType(Boolean.TYPE);
        } else {
            throw new JDOUserException("Invocation of method " + methodInvocation.getName() + " at type " + clazz.getName() + " is not allowed");
        }
    }

    public void visit(NameExpression nameExpression) throws JDOUserException {
        NameExpression nameExpression2;
        Object object;
        super.visit(nameExpression);
        NameExpression nameExpression3 = null;
        Class clazz = null;
        if (!nameExpression.hasBaseExpression()) {
            object = this._query.getVariable(nameExpression.getName());
            if (object == null) {
                object = this._query.getParameter(nameExpression.getName());
            }
            if (object != null) {
                nameExpression2 = new LocalVariableAccess(nameExpression.getName());
                ((LocalVariableAccess)nameExpression2).setAccessedVariable((LocalVariable)object);
                nameExpression3 = nameExpression2;
            } else {
                clazz = this._query.getSearchedClass();
            }
        } else {
            clazz = nameExpression.getBaseExpression().getType();
        }
        if (nameExpression3 == null) {
            object = this.findClassDescriptorFor(clazz);
            if (object == null) {
                throw new JDOUserException("Access to type " + clazz.getName() + " is not allowed because the type is not persistent");
            }
            nameExpression2 = new FieldAccess(nameExpression.getBaseExpression(), nameExpression.getName());
            ObjectReferenceDescriptor objectReferenceDescriptor = ((ClassDescriptor)object).getObjectReferenceDescriptorByName(nameExpression.getName());
            if (objectReferenceDescriptor != null) {
                ((FieldAccess)nameExpression2).setFieldDescriptor(objectReferenceDescriptor);
            } else {
                if (nameExpression.hasParent() && nameExpression.getParent() instanceof NameExpression) {
                    throw new JDOUserException("Cannot find reference " + nameExpression.getName() + " in type " + clazz.getName() + " because it is not defined, not persistent or not a reference");
                }
                CollectionDescriptor collectionDescriptor = ((ClassDescriptor)object).getCollectionDescriptorByName(nameExpression.getName());
                if (collectionDescriptor != null) {
                    ((FieldAccess)nameExpression2).setFieldDescriptor(collectionDescriptor);
                } else {
                    FieldDescriptor fieldDescriptor = ((ClassDescriptor)object).getFieldDescriptorByName(nameExpression.getName());
                    if (fieldDescriptor == null) {
                        throw new JDOUserException("Cannot find feature " + nameExpression.getName() + " in type " + clazz.getName() + " because it is not defined or not persistent");
                    }
                    ((FieldAccess)nameExpression2).setFieldDescriptor(fieldDescriptor);
                }
            }
            nameExpression3 = nameExpression2;
        }
        if (nameExpression.hasParent()) {
            nameExpression.getParent().replaceChild(nameExpression, nameExpression3);
        }
    }

    public void visit(NullLiteral nullLiteral) {
        Expression expression = nullLiteral.getParent();
        if (expression == null) {
            return;
        }
        if (expression instanceof BinaryExpression) {
            Class clazz = null;
            clazz = ((BinaryExpression)expression).getLeftSide() == nullLiteral ? ((BinaryExpression)expression).getRightSide().getType() : ((BinaryExpression)expression).getLeftSide().getType();
            if (clazz.isPrimitive()) {
                throw new JDOUserException("Illegal binary expression with a 'null' and a primitive operand");
            }
            nullLiteral.setType(clazz);
        }
    }

    public void visit(ThisExpression thisExpression) {
        super.visit(thisExpression);
        thisExpression.setType(this._query.getSearchedClass());
    }

    public void visit(Type type) throws JDOUserException {
        ClassLoader classLoader = ClassHelper.getClassLoader();
        Class clazz = null;
        String string = type.getName();
        int n = string.indexOf(46);
        if (n >= 0) {
            try {
                clazz = Class.forName(string, true, classLoader);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        if (clazz == null) {
            clazz = this.resolveUnqualifiedClassName(classLoader, string);
        }
        if (clazz == null) {
            throw new JDOUserException("No such class " + string);
        }
        type.setType(clazz);
    }

    private Class resolveUnqualifiedClassName(ClassLoader classLoader, String string) throws JDOUserException {
        Class<?> clazz = null;
        try {
            clazz = Class.forName("java.lang." + string, true, classLoader);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        Iterator iterator = this._query.getImports().iterator();
        while (iterator.hasNext()) {
            Import import_ = (Import)iterator.next();
            if (import_.isOnDemand()) {
                try {
                    clazz = Class.forName(import_.getSpec() + "." + string, true, classLoader);
                }
                catch (ClassNotFoundException classNotFoundException) {}
                continue;
            }
            int n = import_.getSpec().lastIndexOf(46);
            if (!string.equals(import_.getSpec().substring(n + 1))) continue;
            try {
                return Class.forName(import_.getSpec() + "." + string, true, classLoader);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new JDOUserException("The import " + import_.getSpec() + " is invalid");
            }
        }
        return clazz;
    }

    public void visit(UnaryExpression unaryExpression) throws JDOUserException {
        super.visit(unaryExpression);
        Class clazz = unaryExpression.getInnerExpression().getType();
        boolean bl = false;
        switch (unaryExpression.getOperator()) {
            case 0: 
            case 1: {
                if (!QueryTreeResolver.isNumeric(clazz)) break;
                unaryExpression.setType(clazz);
                bl = true;
                break;
            }
            case 2: {
                if (!QueryTreeResolver.isInteger(clazz)) break;
                unaryExpression.setType(clazz);
                bl = true;
                break;
            }
            case 3: {
                if (clazz != Boolean.TYPE) break;
                unaryExpression.setType(clazz);
                bl = true;
                break;
            }
            case 4: {
                Class clazz2 = unaryExpression.getCastType().getType();
                if (QueryTreeResolver.isNumeric(clazz2) && QueryTreeResolver.isNumeric(clazz)) {
                    unaryExpression.setType(clazz2);
                    bl = true;
                    break;
                }
                if (!clazz2.isAssignableFrom(clazz) && !clazz.isAssignableFrom(clazz2)) break;
                unaryExpression.setType(clazz2);
                bl = true;
            }
        }
        if (!bl) {
            if (unaryExpression.getOperator() == 4) {
                throw new JDOUserException("Invalid cast expression because inner expression of type " + clazz.getName() + " cannot be cast to " + unaryExpression.getCastType().getName());
            }
            throw new JDOUserException("Invalid unary expression");
        }
    }

    private ClassDescriptor findClassDescriptorFor(Class clazz) {
        return MetadataManager.getInstance().getRepository().getDescriptorFor(clazz);
    }

    private static boolean isInteger(Class clazz) {
        if (clazz.isPrimitive()) {
            return clazz != Boolean.TYPE && clazz != Float.TYPE && clazz != Double.TYPE;
        }
        return clazz == (class$java$math$BigInteger == null ? (class$java$math$BigInteger = QueryTreeResolver.class$("java.math.BigInteger")) : class$java$math$BigInteger);
    }

    private static boolean isFloatingPoint(Class clazz) {
        if (clazz.isPrimitive()) {
            return clazz == Float.TYPE || clazz == Double.TYPE;
        }
        return clazz == (class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = QueryTreeResolver.class$("java.math.BigDecimal")) : class$java$math$BigDecimal);
    }

    private static boolean isNumeric(Class clazz) {
        if (clazz.isPrimitive()) {
            return clazz != Boolean.TYPE;
        }
        return clazz == (class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = QueryTreeResolver.class$("java.math.BigDecimal")) : class$java$math$BigDecimal) || clazz == (class$java$math$BigInteger == null ? (class$java$math$BigInteger = QueryTreeResolver.class$("java.math.BigInteger")) : class$java$math$BigInteger);
    }

    private static Class getBroaderType(Class clazz, Class clazz2) {
        Integer n = (Integer)_primitiveTypes.get(clazz);
        Integer n2 = (Integer)_primitiveTypes.get(clazz2);
        return n < n2 ? clazz2 : clazz;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        _primitiveTypes.put(Byte.TYPE, new Integer(0));
        _primitiveTypes.put(Character.TYPE, new Integer(1));
        _primitiveTypes.put(Short.TYPE, new Integer(2));
        _primitiveTypes.put(Integer.TYPE, new Integer(3));
        _primitiveTypes.put(Long.TYPE, new Integer(4));
        _primitiveTypes.put(class$java$math$BigInteger == null ? (class$java$math$BigInteger = QueryTreeResolver.class$("java.math.BigInteger")) : class$java$math$BigInteger, new Integer(5));
        _primitiveTypes.put(Float.TYPE, new Integer(6));
        _primitiveTypes.put(Double.TYPE, new Integer(7));
        _primitiveTypes.put(class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = QueryTreeResolver.class$("java.math.BigDecimal")) : class$java$math$BigDecimal, new Integer(8));
    }
}

