/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.odmg;

import org.apache.ojb.broker.Identity;
import org.apache.ojb.broker.OJBRuntimeException;
import org.apache.ojb.broker.PersistenceBroker;
import org.apache.ojb.broker.PersistenceBrokerException;
import org.apache.ojb.broker.query.QueryByIdentity;
import org.apache.ojb.broker.util.logging.Logger;
import org.apache.ojb.broker.util.logging.LoggerFactory;
import org.apache.ojb.odmg.NamedRootsEntry;
import org.apache.ojb.odmg.OJBTxManager;
import org.apache.ojb.odmg.TransactionImpl;
import org.apache.ojb.odmg.TxManagerFactory;
import org.odmg.ObjectNameNotFoundException;
import org.odmg.ObjectNameNotUniqueException;

public class NamedRootsMap {
    private Logger log = LoggerFactory.getLogger(class$org$apache$ojb$odmg$NamedRootsMap == null ? (class$org$apache$ojb$odmg$NamedRootsMap = NamedRootsMap.class$("org.apache.ojb.odmg.NamedRootsMap")) : class$org$apache$ojb$odmg$NamedRootsMap);
    private static NamedRootsMap _instance;
    private OJBTxManager txManager = TxManagerFactory.instance();
    static /* synthetic */ Class class$org$apache$ojb$odmg$NamedRootsMap;

    private NamedRootsMap() {
    }

    public Identity get(String string) {
        NamedRootsEntry namedRootsEntry = new NamedRootsEntry(string, null);
        try {
            PersistenceBroker persistenceBroker = this.txManager.getCurrentTransaction().getBroker();
            Identity identity = new Identity(namedRootsEntry, persistenceBroker);
            NamedRootsEntry namedRootsEntry2 = (NamedRootsEntry)persistenceBroker.getObjectByIdentity(identity);
            return namedRootsEntry2 == null ? null : Identity.fromByteArray(namedRootsEntry2.getOid());
        }
        catch (Exception exception) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Could not get identity for key " + string, exception);
            }
            return null;
        }
    }

    public static synchronized NamedRootsMap getInstance() {
        if (_instance == null) {
            _instance = new NamedRootsMap();
        }
        return _instance;
    }

    public void put(String string, Identity identity) throws ObjectNameNotUniqueException {
        NamedRootsEntry namedRootsEntry = new NamedRootsEntry(string, identity.serialize());
        try {
            TransactionImpl transactionImpl = this.txManager.getCurrentTransaction();
            PersistenceBroker persistenceBroker = transactionImpl.getBroker();
            NamedRootsEntry namedRootsEntry2 = (NamedRootsEntry)persistenceBroker.getObjectByQuery(new QueryByIdentity(namedRootsEntry));
            if (namedRootsEntry2 != null) {
                throw new ObjectNameNotUniqueException("object key already found, the key " + string + " is not unique");
            }
            transactionImpl.lock(namedRootsEntry, 4);
        }
        catch (PersistenceBrokerException persistenceBrokerException) {
            this.log.error("Could not put identity to NamedRoots. Key was " + string + ", identity was " + identity, (Throwable)((Object)persistenceBrokerException));
            throw new OJBRuntimeException((Throwable)((Object)persistenceBrokerException));
        }
    }

    public void unbind(String string) throws ObjectNameNotFoundException {
        NamedRootsEntry namedRootsEntry = new NamedRootsEntry(string, null);
        try {
            TransactionImpl transactionImpl = this.txManager.getCurrentTransaction();
            PersistenceBroker persistenceBroker = transactionImpl.getBroker();
            NamedRootsEntry namedRootsEntry2 = (NamedRootsEntry)persistenceBroker.getObjectByQuery(new QueryByIdentity(namedRootsEntry));
            if (namedRootsEntry2 == null) {
                throw new ObjectNameNotFoundException("Could not find a bound object for key " + string);
            }
            transactionImpl.markDelete(namedRootsEntry2);
        }
        catch (PersistenceBrokerException persistenceBrokerException) {
            this.log.error("Could not unbind identity with key " + string + " from NamedRoots", (Throwable)((Object)persistenceBrokerException));
            throw new OJBRuntimeException((Throwable)((Object)persistenceBrokerException));
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

