/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.odmg;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.ojb.broker.Identity;
import org.apache.ojb.broker.PersistenceBrokerException;
import org.apache.ojb.broker.core.proxy.ProxyHelper;
import org.apache.ojb.broker.metadata.AttributeDescriptorBase;
import org.apache.ojb.broker.metadata.ClassDescriptor;
import org.apache.ojb.broker.metadata.CollectionDescriptor;
import org.apache.ojb.broker.metadata.FieldDescriptor;
import org.apache.ojb.broker.metadata.ObjectReferenceDescriptor;
import org.apache.ojb.broker.util.ObjectModification;
import org.apache.ojb.broker.util.logging.LoggerFactory;
import org.apache.ojb.odmg.TransactionAware;
import org.apache.ojb.odmg.TransactionImpl;
import org.apache.ojb.odmg.states.ModificationState;
import org.apache.ojb.odmg.states.StateNewDirty;
import org.apache.ojb.odmg.states.StateOldClean;
import org.apache.ojb.odmg.states.StateOldDirty;
import org.odmg.ClassNotPersistenceCapableException;
import org.odmg.ODMGRuntimeException;

public class ObjectEnvelope
implements ObjectModification,
Serializable {
    static final long serialVersionUID = -829177767933340522L;
    private ModificationState modificationState = null;
    private Identity oid;
    private Boolean hasChanged;
    private transient Object myObj;
    private transient Map beforeImage;
    private transient TransactionImpl tx;

    public ObjectEnvelope(Object object, TransactionImpl transactionImpl) {
        this.tx = transactionImpl;
        this.myObj = ProxyHelper.getRealObject(object);
        this.refreshObjectImage();
        this.prepareInitialState();
    }

    public void close() {
        this.myObj = null;
        this.beforeImage = null;
        this.tx = null;
    }

    public void refreshObjectImage() {
        try {
            this.hasChanged = null;
            this.oid = new Identity(this.myObj, this.tx.getBroker());
            this.beforeImage = this.getMap();
        }
        catch (Exception exception) {
            this.beforeImage = null;
            this.oid = null;
            throw new ClassNotPersistenceCapableException(exception.toString());
        }
    }

    public Identity getIdentity() {
        return this.oid;
    }

    public Object getObject() {
        return this.myObj;
    }

    public void beforeCommit() {
        if (this.myObj instanceof TransactionAware) {
            TransactionAware transactionAware = (TransactionAware)this.myObj;
            transactionAware.beforeCommit();
        }
    }

    public void afterCommit() {
        if (this.myObj instanceof TransactionAware) {
            TransactionAware transactionAware = (TransactionAware)this.myObj;
            transactionAware.afterCommit();
        }
    }

    public void beforeAbort() {
        if (this.myObj instanceof TransactionAware) {
            TransactionAware transactionAware = (TransactionAware)this.myObj;
            transactionAware.beforeAbort();
        }
    }

    public void afterAbort() {
        if (this.myObj instanceof TransactionAware) {
            TransactionAware transactionAware = (TransactionAware)this.myObj;
            transactionAware.afterAbort();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map getMap() throws PersistenceBrokerException {
        Object object;
        Object object2;
        AttributeDescriptorBase attributeDescriptorBase;
        HashMap<Object, Object> hashMap = new HashMap<Object, Object>();
        ClassDescriptor classDescriptor = this.tx.getBroker().getClassDescriptor(this.getObject().getClass());
        FieldDescriptor[] fieldDescriptorArray = classDescriptor.getFieldDescriptions();
        for (int i = 0; i < fieldDescriptorArray.length; ++i) {
            attributeDescriptorBase = fieldDescriptorArray[i];
            object2 = attributeDescriptorBase.getPersistentField();
            hashMap.put(((FieldDescriptor)attributeDescriptorBase).getColumnName(), object2.get(this.myObj));
        }
        Iterator iterator = classDescriptor.getObjectReferenceDescriptors().iterator();
        attributeDescriptorBase = null;
        object2 = null;
        while (iterator.hasNext()) {
            attributeDescriptorBase = (ObjectReferenceDescriptor)iterator.next();
            object = this.myObj;
            synchronized (object) {
                object2 = attributeDescriptorBase.getPersistentField().get(this.myObj);
            }
            object = ProxyHelper.getIndirectionHandler(object2);
            if (object != null) {
                hashMap.put(attributeDescriptorBase, object.getIdentity());
                continue;
            }
            hashMap.put(attributeDescriptorBase, object2);
        }
        object = classDescriptor.getCollectionDescriptors().iterator();
        CollectionDescriptor collectionDescriptor = null;
        while (object.hasNext()) {
            collectionDescriptor = (CollectionDescriptor)object.next();
            Object object3 = collectionDescriptor.getPersistentField().get(this.myObj);
            if (object3 == null) continue;
            int n = 0;
            n = object3 instanceof Collection ? ((Collection)object3).size() : (object3.getClass().isArray() ? Array.getLength(object3) : object3.hashCode());
            hashMap.put(collectionDescriptor, new Integer(n));
        }
        return hashMap;
    }

    public ModificationState getModificationState() {
        return this.modificationState;
    }

    public boolean needsInsert() {
        return this.getModificationState().needsInsert();
    }

    public boolean needsUpdate() {
        return this.getModificationState().needsUpdate();
    }

    public boolean needsDelete() {
        return this.getModificationState().needsDelete();
    }

    private void prepareInitialState() {
        boolean bl;
        ModificationState modificationState = null;
        try {
            bl = this.tx.getBroker().serviceObjectCache().lookup(this.oid) == null && !this.tx.getBroker().serviceBrokerHelper().doesExist(this.tx.getBroker().getClassDescriptor(this.myObj.getClass()), this.oid, this.myObj);
        }
        catch (PersistenceBrokerException persistenceBrokerException) {
            LoggerFactory.getDefaultLogger().error("ObjectEnvelope: ", (Throwable)((Object)persistenceBrokerException));
            throw new ODMGRuntimeException("Unexpected error while check existence of " + this.myObj + ", exception was " + (Object)((Object)persistenceBrokerException));
        }
        modificationState = bl ? StateNewDirty.getInstance() : (this.tx.isDeleted(this.oid) ? StateOldDirty.getInstance() : StateOldClean.getInstance());
        this.modificationState = modificationState;
    }

    public void setModificationState(ModificationState modificationState) {
        if (modificationState != this.modificationState) {
            if (LoggerFactory.getDefaultLogger().isDebugEnabled()) {
                LoggerFactory.getDefaultLogger().debug("transition: " + new Identity(this.myObj, this.tx.getBroker()) + " (" + this.modificationState + " --> " + modificationState + ")");
            }
            this.modificationState = modificationState;
        }
    }

    public String toString() {
        String string = null;
        string = this.myObj == null ? "null" : new Identity(this.myObj, this.tx.getBroker()).toString();
        return string + "(" + this.modificationState + ")";
    }

    public boolean hasChanged() {
        Map map = null;
        try {
            map = this.getMap();
        }
        catch (Exception exception) {
            LoggerFactory.getDefaultLogger().warn("Could not verify object changes, return hasChanged 'true'", exception);
        }
        this.hasChanged = this.beforeImage != null && ((Object)this.beforeImage).equals(map) ? Boolean.FALSE : Boolean.TRUE;
        return this.hasChanged;
    }
}

