/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.odmg;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.apache.ojb.broker.Identity;
import org.apache.ojb.broker.OptimisticLockException;
import org.apache.ojb.broker.PersistenceBroker;
import org.apache.ojb.broker.PersistenceBrokerFactory;
import org.apache.ojb.broker.accesslayer.ConnectionManagerIF;
import org.apache.ojb.broker.core.proxy.ProxyHelper;
import org.apache.ojb.broker.metadata.ClassDescriptor;
import org.apache.ojb.broker.metadata.CollectionDescriptor;
import org.apache.ojb.broker.metadata.ObjectReferenceDescriptor;
import org.apache.ojb.broker.util.BrokerHelper;
import org.apache.ojb.broker.util.logging.Logger;
import org.apache.ojb.broker.util.logging.LoggerFactory;
import org.apache.ojb.odmg.ObjectEnvelope;
import org.apache.ojb.odmg.OdmgConfiguration;
import org.apache.ojb.odmg.TransactionAbortedExceptionOJB;
import org.apache.ojb.odmg.TransactionImpl;
import org.apache.ojb.odmg.locking.LockManagerFactory;
import org.apache.ojb.odmg.states.StateOldClean;
import org.odmg.LockNotGrantedException;
import org.odmg.TransactionAbortedException;

public class ObjectEnvelopeTable {
    private Logger log = LoggerFactory.getLogger(class$org$apache$ojb$odmg$ObjectEnvelopeTable == null ? (class$org$apache$ojb$odmg$ObjectEnvelopeTable = ObjectEnvelopeTable.class$("org.apache.ojb.odmg.ObjectEnvelopeTable")) : class$org$apache$ojb$odmg$ObjectEnvelopeTable);
    private TransactionImpl transaction;
    private Map mhtObjectEnvelopes = new HashMap();
    private ArrayList mvOrderOfIds = new ArrayList();
    private boolean needsCommit = false;
    static /* synthetic */ Class class$org$apache$ojb$odmg$ObjectEnvelopeTable;

    public void refresh() {
        if (this.mhtObjectEnvelopes != null) {
            Iterator iterator = this.mvOrderOfIds.iterator();
            while (iterator.hasNext()) {
                ObjectEnvelope objectEnvelope = (ObjectEnvelope)this.mhtObjectEnvelopes.get(iterator.next());
                objectEnvelope.close();
            }
        }
        this.needsCommit = false;
        this.mhtObjectEnvelopes.clear();
        this.mvOrderOfIds.clear();
    }

    public ObjectEnvelopeTable(TransactionImpl transactionImpl) {
        this.transaction = transactionImpl;
    }

    public void commit() throws TransactionAbortedException, LockNotGrantedException {
        PersistenceBroker persistenceBroker = this.transaction.getBroker();
        ConnectionManagerIF connectionManagerIF = persistenceBroker.serviceConnectionManager();
        boolean bl = connectionManagerIF.isBatchMode();
        try {
            if (this.log.isDebugEnabled()) {
                this.log.debug("PB is in internal tx: " + persistenceBroker.isInTransaction() + "  broker was: " + persistenceBroker);
            }
            if (!persistenceBroker.isInTransaction()) {
                this.log.error("PB associated with current odmg-tx is not in tx");
                throw new TransactionAbortedException("Underlying PB is not in tx");
            }
            connectionManagerIF.setBatchMode(true);
            this.upgradeImplicitLocksAndCheckIfCommitIsNeeded();
            this.reorder();
            this.commitAllEnvelopes(persistenceBroker);
            connectionManagerIF.executeBatch();
            this.setCleanState();
        }
        catch (Throwable throwable) {
            connectionManagerIF.clearBatch();
            this.log.error("Commit on object level failed for tx " + this.transaction, throwable);
            if (throwable instanceof OptimisticLockException) {
                Object object = ((OptimisticLockException)((Object)throwable)).getSourceObject();
                throw new LockNotGrantedException("(" + object + ")" + throwable.getMessage());
            }
            throw new TransactionAbortedExceptionOJB(throwable);
        }
        finally {
            this.needsCommit = false;
            connectionManagerIF.setBatchMode(bl);
        }
    }

    private void commitAllEnvelopes(PersistenceBroker persistenceBroker) {
        if (this.needsCommit) {
            Iterator iterator = ((List)this.mvOrderOfIds.clone()).iterator();
            while (iterator.hasNext()) {
                ObjectEnvelope objectEnvelope = (ObjectEnvelope)this.mhtObjectEnvelopes.get(iterator.next());
                objectEnvelope.getModificationState().commit(objectEnvelope, persistenceBroker);
            }
        }
    }

    private void setCleanState() {
        if (this.needsCommit) {
            Iterator iterator = ((List)this.mvOrderOfIds.clone()).iterator();
            while (iterator.hasNext()) {
                ObjectEnvelope objectEnvelope = (ObjectEnvelope)this.mhtObjectEnvelopes.get(iterator.next());
                if (objectEnvelope.getModificationState() == StateOldClean.getInstance()) continue;
                objectEnvelope.refreshObjectImage();
                objectEnvelope.setModificationState(StateOldClean.getInstance());
            }
        }
    }

    private void upgradeImplicitLocksAndCheckIfCommitIsNeeded() {
        boolean bl = this.getConfiguration().useImplicitLocking();
        Iterator iterator = ((List)this.mvOrderOfIds.clone()).iterator();
        while (iterator.hasNext()) {
            boolean bl2 = false;
            ObjectEnvelope objectEnvelope = (ObjectEnvelope)this.mhtObjectEnvelopes.get(iterator.next());
            if (!(objectEnvelope.needsDelete() || objectEnvelope.needsInsert() || objectEnvelope.needsUpdate())) {
                if (!objectEnvelope.hasChanged()) continue;
                if (bl) {
                    this.transaction.lock(objectEnvelope.getObject(), 2);
                    bl2 = true;
                } else if (LockManagerFactory.getLockManager().checkWrite(this.transaction, objectEnvelope.getObject())) {
                    bl2 = true;
                }
                if (!bl2) continue;
                this.needsCommit = true;
                objectEnvelope.setModificationState(objectEnvelope.getModificationState().markDirty());
                continue;
            }
            this.needsCommit = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollback() {
        try {
            PersistenceBroker persistenceBroker = this.transaction.getBroker();
            Iterator iterator = this.mvOrderOfIds.iterator();
            while (iterator.hasNext()) {
                ObjectEnvelope objectEnvelope = (ObjectEnvelope)this.mhtObjectEnvelopes.get(iterator.next());
                if (this.log.isDebugEnabled()) {
                    this.log.debug("rollback: " + objectEnvelope);
                }
                if (objectEnvelope.hasChanged()) {
                    objectEnvelope.setModificationState(objectEnvelope.getModificationState().markDirty());
                }
                objectEnvelope.getModificationState().rollback(objectEnvelope, persistenceBroker);
            }
        }
        finally {
            this.needsCommit = false;
        }
    }

    public void remove(Object object) {
        Identity identity = null;
        identity = object instanceof Identity ? (Identity)object : new Identity(object, this.transaction.getBroker());
        this.mhtObjectEnvelopes.remove(identity);
        this.mvOrderOfIds.remove(identity);
    }

    public Enumeration elements() {
        return Collections.enumeration(this.mhtObjectEnvelopes.values());
    }

    public ObjectEnvelope getByIdentity(Identity identity) {
        return (ObjectEnvelope)this.mhtObjectEnvelopes.get(identity);
    }

    public ObjectEnvelope get(Object object) {
        Identity identity = new Identity(object, this.transaction.getBroker());
        ObjectEnvelope objectEnvelope = (ObjectEnvelope)this.mhtObjectEnvelopes.get(identity);
        if (objectEnvelope == null) {
            objectEnvelope = new ObjectEnvelope(object, this.transaction);
            this.mhtObjectEnvelopes.put(identity, objectEnvelope);
            this.mvOrderOfIds.add(identity);
            if (this.log.isDebugEnabled()) {
                this.log.debug("register: " + objectEnvelope);
            }
        }
        return objectEnvelope;
    }

    public void put(Object object, ObjectEnvelope objectEnvelope) {
        Identity identity = new Identity(object, this.transaction.getBroker());
        if (this.log.isDebugEnabled()) {
            this.log.debug("register: " + objectEnvelope);
        }
        if (!this.mhtObjectEnvelopes.containsKey(identity)) {
            this.mvOrderOfIds.add(identity);
        }
        this.mhtObjectEnvelopes.put(identity, objectEnvelope);
    }

    public String toString() {
        ToStringBuilder toStringBuilder = new ToStringBuilder((Object)this, ToStringStyle.MULTI_LINE_STYLE);
        toStringBuilder.append((Object)"### ObjectEnvelopeTable dump:");
        Enumeration enumeration = this.elements();
        while (enumeration.hasMoreElements()) {
            ObjectEnvelope objectEnvelope = (ObjectEnvelope)enumeration.nextElement();
            toStringBuilder.append((Object)objectEnvelope.toString());
        }
        return toStringBuilder.toString();
    }

    public boolean contains(Object object) {
        Identity identity = new Identity(object, this.transaction.getBroker());
        return this.mhtObjectEnvelopes.containsKey(identity);
    }

    private void reorder() throws IllegalAccessException {
        if (this.needsCommit) {
            int n;
            ArrayList arrayList = new ArrayList(this.mvOrderOfIds.size());
            HashMap hashMap = new HashMap((int)((double)this.mvOrderOfIds.size() * 1.1), 1.0f);
            HashMap hashMap2 = new HashMap((int)((double)this.mvOrderOfIds.size() * 1.1), 1.0f);
            for (n = 0; n < this.mvOrderOfIds.size(); ++n) {
                hashMap2.put(this.mvOrderOfIds.get(n), new Integer(n));
            }
            for (n = 0; n < this.mvOrderOfIds.size(); ++n) {
                Identity identity = (Identity)this.mvOrderOfIds.get(n);
                if (identity == null) continue;
                this.mvOrderOfIds.set(n, null);
                ObjectEnvelope objectEnvelope = (ObjectEnvelope)this.mhtObjectEnvelopes.get(identity);
                this.mhtObjectEnvelopes.remove(identity);
                this.reorderObject(hashMap, arrayList, objectEnvelope, identity, hashMap2);
            }
            this.mvOrderOfIds = arrayList;
            this.mhtObjectEnvelopes = hashMap;
        }
    }

    private void reorderObject(Map map, List list, ObjectEnvelope objectEnvelope, Identity identity, Map map2) throws IllegalAccessException {
        PersistenceBroker persistenceBroker = this.transaction.getBroker();
        if (objectEnvelope != null) {
            ClassDescriptor classDescriptor = persistenceBroker.getClassDescriptor(objectEnvelope.getObject().getClass());
            if (objectEnvelope.needsDelete()) {
                this.reorderCollection(map, list, objectEnvelope, classDescriptor, map2);
                list.add(identity);
                map.put(identity, objectEnvelope);
                this.reorderReference(map, list, objectEnvelope, classDescriptor, map2);
            } else {
                this.reorderReference(map, list, objectEnvelope, classDescriptor, map2);
                list.add(identity);
                map.put(identity, objectEnvelope);
                this.reorderCollection(map, list, objectEnvelope, classDescriptor, map2);
            }
        }
    }

    private void reorderCollection(Map map, List list, ObjectEnvelope objectEnvelope, ClassDescriptor classDescriptor, Map map2) throws IllegalAccessException {
        Iterator iterator = classDescriptor.getCollectionDescriptors().iterator();
        while (iterator.hasNext()) {
            CollectionDescriptor collectionDescriptor = (CollectionDescriptor)iterator.next();
            Object object = collectionDescriptor.getPersistentField().get(objectEnvelope.getObject());
            if (object == null) continue;
            Iterator iterator2 = ProxyHelper.isCollectionProxy(object) && !ProxyHelper.getCollectionProxy(object).isLoaded() ? Collections.EMPTY_LIST.iterator() : BrokerHelper.getCollectionIterator(object);
            while (iterator2.hasNext()) {
                Identity identity = new Identity(iterator2.next(), this.transaction.getBroker());
                ObjectEnvelope objectEnvelope2 = (ObjectEnvelope)this.mhtObjectEnvelopes.get(identity);
                if (objectEnvelope2 == null) continue;
                this.mvOrderOfIds.set((Integer)map2.get(identity), null);
                this.mhtObjectEnvelopes.remove(identity);
                this.reorderObject(map, list, objectEnvelope2, identity, map2);
            }
        }
    }

    private void reorderReference(Map map, List list, ObjectEnvelope objectEnvelope, ClassDescriptor classDescriptor, Map map2) throws IllegalAccessException {
        Iterator iterator = classDescriptor.getObjectReferenceDescriptors().iterator();
        while (iterator.hasNext()) {
            Identity identity;
            ObjectEnvelope objectEnvelope2;
            ObjectReferenceDescriptor objectReferenceDescriptor = (ObjectReferenceDescriptor)iterator.next();
            Object object = objectReferenceDescriptor.getPersistentField().get(objectEnvelope.getObject());
            if (object == null || (objectEnvelope2 = (ObjectEnvelope)this.mhtObjectEnvelopes.get(identity = new Identity(object, this.transaction.getBroker()))) == null) continue;
            this.mhtObjectEnvelopes.remove(identity);
            this.mvOrderOfIds.set((Integer)map2.get(identity), null);
            this.reorderObject(map, list, objectEnvelope2, identity, map2);
        }
    }

    private OdmgConfiguration getConfiguration() {
        OdmgConfiguration odmgConfiguration = (OdmgConfiguration)((Object)PersistenceBrokerFactory.getConfigurator().getConfigurationFor(null));
        return odmgConfiguration;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

