/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.odmg.collections;

import java.util.ListIterator;
import org.apache.ojb.odmg.TransactionImpl;
import org.apache.ojb.odmg.TxManagerFactory;
import org.apache.ojb.odmg.collections.DListEntry;
import org.apache.ojb.odmg.collections.DListImpl;

class DListIterator
implements ListIterator {
    protected ListIterator iter;
    private DListImpl dlist;
    private DListEntry currentEntry = null;

    public DListIterator(DListImpl dListImpl) {
        this.dlist = dListImpl;
        this.iter = dListImpl.getElements().listIterator();
    }

    public DListIterator(DListImpl dListImpl, int n) {
        this.dlist = dListImpl;
        this.iter = dListImpl.getElements().listIterator(n);
    }

    public void add(Object object) {
        DListEntry dListEntry = new DListEntry(this.dlist, object);
        dListEntry.setPosition(this.nextIndex() - 1);
        this.iter.add(dListEntry);
        TransactionImpl transactionImpl = TxManagerFactory.instance().getTransaction();
        if (transactionImpl != null) {
            transactionImpl.lock(dListEntry, 4);
        }
    }

    public boolean hasNext() {
        return this.iter.hasNext();
    }

    public boolean hasPrevious() {
        return this.iter.hasPrevious();
    }

    public Object next() {
        this.currentEntry = (DListEntry)this.iter.next();
        return this.currentEntry.getRealSubject();
    }

    public int nextIndex() {
        return this.iter.nextIndex();
    }

    public Object previous() {
        this.currentEntry = (DListEntry)this.iter.previous();
        return this.currentEntry.getRealSubject();
    }

    public int previousIndex() {
        return this.iter.previousIndex();
    }

    public void remove() {
        this.iter.remove();
        TransactionImpl transactionImpl = TxManagerFactory.instance().getTransaction();
        if (transactionImpl != null) {
            transactionImpl.markDelete(this.currentEntry);
        }
        this.currentEntry = null;
    }

    public void set(Object object) {
        this.currentEntry.setRealSubject(object);
    }
}

