/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.odmg.collections;

import java.io.Serializable;
import java.util.Map;
import org.apache.ojb.broker.Identity;
import org.apache.ojb.broker.PBKey;
import org.apache.ojb.broker.PersistenceBroker;
import org.apache.ojb.broker.PersistenceBrokerException;
import org.apache.ojb.broker.PersistenceBrokerFactory;
import org.apache.ojb.broker.metadata.FieldDescriptor;
import org.apache.ojb.broker.metadata.fieldaccess.PersistentFieldFactory;
import org.apache.ojb.broker.util.logging.Logger;
import org.apache.ojb.broker.util.logging.LoggerFactory;
import org.apache.ojb.odmg.PBCapsule;
import org.apache.ojb.odmg.TransactionImpl;
import org.apache.ojb.odmg.TxManagerFactory;
import org.apache.ojb.odmg.collections.DMapImpl;

public class DMapEntry
implements Map.Entry,
Serializable {
    private static final long serialVersionUID = 4382757889982004339L;
    private Logger log = LoggerFactory.getLogger(class$org$apache$ojb$odmg$collections$DMapEntry == null ? (class$org$apache$ojb$odmg$collections$DMapEntry = DMapEntry.class$("org.apache.ojb.odmg.collections.DMapEntry")) : class$org$apache$ojb$odmg$collections$DMapEntry);
    private int id;
    private int dmapId;
    private Identity keyOID;
    private Object keyRealSubject;
    private Identity valueOID;
    private Object valueRealSubject;
    private PBKey pbKey;
    static /* synthetic */ Class class$org$apache$ojb$odmg$collections$DMapEntry;

    public DMapEntry() {
    }

    public DMapEntry(PBKey pBKey) {
        this.pbKey = pBKey;
    }

    public DMapEntry(int n, int n2, Identity identity, Identity identity2) {
        this.id = n;
        this.dmapId = n2;
        this.keyOID = identity;
        this.valueOID = identity2;
    }

    public DMapEntry(DMapImpl dMapImpl, Object object, Object object2) {
        this.pbKey = dMapImpl.getPBKey();
        if (!PersistentFieldFactory.usesAccessorsAndMutators()) {
            this.id = this.generateNewId();
        }
        this.dmapId = dMapImpl.getId();
        this.keyRealSubject = object;
        PersistenceBroker persistenceBroker = PersistenceBrokerFactory.defaultPersistenceBroker();
        this.keyOID = new Identity(object, persistenceBroker);
        this.valueRealSubject = object2;
        this.valueOID = new Identity(object2, persistenceBroker);
        persistenceBroker.close();
    }

    protected int generateNewId() {
        PBCapsule pBCapsule = new PBCapsule(null, TxManagerFactory.instance().getTransaction());
        try {
            int n;
            PersistenceBroker persistenceBroker = pBCapsule.getBroker();
            FieldDescriptor fieldDescriptor = persistenceBroker.getClassDescriptor(this.getClass()).getAutoIncrementFields()[0];
            Integer n2 = (Integer)persistenceBroker.serviceSequenceManager().getUniqueValue(fieldDescriptor);
            int n3 = n = n2.intValue();
            return n3;
        }
        catch (Exception exception) {
            LoggerFactory.getDefaultLogger().error("DMapEntry: Generation of new id failed", exception);
            throw new PersistenceBrokerException(exception);
        }
        finally {
            pBCapsule.destroy();
        }
    }

    public Object getKey() {
        if (this.keyRealSubject == null) {
            try {
                PBCapsule pBCapsule = new PBCapsule(this.pbKey, TxManagerFactory.instance().getTransaction());
                this.keyRealSubject = pBCapsule.getBroker().getObjectByIdentity(this.keyOID);
                pBCapsule.destroy();
            }
            catch (Exception exception) {
                this.log.error("Could not materialize key with keyOID " + this.keyOID, exception);
            }
        }
        return this.keyRealSubject;
    }

    public Object getValue() {
        if (this.valueRealSubject == null) {
            try {
                PBCapsule pBCapsule = new PBCapsule(this.pbKey, TxManagerFactory.instance().getTransaction());
                this.valueRealSubject = pBCapsule.getBroker().getObjectByIdentity(this.valueOID);
                pBCapsule.destroy();
            }
            catch (Exception exception) {
                this.log.error("Could not materialize value with valueOID " + this.valueOID, exception);
            }
        }
        return this.valueRealSubject;
    }

    public Object setValue(Object object) {
        TransactionImpl transactionImpl = TxManagerFactory.instance().getTransaction();
        if (transactionImpl != null) {
            transactionImpl.lock(this, 4);
        }
        this.valueRealSubject = object;
        PersistenceBroker persistenceBroker = PersistenceBrokerFactory.defaultPersistenceBroker();
        this.valueOID = new Identity(object, persistenceBroker);
        persistenceBroker.close();
        return object;
    }

    public int getDmapId() {
        return this.dmapId;
    }

    public void setDmapId(int n) {
        this.dmapId = n;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int n) {
        this.id = n;
    }

    public Identity getKeyOID() {
        return this.keyOID;
    }

    public void setKeyOID(Identity identity) {
        this.keyOID = identity;
    }

    public Identity getValueOID() {
        return this.valueOID;
    }

    public void setValueOID(Identity identity) {
        this.valueOID = identity;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

