/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.odmg.locking;

import org.apache.ojb.broker.PersistenceBrokerFactory;
import org.apache.ojb.broker.util.configuration.Configurator;
import org.apache.ojb.odmg.locking.InMemoryLockMapImpl;
import org.apache.ojb.odmg.locking.LockMap;
import org.apache.ojb.odmg.locking.LockingConfiguration;

public class LockMapFactory {
    private static LockMap LOCKMAP = null;

    public static synchronized LockMap getLockMap() {
        if (LOCKMAP == null) {
            LOCKMAP = LockMapFactory.createNewLockMap();
        }
        return LOCKMAP;
    }

    private static LockMap createNewLockMap() {
        try {
            Configurator configurator = PersistenceBrokerFactory.getConfigurator();
            LockingConfiguration lockingConfiguration = (LockingConfiguration)((Object)configurator.getConfigurationFor(null));
            Class clazz = lockingConfiguration.getLockMapClass();
            LockMap lockMap = (LockMap)clazz.newInstance();
            configurator.configure(lockMap);
            return lockMap;
        }
        catch (Exception exception) {
            return new InMemoryLockMapImpl();
        }
    }
}

