/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.odmg.locking;

import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;
import org.apache.ojb.broker.Identity;
import org.apache.ojb.broker.PersistenceBroker;
import org.apache.ojb.broker.PersistenceBrokerException;
import org.apache.ojb.broker.query.Criteria;
import org.apache.ojb.broker.query.QueryByCriteria;
import org.apache.ojb.broker.query.QueryFactory;
import org.apache.ojb.broker.util.configuration.Configuration;
import org.apache.ojb.broker.util.configuration.ConfigurationException;
import org.apache.ojb.broker.util.logging.Logger;
import org.apache.ojb.broker.util.logging.LoggerFactory;
import org.apache.ojb.odmg.TransactionImpl;
import org.apache.ojb.odmg.TxManagerFactory;
import org.apache.ojb.odmg.locking.AbstractLockStrategy;
import org.apache.ojb.odmg.locking.LockEntry;
import org.apache.ojb.odmg.locking.LockMap;
import org.apache.ojb.odmg.locking.LockStrategyFactory;

public class PersistentLockMapImpl
implements LockMap {
    private Logger log = LoggerFactory.getLogger(class$org$apache$ojb$odmg$locking$PersistentLockMapImpl == null ? (class$org$apache$ojb$odmg$locking$PersistentLockMapImpl = PersistentLockMapImpl.class$("org.apache.ojb.odmg.locking.PersistentLockMapImpl")) : class$org$apache$ojb$odmg$locking$PersistentLockMapImpl);
    static /* synthetic */ Class class$org$apache$ojb$odmg$locking$PersistentLockMapImpl;
    static /* synthetic */ Class class$org$apache$ojb$odmg$locking$LockEntry;

    private PersistenceBroker getBroker() {
        return TxManagerFactory.instance().getCurrentTransaction().getBroker();
    }

    private void unCache(LockEntry lockEntry) {
        if (lockEntry != null) {
            try {
                this.getBroker().removeFromCache(lockEntry);
            }
            catch (PersistenceBrokerException persistenceBrokerException) {
                this.log.error("Could not remove entry from cache " + lockEntry, (Throwable)((Object)persistenceBrokerException));
            }
        }
    }

    private void unCache(Collection collection) {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            try {
                this.getBroker().removeFromCache(iterator.next());
            }
            catch (PersistenceBrokerException persistenceBrokerException) {
                this.log.error("Could not remove entry from cache", (Throwable)((Object)persistenceBrokerException));
            }
        }
    }

    public LockEntry getWriter(Object object) {
        this.removeTimedOutLocks(AbstractLockStrategy.DEFAULT_LOCK_TIMEOUT);
        PersistenceBroker persistenceBroker = this.getBroker();
        Identity identity = new Identity(object, persistenceBroker);
        Criteria criteria = new Criteria();
        criteria.addEqualTo("oidString", identity.toString());
        criteria.addEqualTo("lockType", new Integer(LockEntry.LOCK_WRITE));
        QueryByCriteria queryByCriteria = QueryFactory.newQuery(class$org$apache$ojb$odmg$locking$LockEntry == null ? (class$org$apache$ojb$odmg$locking$LockEntry = PersistentLockMapImpl.class$("org.apache.ojb.odmg.locking.LockEntry")) : class$org$apache$ojb$odmg$locking$LockEntry, criteria);
        LockEntry lockEntry = null;
        try {
            lockEntry = (LockEntry)this.getBroker().getObjectByQuery(queryByCriteria);
        }
        catch (PersistenceBrokerException persistenceBrokerException) {
            this.log.error((Object)persistenceBrokerException);
        }
        this.unCache(lockEntry);
        return lockEntry;
    }

    public Collection getReaders(Object object) {
        this.removeTimedOutLocks(AbstractLockStrategy.DEFAULT_LOCK_TIMEOUT);
        Identity identity = new Identity(object, this.getBroker());
        Criteria criteria = new Criteria();
        criteria.addEqualTo("oidString", identity.toString());
        criteria.addEqualTo("lockType", new Integer(LockEntry.LOCK_READ));
        QueryByCriteria queryByCriteria = QueryFactory.newQuery(class$org$apache$ojb$odmg$locking$LockEntry == null ? (class$org$apache$ojb$odmg$locking$LockEntry = PersistentLockMapImpl.class$("org.apache.ojb.odmg.locking.LockEntry")) : class$org$apache$ojb$odmg$locking$LockEntry, criteria);
        try {
            Collection collection = this.getBroker().getCollectionByQuery(queryByCriteria);
            this.unCache(collection);
            return collection;
        }
        catch (PersistenceBrokerException persistenceBrokerException) {
            this.log.error("Cannot obtain collection of LockEntries, query was " + queryByCriteria, (Throwable)((Object)persistenceBrokerException));
            return new Vector();
        }
    }

    public boolean addReader(TransactionImpl transactionImpl, Object object) {
        this.removeTimedOutLocks(AbstractLockStrategy.DEFAULT_LOCK_TIMEOUT);
        try {
            LockEntry lockEntry = new LockEntry(new Identity(object, this.getBroker()).toString(), transactionImpl.getGUID(), System.currentTimeMillis(), LockStrategyFactory.getIsolationLevel(object), LockEntry.LOCK_READ);
            this.getBroker().store(lockEntry);
            this.unCache(lockEntry);
            return true;
        }
        catch (PersistenceBrokerException persistenceBrokerException) {
            this.log.error("Cannot store LockEntry for object " + object + " in transaction " + transactionImpl);
            return false;
        }
    }

    public void removeReader(TransactionImpl transactionImpl, Object object) {
        try {
            LockEntry lockEntry = new LockEntry(new Identity(object, this.getBroker()).toString(), transactionImpl.getGUID());
            this.getBroker().delete(lockEntry);
            this.unCache(lockEntry);
        }
        catch (PersistenceBrokerException persistenceBrokerException) {
            this.log.error("Cannot remove LockEntry for object " + object + " in transaction " + transactionImpl);
        }
    }

    public void removeWriter(LockEntry lockEntry) {
        try {
            this.getBroker().delete(lockEntry);
            this.unCache(lockEntry);
        }
        catch (PersistenceBrokerException persistenceBrokerException) {
            this.log.error("Cannot remove LockEntry", (Throwable)((Object)persistenceBrokerException));
        }
    }

    public boolean upgradeLock(LockEntry lockEntry) {
        lockEntry.setLockType(LockEntry.LOCK_WRITE);
        try {
            this.getBroker().store(lockEntry);
            this.unCache(lockEntry);
            return true;
        }
        catch (PersistenceBrokerException persistenceBrokerException) {
            this.log.error("Cannot upgrade LockEntry " + lockEntry, (Throwable)((Object)persistenceBrokerException));
            return false;
        }
    }

    public boolean setWriter(TransactionImpl transactionImpl, Object object) {
        this.removeTimedOutLocks(AbstractLockStrategy.DEFAULT_LOCK_TIMEOUT);
        try {
            LockEntry lockEntry = new LockEntry(new Identity(object, this.getBroker()).toString(), transactionImpl.getGUID(), System.currentTimeMillis(), LockStrategyFactory.getIsolationLevel(object), LockEntry.LOCK_WRITE);
            this.getBroker().store(lockEntry);
            this.unCache(lockEntry);
            return true;
        }
        catch (PersistenceBrokerException persistenceBrokerException) {
            this.log.error("Cannot set LockEntry for object " + object + " in transaction " + transactionImpl);
            return false;
        }
    }

    public boolean hasReadLock(TransactionImpl transactionImpl, Object object) {
        this.removeTimedOutLocks(AbstractLockStrategy.DEFAULT_LOCK_TIMEOUT);
        try {
            LockEntry lockEntry = new LockEntry(new Identity(object, this.getBroker()).toString(), transactionImpl.getGUID());
            Identity identity = new Identity(lockEntry, this.getBroker());
            LockEntry lockEntry2 = (LockEntry)this.getBroker().getObjectByIdentity(identity);
            this.unCache(lockEntry2);
            return lockEntry2 != null;
        }
        catch (PersistenceBrokerException persistenceBrokerException) {
            this.log.error("Cannot check read lock for object " + object + " in transaction " + transactionImpl, (Throwable)((Object)persistenceBrokerException));
            return false;
        }
    }

    protected void removeTimedOutLocks(long l) {
        int n = 0;
        long l2 = System.currentTimeMillis() - l;
        Criteria criteria = new Criteria();
        criteria.addLessThan("timestamp", new Long(l2));
        QueryByCriteria queryByCriteria = QueryFactory.newQuery(class$org$apache$ojb$odmg$locking$LockEntry == null ? (class$org$apache$ojb$odmg$locking$LockEntry = PersistentLockMapImpl.class$("org.apache.ojb.odmg.locking.LockEntry")) : class$org$apache$ojb$odmg$locking$LockEntry, criteria);
        Iterator iterator = this.getBroker().getIteratorByQuery(queryByCriteria);
        while (iterator.hasNext()) {
            try {
                this.getBroker().delete(iterator.next());
                ++n;
            }
            catch (PersistenceBrokerException persistenceBrokerException) {
                this.log.error("Removing timed out lock failed", (Throwable)((Object)persistenceBrokerException));
            }
        }
        if (n > 0 && this.log.isDebugEnabled()) {
            this.log.debug("Removed " + n + " timedout locks");
        }
    }

    public void configure(Configuration configuration) throws ConfigurationException {
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

