/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.otm.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.ListIterator;
import org.apache.ojb.broker.Identity;
import org.apache.ojb.broker.PBKey;
import org.apache.ojb.broker.PersistenceBroker;
import org.apache.ojb.broker.PersistenceBrokerException;
import org.apache.ojb.broker.PersistenceBrokerFactory;
import org.apache.ojb.broker.accesslayer.OJBIterator;
import org.apache.ojb.broker.cache.ObjectCache;
import org.apache.ojb.broker.core.proxy.ProxyHelper;
import org.apache.ojb.broker.metadata.ClassDescriptor;
import org.apache.ojb.broker.query.Query;
import org.apache.ojb.broker.query.ReportQuery;
import org.apache.ojb.broker.util.configuration.ConfigurationException;
import org.apache.ojb.broker.util.configuration.Configurator;
import org.apache.ojb.odmg.oql.EnhancedOQLQuery;
import org.apache.ojb.odmg.oql.OQLQueryImpl;
import org.apache.ojb.otm.EditingContext;
import org.apache.ojb.otm.OTMConnection;
import org.apache.ojb.otm.copy.ObjectCopyStrategy;
import org.apache.ojb.otm.core.ConcreteEditingContext;
import org.apache.ojb.otm.core.LockingPassthruException;
import org.apache.ojb.otm.core.Transaction;
import org.apache.ojb.otm.core.TransactionException;
import org.apache.ojb.otm.core.TransactionNotInProgressException;
import org.apache.ojb.otm.lock.LockingException;
import org.odmg.ODMGRuntimeException;
import org.odmg.OQLQuery;
import org.odmg.QueryException;

public abstract class BaseConnection
implements OTMConnection {
    private PersistenceBroker _pb;
    private Transaction _tx;
    private ConcreteEditingContext _editingContext;
    private Configurator m_configurator;

    public BaseConnection(PBKey pBKey) {
        this._pb = PersistenceBrokerFactory.createPersistenceBroker(pBKey);
        this.m_configurator = PersistenceBrokerFactory.getConfigurator();
    }

    public void close() {
        this._pb.close();
        this._pb = null;
    }

    public boolean isClosed() {
        if (this._pb == null) {
            return true;
        }
        return this._pb.isClosed();
    }

    public PersistenceBroker getKernelBroker() {
        return this._pb;
    }

    public void setTransaction(Transaction transaction) {
        if (transaction == null) {
            this._editingContext = null;
        } else {
            if (this._tx != null) {
                throw new IllegalStateException("OTMConnection is already bound to the transacaction " + this._tx);
            }
            this._editingContext = new ConcreteEditingContext(transaction, this._pb);
        }
        this._tx = transaction;
    }

    public Transaction getTransaction() {
        return this._tx;
    }

    public Object getObjectByIdentity(Identity identity, int n) throws LockingException {
        Object object;
        this.checkTransaction("getObjectByIdentity");
        Object object2 = this._pb.getObjectByIdentity(identity);
        if (object2 == null) {
            object = this._editingContext.lookup(identity);
        } else {
            object = this.getUserObject(identity, object2);
            object = ProxyHelper.getRealObject(object);
            this._editingContext.insert(identity, object, n);
        }
        return object;
    }

    private void checkTransaction(String string) {
        if (null == this._tx) {
            throw new TransactionNotInProgressException(string + " requires a valid transaction. Please make sure you have created a new transaction, and called begin() on it.");
        }
        if (!this._tx.isInProgress()) {
            throw new TransactionNotInProgressException(string + " cannot be called before transaction begin() is called");
        }
    }

    public Object getObjectByIdentity(Identity identity) throws LockingException {
        return this.getObjectByIdentity(identity, 1);
    }

    public Iterator getIteratorByQuery(Query query) {
        return this.getIteratorByQuery(query, 1);
    }

    public Iterator getIteratorByQuery(Query query, int n) {
        this.checkTransaction("getIteratorByQuery");
        return new OTMIterator((OJBIterator)this._pb.getIteratorByQuery(query), n, null);
    }

    public Iterator getIteratorByOQLQuery(OQLQuery oQLQuery) {
        return this.getIteratorByOQLQuery(oQLQuery, 1);
    }

    public Iterator getIteratorByOQLQuery(OQLQuery oQLQuery, int n) {
        this.checkTransaction("getIteratorByOQLQuery");
        if (oQLQuery instanceof OTMOQLQueryImpl) {
            OTMOQLQueryImpl oTMOQLQueryImpl = (OTMOQLQueryImpl)oQLQuery;
            return new OTMIterator((OJBIterator)this._pb.getIteratorByQuery(oTMOQLQueryImpl.getQuery()), n, oTMOQLQueryImpl);
        }
        throw new IllegalArgumentException("The OQLQuery where created not via OTM API");
    }

    public Collection getCollectionByQuery(Query query, int n) {
        this.checkTransaction("getCollectionByQuery");
        Collection collection = this._pb.getCollectionByQuery(query);
        Collection collection2 = this.createCollectionOfTheSameClass(collection);
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            collection2.add(this.insertObject(iterator.next(), n));
        }
        return collection2;
    }

    public Collection getCollectionByQuery(Query query) {
        return this.getCollectionByQuery(query, 1);
    }

    public Identity getIdentity(Object object) {
        return new Identity(object, this._pb);
    }

    public ClassDescriptor getDescriptorFor(Class clazz) {
        return this._pb.getClassDescriptor(clazz);
    }

    public void invalidate(Identity identity) throws LockingException {
        if (null == this._tx) {
            throw new TransactionNotInProgressException("invalidate requires a valid transaction. Please make sure you have created a new transaction, and called begin() on it.");
        }
        this._editingContext.insert(identity, null, 1);
        this._pb.serviceObjectCache().remove(identity);
    }

    public ObjectCache serviceObjectCache() {
        return this._pb.serviceObjectCache();
    }

    public void invalidateAll() throws LockingException {
        this._pb.serviceObjectCache().clear();
    }

    public void lockForWrite(Object object) throws LockingException {
        this.checkTransaction("lockForWrite");
        this.makePersistent(object);
    }

    public void makePersistent(Object object) throws LockingException {
        this.checkTransaction("makePersistent");
        Identity identity = new Identity(object, this._pb);
        Object object2 = this._pb.getObjectByIdentity(identity);
        if (object2 != null && this._editingContext.lookup(identity) == null) {
            ObjectCopyStrategy objectCopyStrategy = this._tx.getKit().getCopyStrategy(identity);
            Object object3 = objectCopyStrategy.copy(object2, this._pb);
            this._editingContext.insert(identity, object3, 2);
        }
        this._editingContext.insert(identity, object, 2);
    }

    public void deletePersistent(Object object) throws LockingException {
        this.checkTransaction("deletePersistent");
        Identity identity = new Identity(object, this._pb);
        Object object2 = this._pb.getObjectByIdentity(identity);
        if (object2 == null) {
            this._editingContext.remove(identity);
        } else {
            if (this._editingContext.lookup(identity) == null) {
                ObjectCopyStrategy objectCopyStrategy = this._tx.getKit().getCopyStrategy(identity);
                Object object3 = objectCopyStrategy.copy(object2, this._pb);
                this._editingContext.insert(identity, object3, 2);
            }
            this._editingContext.deletePersistent(identity, object);
        }
    }

    public void refresh(Object object) {
        this.checkTransaction("refresh");
        Identity identity = new Identity(object, this._pb);
        this._editingContext.refresh(identity, object);
    }

    public EditingContext getEditingContext() {
        return this._editingContext;
    }

    public EnhancedOQLQuery newOQLQuery() {
        return this.newOQLQuery(1);
    }

    public EnhancedOQLQuery newOQLQuery(int n) {
        this.checkTransaction("newOQLQuery");
        OTMOQLQueryImpl oTMOQLQueryImpl = new OTMOQLQueryImpl(this._pb.getPBKey(), n);
        try {
            this.m_configurator.configure(oTMOQLQueryImpl);
        }
        catch (ConfigurationException configurationException) {
            throw new ODMGRuntimeException("Error in configuration of OQLQueryImpl instance: " + configurationException.getMessage());
        }
        return oTMOQLQueryImpl;
    }

    public int getCount(Query query) {
        this.checkTransaction("getCount");
        return this._pb.getCount(query);
    }

    private Object insertObject(Object object, int n) {
        Identity identity = this.getIdentity(object);
        Object object2 = this.getUserObject(identity, object);
        try {
            this._editingContext.insert(identity, object2, n);
        }
        catch (LockingException lockingException) {
            throw new LockingPassthruException(lockingException);
        }
        return object2;
    }

    private Object getUserObject(Identity identity, Object object) {
        Object object2 = this._editingContext.lookup(identity);
        if (object2 == null) {
            ObjectCopyStrategy objectCopyStrategy = this._tx.getKit().getCopyStrategy(identity);
            object2 = objectCopyStrategy.copy(object, this._pb);
        }
        return object2;
    }

    private Collection createCollectionOfTheSameClass(Collection collection) {
        try {
            return (Collection)collection.getClass().newInstance();
        }
        catch (Throwable throwable) {
            return new ArrayList();
        }
    }

    public abstract void transactionBegin() throws TransactionException;

    public abstract void transactionPrepare() throws TransactionException;

    public abstract void transactionCommit() throws TransactionException;

    public abstract void transactionRollback() throws TransactionException;

    private class OTMOQLQueryImpl
    extends OQLQueryImpl {
        int _lock;

        public OTMOQLQueryImpl(PBKey pBKey, int n) {
            super(pBKey);
            this._lock = n;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object execute() throws QueryException {
            Collection<Object> collection;
            Iterator iterator = null;
            Query query = this.getQuery();
            try {
                if (!(query instanceof ReportQuery)) {
                    Collection collection2 = BaseConnection.this._pb.getCollectionByQuery(query);
                    collection = BaseConnection.this.createCollectionOfTheSameClass(collection2);
                    iterator = collection2.iterator();
                    while (iterator.hasNext()) {
                        collection.add(BaseConnection.this.insertObject(iterator.next(), this._lock));
                    }
                } else {
                    collection = new ArrayList();
                    iterator = BaseConnection.this._pb.getReportQueryIteratorByQuery(query);
                    block3: while (iterator.hasNext()) {
                        Object[] objectArray = (Object[])iterator.next();
                        if (objectArray.length == 1) {
                            if (objectArray[0] == null) continue;
                            collection.add(objectArray[0]);
                            continue;
                        }
                        for (int i = 0; i < objectArray.length; ++i) {
                            if (objectArray[i] == null) continue;
                            collection.add(objectArray);
                            continue block3;
                        }
                    }
                }
                this.resetBindIterator();
                Object var7_7 = null;
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                if (iterator != null && iterator instanceof OJBIterator) {
                    ((OJBIterator)iterator).releaseDbResources();
                }
                throw throwable;
            }
            if (iterator != null && iterator instanceof OJBIterator) {
                ((OJBIterator)iterator).releaseDbResources();
            }
            return collection;
        }

        void resetBindIterator() {
            ListIterator listIterator = this.getBindIterator();
            while (listIterator.hasPrevious()) {
                listIterator.previous();
            }
        }
    }

    private class OTMIterator
    implements OJBIterator {
        private final OJBIterator _it;
        private final int _lock;
        private final OTMOQLQueryImpl _oqlQuery;

        OTMIterator(OJBIterator oJBIterator, int n, OTMOQLQueryImpl oTMOQLQueryImpl) {
            this._it = oJBIterator;
            this._lock = n;
            this._oqlQuery = oTMOQLQueryImpl;
        }

        public boolean hasNext() {
            boolean bl = this._it.hasNext();
            if (!bl) {
                this.done();
            }
            return bl;
        }

        public Object next() {
            Object object = this._it.next();
            object = BaseConnection.this.insertObject(object, this._lock);
            return object;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }

        public void done() {
            this.releaseDbResources();
            if (this._oqlQuery != null) {
                this._oqlQuery.resetBindIterator();
            }
        }

        protected void finalize() {
            this.done();
        }

        public boolean absolute(int n) throws PersistenceBrokerException {
            return this._it.absolute(n);
        }

        public int fullSize() throws PersistenceBrokerException {
            return this._it.fullSize();
        }

        public boolean relative(int n) throws PersistenceBrokerException {
            return this._it.relative(n);
        }

        public void releaseDbResources() {
            this._it.releaseDbResources();
        }

        public int size() throws PersistenceBrokerException {
            return this._it.size();
        }
    }
}

