/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.otm.transaction;

import java.util.HashMap;
import org.apache.ojb.broker.PBKey;
import org.apache.ojb.otm.OTMConnection;
import org.apache.ojb.otm.core.BaseConnection;
import org.apache.ojb.otm.core.Transaction;
import org.apache.ojb.otm.core.TransactionException;
import org.apache.ojb.otm.transaction.TransactionFactory;
import org.apache.ojb.otm.transaction.TransactionFactoryException;

public class LocalTransactionFactory
implements TransactionFactory {
    private HashMap _transactionMap = new HashMap();

    public Transaction getTransactionForConnection(OTMConnection oTMConnection) {
        if (!(oTMConnection instanceof BaseConnection)) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("Unknown connection type: ");
            if (oTMConnection != null) {
                stringBuffer.append(oTMConnection.getClass().getName());
            } else {
                stringBuffer.append(" null. Make sure you pass a non-null OTMConnection to this method. An OTMConnection can be acquired by calling acquireConnection (PBKey pbKey)");
            }
            throw new TransactionFactoryException(stringBuffer.toString());
        }
        Transaction transaction = (Transaction)this._transactionMap.get(oTMConnection);
        if (transaction == null) {
            transaction = new Transaction();
            this._transactionMap.put(oTMConnection, transaction);
        }
        transaction.registerConnection(oTMConnection);
        return transaction;
    }

    public OTMConnection acquireConnection(PBKey pBKey) {
        LocalConnection localConnection = new LocalConnection(pBKey);
        this.getTransactionForConnection(localConnection);
        return localConnection;
    }

    private static class LocalConnection
    extends BaseConnection {
        public LocalConnection(PBKey pBKey) {
            super(pBKey);
        }

        public void transactionBegin() throws TransactionException {
            this.getKernelBroker().beginTransaction();
        }

        public void transactionPrepare() throws TransactionException {
        }

        public void transactionCommit() throws TransactionException {
            this.getKernelBroker().commitTransaction();
        }

        public void transactionRollback() throws TransactionException {
            this.getKernelBroker().abortTransaction();
        }
    }
}

