/*
 * Decompiled with CFR 0.152.
 */
package xjavadoc;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import xjavadoc.AbstractClass;
import xjavadoc.DefaultXTag;
import xjavadoc.NodeParser;
import xjavadoc.NodePrinter;
import xjavadoc.ParseException;
import xjavadoc.Primitive;
import xjavadoc.SimpleNode;
import xjavadoc.SimpleParser;
import xjavadoc.TagValidationException;
import xjavadoc.TokenMgrError;
import xjavadoc.UnknownClass;
import xjavadoc.XClass;
import xjavadoc.XJavaDoc;
import xjavadoc.XPackage;
import xjavadoc.XTag;
import xjavadoc.XTagFactory;
import xjavadoc.filesystem.AbstractFile;
import xjavadoc.filesystem.ReaderFile;
import xjavadoc.filesystem.XJavadocFile;

public final class SourceClass
extends AbstractClass {
    public static int instanceCount = 0;
    private final Map _qualifiedClasses = new HashMap();
    private final boolean _isExtraClass;
    private final List _tagsForValidation = new ArrayList();
    private SimpleNode _compilationUnit;
    private Reader _in = null;
    private AbstractFile _sourceFile;
    private boolean _dirty;

    public SourceClass(SourceClass containingClass, XTagFactory tagFactory) {
        super(containingClass, tagFactory);
        this.setContainingPackage(containingClass.getContainingPackage().getName());
        this._isExtraClass = false;
    }

    public SourceClass(SourceClass mainClass, int dummy, XTagFactory tagFactory) {
        super(mainClass.getXJavaDoc(), tagFactory);
        this.setContainingPackage(mainClass.getContainingPackage().getName());
        this._isExtraClass = true;
        this._sourceFile = mainClass.getFile();
    }

    public SourceClass(XJavaDoc xJavaDoc, File sourceFile, XTagFactory tagFactory) {
        this(xJavaDoc, new XJavadocFile(sourceFile), false, tagFactory, null);
    }

    public SourceClass(XJavaDoc xJavaDoc, Reader sourceFile, XTagFactory tagFactory) {
        this(xJavaDoc, new ReaderFile(sourceFile), false, tagFactory, null);
    }

    public SourceClass(XJavaDoc xJavaDoc, File sourceFile, boolean useNodeParser, XTagFactory tagFactory) {
        this(xJavaDoc, new XJavadocFile(sourceFile), useNodeParser, tagFactory, null);
    }

    public SourceClass(XJavaDoc xJavaDoc, AbstractFile sourceFile, boolean useNodeParser, XTagFactory tagFactory, String encoding) {
        super(xJavaDoc, tagFactory);
        if (sourceFile == null) {
            throw new IllegalArgumentException("sourceFile can't be null for outer classes!");
        }
        this._sourceFile = sourceFile;
        try {
            this._in = sourceFile.getReader(encoding);
            this.parse(useNodeParser);
        }
        catch (IOException e) {
            if (encoding == null) {
                throw new IllegalStateException("Couldn't find " + sourceFile);
            }
            throw new IllegalStateException("Invalid Encoding '" + encoding + "' or couldn't find '" + sourceFile + "'");
        }
        ++instanceCount;
        this._dirty = false;
        this._isExtraClass = false;
    }

    public static String getFileName(String qualifiedName) {
        return qualifiedName.replace('.', File.separatorChar) + ".java";
    }

    public boolean isExtraClass() {
        return this._isExtraClass;
    }

    public String getNextAnonymousClassName() {
        return String.valueOf(this.getInnerClasses().size() + 1);
    }

    private boolean isOuterClass() {
        return this._sourceFile != null;
    }

    public boolean isWriteable() {
        return this._compilationUnit != null;
    }

    public SimpleNode getCompilationUnit() {
        return this._compilationUnit;
    }

    public Reader getReader() {
        return this._in;
    }

    public AbstractFile getFile() {
        return this._sourceFile;
    }

    public boolean isPrimitive() {
        return false;
    }

    public void setDirty() {
        if (this.isInner()) {
            this.getContainingClass().setDirty();
        } else {
            this._dirty = true;
        }
    }

    public void setCompilationUnit(SimpleNode compilationUnit) {
        this._compilationUnit = compilationUnit;
    }

    public void validateTags() throws TagValidationException {
        Iterator i = this._tagsForValidation.iterator();
        while (i.hasNext()) {
            XTag tag = (XTag)i.next();
            tag.validate();
        }
        Iterator i2 = this.getInnerClasses().iterator();
        while (i2.hasNext()) {
            SourceClass inner = (SourceClass)i2.next();
            inner.validateTags();
        }
    }

    public void addTagForValidation(DefaultXTag tag) {
        this._tagsForValidation.add(tag);
    }

    public boolean saveNeeded() {
        return this.isWriteable() && this._dirty;
    }

    public long lastModified() {
        if (this.isOuterClass()) {
            return this._sourceFile.lastModified();
        }
        return this.getContainingClass().lastModified();
    }

    public void print(OutputStream out) {
        this.print(new OutputStreamWriter(out));
    }

    public void print(Writer out) {
        this.updateDoc();
        if (!this.isWriteable()) {
            throw new UnsupportedOperationException("Can't save classes that are parsed with simpleparser");
        }
        NodePrinter.print(this._compilationUnit, out);
    }

    public String save(File rootDir) throws IOException {
        if (!this.isWriteable()) {
            throw new UnsupportedOperationException("Can't save classes that aren't parsed in AST mode (do getXJavaDoc().setUseNodeParser(true) before parsing starts!)");
        }
        if (this.getContainingClass() != null) {
            throw new UnsupportedOperationException("Can't save inner classes");
        }
        if (rootDir != null) {
            String fileName = SourceClass.getFileName(this.getQualifiedName());
            File javaFile = new File(rootDir, fileName);
            javaFile.getParentFile().mkdirs();
            this.print(new FileWriter(javaFile));
            return fileName;
        }
        Writer outputStream = this._sourceFile.getWriter();
        this.print(new PrintWriter(outputStream));
        outputStream.flush();
        outputStream.close();
        return this._sourceFile.toString();
    }

    public XClass qualify(String unqualifiedClassName) {
        XClass result = null;
        result = (XClass)this._qualifiedClasses.get(unqualifiedClassName);
        if (result == null) {
            if (this.getContainingClass() == null) {
                if (unqualifiedClassName.indexOf(46) != -1) {
                    result = this.unqualifiedNameInImportedClassesInnerClasses(unqualifiedClassName);
                    if (result == null) {
                        result = this.getXJavaDoc().getXClass(unqualifiedClassName);
                    }
                } else {
                    Primitive primitive = XJavaDoc.getPrimitive(unqualifiedClassName);
                    if (primitive != null) {
                        result = primitive;
                    } else {
                        String qualifiedName = this.unqualifiedNameInTheSameClassAsAnInnerClass(unqualifiedClassName);
                        if (qualifiedName != null) {
                            result = this.getXJavaDoc().getXClass(qualifiedName);
                        } else {
                            qualifiedName = this.unqualifiedNameInInnerClasses(unqualifiedClassName);
                            if (qualifiedName != null) {
                                result = this.getXJavaDoc().getXClass(qualifiedName);
                            } else {
                                qualifiedName = this.unqualifiedNameInJavaDotLang(unqualifiedClassName);
                                if (qualifiedName != null) {
                                    result = this.getXJavaDoc().getXClass(qualifiedName);
                                } else {
                                    qualifiedName = this.unqualifiedNameInImportedClasses(unqualifiedClassName);
                                    if (qualifiedName != null) {
                                        result = this.getXJavaDoc().getXClass(qualifiedName);
                                    } else {
                                        qualifiedName = this.unqualifiedNameInImportedPackages(unqualifiedClassName);
                                        if (qualifiedName != null) {
                                            result = this.getXJavaDoc().getXClass(qualifiedName);
                                        } else {
                                            qualifiedName = this.unqualifiedNameInTheSamePackage(unqualifiedClassName);
                                            if (qualifiedName != null) {
                                                result = this.getXJavaDoc().getXClass(qualifiedName);
                                            } else {
                                                qualifiedName = this.unqualifiedNameInInnerClassesOfSuperClass(unqualifiedClassName);
                                                if (qualifiedName != null) {
                                                    result = this.getXJavaDoc().getXClass(qualifiedName);
                                                } else {
                                                    qualifiedName = this.unqualifiedNameInInnerInterface(unqualifiedClassName);
                                                    if (qualifiedName != null) {
                                                        result = this.getXJavaDoc().getXClass(qualifiedName);
                                                    } else {
                                                        String unknownClassName = this.getContainingPackage().getName().equals("") ? unqualifiedClassName : this.getContainingPackage().getName() + "." + unqualifiedClassName;
                                                        UnknownClass unknownClass = new UnknownClass(this.getXJavaDoc(), unknownClassName);
                                                        if (!this.hasImportedPackages()) {
                                                            this.getXJavaDoc().logMessage(this, unknownClass, unqualifiedClassName, 0);
                                                        } else {
                                                            this.getXJavaDoc().logMessage(this, unknownClass, unqualifiedClassName, 1);
                                                        }
                                                        result = unknownClass;
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            } else {
                result = this.getContainingAbstractClass().qualify(unqualifiedClassName);
            }
            this._qualifiedClasses.put(unqualifiedClassName, result);
        }
        return result;
    }

    public void reset() {
        super.reset();
        this._compilationUnit = null;
        this._in = null;
        this._sourceFile = null;
        this._qualifiedClasses.clear();
    }

    private final String unqualifiedNameInImportedClasses(String unqualifiedClassName) {
        if (!this.hasImportedClasses()) {
            return null;
        }
        String suffix = "." + unqualifiedClassName;
        String candidate = null;
        Iterator i = this.getImportedClasses().iterator();
        while (i.hasNext()) {
            XClass clazz = (XClass)i.next();
            String qualifiedClassName = clazz.getQualifiedName();
            if (!qualifiedClassName.endsWith(suffix)) continue;
            if (candidate != null && !candidate.equals(qualifiedClassName)) {
                throw new IllegalStateException("In class " + this.getQualifiedName() + ": Ambiguous class:" + unqualifiedClassName + ". Is it " + candidate + " or " + qualifiedClassName + "?");
            }
            candidate = qualifiedClassName;
        }
        return candidate;
    }

    private final XClass unqualifiedNameInImportedClassesInnerClasses(String unqualifiedClassName) {
        if (!this.hasImportedClasses()) {
            return null;
        }
        XClass candidate = null;
        Iterator i = this.getImportedClasses().iterator();
        while (i.hasNext()) {
            XClass clazz = (XClass)i.next();
            Iterator inners = clazz.getInnerClasses().iterator();
            while (inners.hasNext()) {
                XClass inner = (XClass)inners.next();
                boolean isAccessible = inner.isPublic();
                if (!inner.getName().equals(unqualifiedClassName) || !isAccessible) continue;
                if (candidate != null) {
                    throw new IllegalStateException("In class " + this.getQualifiedName() + ": Ambiguous class:" + unqualifiedClassName + ". Is it " + candidate.getQualifiedName() + " or " + inner.getQualifiedName() + "?");
                }
                candidate = inner;
            }
        }
        return candidate;
    }

    private final String unqualifiedNameInInnerClasses(String unqualifiedClassName) {
        if (!this.hasInnerClasses()) {
            return null;
        }
        String innerClassName = this.getQualifiedName() + '.' + unqualifiedClassName;
        String candidate = null;
        Iterator i = this.getInnerClasses().iterator();
        while (i.hasNext()) {
            XClass innerClass = (XClass)i.next();
            String qualifiedClassName = innerClass.getQualifiedName();
            if (!innerClassName.equals(qualifiedClassName)) continue;
            candidate = qualifiedClassName;
            break;
        }
        return candidate;
    }

    private final String unqualifiedNameInInnerInterface(String unqualifiedClassName) {
        String qualifiedClassName = this.getQualifiedName() + '$' + unqualifiedClassName;
        if (this.getXJavaDoc().classExists(qualifiedClassName)) {
            return this.getQualifiedName() + '.' + unqualifiedClassName;
        }
        return null;
    }

    private final String unqualifiedNameInInnerClassesOfSuperClass(String unqualifiedClassName) {
        XClass clazz = this.getXJavaDoc().getXClass(this.getQualifiedName());
        XClass superClazz = clazz.getSuperclass();
        while (superClazz != null && !superClazz.getQualifiedName().equals("java.lang.Object")) {
            String innerClassName = superClazz.getQualifiedName() + '.' + unqualifiedClassName;
            Iterator i = superClazz.getInnerClasses().iterator();
            while (i.hasNext()) {
                XClass innerClass = (XClass)i.next();
                String qualifiedClassName = innerClass.getQualifiedName();
                if (!innerClassName.equals(qualifiedClassName)) continue;
                return qualifiedClassName;
            }
            superClazz = superClazz.getSuperclass();
        }
        return null;
    }

    private final String unqualifiedNameInImportedPackages(String unqualifiedClassName) {
        if (!this.hasImportedPackages()) {
            return null;
        }
        String suffix = "." + unqualifiedClassName;
        String candidate = null;
        Iterator i = this.getImportedPackages().iterator();
        while (i.hasNext()) {
            String importedPackageName = ((XPackage)i.next()).getName();
            String qualifiedClassName = importedPackageName + suffix;
            if (!this.getXJavaDoc().classExists(qualifiedClassName)) continue;
            if (candidate != null && !candidate.equals(qualifiedClassName)) {
                throw new IllegalStateException("In class " + this.getQualifiedName() + ": Ambiguous class:" + unqualifiedClassName + ". Is it " + candidate + " or " + qualifiedClassName + "?");
            }
            candidate = qualifiedClassName;
        }
        return candidate;
    }

    private final String unqualifiedNameInJavaDotLang(String unqualifiedClassName) {
        String qualifiedClassName = "java.lang." + unqualifiedClassName;
        if (this.getXJavaDoc().classExists(qualifiedClassName)) {
            return qualifiedClassName;
        }
        return null;
    }

    private final String unqualifiedNameInTheSamePackage(String unqualifiedClassName) {
        String qualifiedClassName = this.getContainingPackage().getName().equals("") ? unqualifiedClassName : this.getContainingPackage().getName() + '.' + unqualifiedClassName;
        if (this.getXJavaDoc().classExists(qualifiedClassName)) {
            return qualifiedClassName;
        }
        return null;
    }

    private final String unqualifiedNameInTheSameClassAsAnInnerClass(String unqualifiedClassName) {
        String qualifiedClassName = this.getQualifiedName() + '.' + unqualifiedClassName;
        if (this.getXJavaDoc().classExists(qualifiedClassName)) {
            return qualifiedClassName;
        }
        qualifiedClassName = this.getContainingPackage().getName().equals("") ? unqualifiedClassName : this.getContainingPackage().getName() + '.' + unqualifiedClassName;
        if (this.getXJavaDoc().classExists(qualifiedClassName)) {
            return qualifiedClassName;
        }
        return null;
    }

    private void parse(boolean useNodeParser) {
        try {
            if (useNodeParser) {
                new NodeParser(this.getXJavaDoc(), this.getTagFactory()).populate(this);
            } else {
                new SimpleParser(this.getXJavaDoc(), this.getTagFactory()).populate(this);
            }
        }
        catch (ParseException e) {
            String cls = this._sourceFile != null ? this._sourceFile.toString() : this.getQualifiedName();
            System.err.println("Error parsing " + cls + ':' + e.getMessage());
        }
        catch (TokenMgrError e) {
            String cls = this._sourceFile != null ? this._sourceFile.toString() : this.getQualifiedName();
            System.err.println("Error parsing " + cls + ':' + e.getMessage());
        }
    }
}

