/*
 * Decompiled with CFR 0.152.
 */
package xjavadoc.codeunit;

import java.io.File;
import java.io.Reader;
import java.io.StringWriter;
import java.util.Iterator;
import java.util.StringTokenizer;
import junit.framework.Assert;
import junit.framework.TestCase;
import xjavadoc.Named;
import xjavadoc.NodePrinter;
import xjavadoc.SimpleNode;
import xjavadoc.SourceClass;
import xjavadoc.Type;
import xjavadoc.XClass;
import xjavadoc.XConstructor;
import xjavadoc.XExecutableMember;
import xjavadoc.XField;
import xjavadoc.XJavaDoc;
import xjavadoc.XMethod;
import xjavadoc.XParameter;
import xjavadoc.XProgramElement;
import xjavadoc.XTagFactory;
import xjavadoc.filesystem.ReaderFile;

public abstract class CodeTestCase
extends TestCase {
    public static void assertAstEqualsDir(File expectedDir, File actualDir) {
        if (!expectedDir.isDirectory()) {
            Assert.fail((String)(expectedDir.getAbsolutePath() + " - should have been a directory"));
        }
        if (!actualDir.isDirectory()) {
            Assert.fail((String)(actualDir.getAbsolutePath() + " - should have been a directory"));
        }
        File[] expectedChildren = expectedDir.listFiles();
        int i = 0;
        while (i < expectedChildren.length) {
            File expectedChild = expectedChildren[i];
            File actualChild = CodeTestCase.getActualChild(actualDir, expectedChild);
            if (!actualChild.exists()) {
                Assert.fail((String)("File should have existed: " + actualChild.getAbsolutePath()));
            }
            if (expectedChild.isDirectory() && !actualChild.isDirectory() || !expectedChild.isDirectory() && actualChild.isDirectory()) {
                Assert.fail((String)("Incompatible file types: " + expectedChild.getAbsolutePath() + "," + actualChild.getAbsolutePath()));
            }
            if (expectedChild.isDirectory()) {
                CodeTestCase.assertAstEqualsDir(expectedChild, actualChild);
            } else if (expectedChild.getName().endsWith(".java")) {
                System.out.println("Comparing " + expectedChild.getAbsolutePath());
                CodeTestCase.assertAstEquals(expectedChild, actualChild);
            } else {
                System.out.println("Ignoring non java file: " + expectedChild.getAbsolutePath());
            }
            ++i;
        }
    }

    private static File getActualChild(File actualDir, File expectedChild) {
        return new File(actualDir, expectedChild.getName());
    }

    public static void assertEquals(File expected, File actual) {
        CodeTestCase.assertAstEquals(expected, actual);
        CodeTestCase.assertApiEquals(expected, actual);
    }

    public static void assertEquals(Reader expected, Reader actual) {
        CodeTestCase.assertAstEquals(expected, actual);
        CodeTestCase.assertApiEquals(expected, actual);
    }

    public static void assertAstEquals(File expected, File actual) {
        CodeTestCase.checkNotDir(expected, actual);
        SourceClass expectedClass = new SourceClass(new XJavaDoc(), expected, true, new XTagFactory());
        SourceClass actualClass = new SourceClass(new XJavaDoc(), actual, true, new XTagFactory());
        CodeTestCase.assertAstEquals(expectedClass.getCompilationUnit(), actualClass.getCompilationUnit());
    }

    public static void assertAstEquals(Reader expected, Reader actual) {
        SourceClass expectedClass = new SourceClass(new XJavaDoc(), new ReaderFile(expected), true, new XTagFactory(), null);
        SourceClass actualClass = new SourceClass(new XJavaDoc(), new ReaderFile(actual), true, new XTagFactory(), null);
        CodeTestCase.assertAstEquals(expectedClass.getCompilationUnit(), actualClass.getCompilationUnit());
    }

    public static void assertApiEquals(File expected, File actual) {
        CodeTestCase.checkNotDir(expected, actual);
        SourceClass expectedClass = new SourceClass(new XJavaDoc(), expected, false, new XTagFactory());
        SourceClass actualClass = new SourceClass(new XJavaDoc(), actual, false, new XTagFactory());
        CodeTestCase.assertApiEquals(expectedClass, actualClass);
    }

    public static void assertApiEquals(Reader expected, Reader actual) {
        SourceClass expectedClass = new SourceClass(new XJavaDoc(), new ReaderFile(expected), false, new XTagFactory(), null);
        SourceClass actualClass = new SourceClass(new XJavaDoc(), new ReaderFile(actual), false, new XTagFactory(), null);
        CodeTestCase.assertApiEquals(expectedClass, actualClass);
    }

    private static void checkNotDir(File expected, File actual) {
        if (expected.isDirectory()) {
            Assert.fail((String)(expected.getAbsolutePath() + " - should not have been a directory"));
        }
        if (actual.isDirectory()) {
            Assert.fail((String)(actual.getAbsolutePath() + " - should not have been a directory"));
        }
    }

    private static void assertAstEquals(SimpleNode expected, SimpleNode actual) {
        boolean sameNumberOfChildren;
        boolean sameNodeType = expected.getType().equals(actual.getType());
        boolean bl = sameNumberOfChildren = expected.jjtGetNumChildren() == actual.jjtGetNumChildren();
        if (!sameNodeType || !sameNumberOfChildren) {
            StringWriter expectedWriter = new StringWriter();
            NodePrinter.print(expected, expectedWriter);
            StringWriter actualWriter = new StringWriter();
            NodePrinter.print(actual, actualWriter);
            Assert.assertEquals((String)expectedWriter.toString(), (String)expectedWriter.toString(), (String)actualWriter.toString());
        }
        int i = 0;
        while (i < expected.jjtGetNumChildren()) {
            SimpleNode expectedChild = (SimpleNode)expected.jjtGetChild(i);
            SimpleNode actualChild = (SimpleNode)actual.jjtGetChild(i);
            CodeTestCase.assertAstEquals(expectedChild, actualChild);
            ++i;
        }
    }

    private static void assertApiEquals(SourceClass expected, SourceClass actual) {
        Assert.assertEquals((String)"Package names should be equal", (String)expected.getContainingPackage().getName(), (String)actual.getContainingPackage().getName());
        CodeTestCase.assertModifiersEqual("Class modifiers should be equal", expected, actual);
        CodeTestCase.assertNameEquals("Class names should be equal", expected, actual);
        CodeTestCase.assertSuperclassEquals(expected, actual);
        CodeTestCase.assertInterfacesEqual(expected, actual);
        CodeTestCase.assertFieldsEqual(expected, actual);
        CodeTestCase.assertConstructorsEqual(expected, actual);
        CodeTestCase.assertMethodsEqual(expected, actual);
    }

    private static void assertFieldsEqual(XClass expected, XClass actual) {
        Assert.assertEquals((String)"Number of fields should be equal", (int)expected.getFields().size(), (int)actual.getFields().size());
        Iterator expectedFields = expected.getFields().iterator();
        Iterator actualFields = actual.getFields().iterator();
        while (expectedFields.hasNext()) {
            XField expectedField = (XField)expectedFields.next();
            XField actualField = (XField)actualFields.next();
            CodeTestCase.assertFieldEquals(expectedField, actualField);
        }
    }

    private static void assertConstructorsEqual(XClass expected, XClass actual) {
        Assert.assertEquals((String)"Number of constructors should be equal", (int)expected.getConstructors().size(), (int)actual.getConstructors().size());
        Iterator expectedConstructors = expected.getConstructors().iterator();
        Iterator actualConstructors = actual.getConstructors().iterator();
        while (expectedConstructors.hasNext()) {
            XConstructor expectedConstructor = (XConstructor)expectedConstructors.next();
            XConstructor actualConstructor = (XConstructor)actualConstructors.next();
            CodeTestCase.assertConstructorEquals(expectedConstructor, actualConstructor);
        }
    }

    private static void assertMethodsEqual(XClass expected, XClass actual) {
        Assert.assertEquals((String)"Number of methods should be equal", (int)expected.getMethods().size(), (int)actual.getMethods().size());
        Iterator expectedMethods = expected.getMethods().iterator();
        Iterator actualMethods = actual.getMethods().iterator();
        while (expectedMethods.hasNext()) {
            XMethod expectedMethod = (XMethod)expectedMethods.next();
            XMethod actualMethod = (XMethod)actualMethods.next();
            CodeTestCase.assertMethodEquals(expectedMethod, actualMethod);
        }
    }

    private static void assertFieldEquals(XField expected, XField actual) {
        CodeTestCase.assertTypeEquals("Field types should be equal", expected, actual);
        CodeTestCase.assertNameEquals("Field names should be equal", expected, actual);
        CodeTestCase.assertModifiersEqual("Field modifiers should be equal", expected, actual);
    }

    private static void assertConstructorEquals(XConstructor expected, XConstructor actual) {
        CodeTestCase.assertNameEquals("Constructor names should be equal", expected, actual);
        CodeTestCase.assertModifiersEqual("Constructor modifiers should be equal", expected, actual);
        CodeTestCase.assertNameWithSignatureEquals("Constructor signatures should be equal", expected, actual);
        CodeTestCase.assertParametersEqual("Constructor parameters should be equal", expected, actual);
        CodeTestCase.assertThrownExceptionsEqual("Constructor exceptions should be equal", expected, actual);
    }

    private static void assertMethodEquals(XMethod expected, XMethod actual) {
        CodeTestCase.assertTypeEquals("Method types should be equal", expected.getReturnType(), actual.getReturnType());
        CodeTestCase.assertNameEquals("Method names should be equal", expected, actual);
        CodeTestCase.assertModifiersEqual("Method modifiers should be equal", expected, actual);
        CodeTestCase.assertNameWithSignatureEquals("Method signatures should be equal", expected, actual);
        CodeTestCase.assertParametersEqual("Method parameters should be equal", expected, actual);
        CodeTestCase.assertThrownExceptionsEqual("Method exceptions should be equal", expected, actual);
    }

    private static void assertParameterEquals(XParameter expected, XParameter actual) {
        CodeTestCase.assertTypeEquals("Parameter types should be equal", expected, actual);
        CodeTestCase.assertNameEquals("Parameter names should be equal", expected, actual);
    }

    private static void assertTypeEquals(String msg, Type expected, Type actual) {
        Assert.assertEquals((String)msg, (String)expected.getType().getQualifiedName(), (String)actual.getType().getQualifiedName());
        Assert.assertEquals((String)msg, (String)expected.getDimensionAsString(), (String)actual.getDimensionAsString());
    }

    private static void assertNameEquals(String msg, Named expected, Named actual) {
        Assert.assertEquals((String)msg, (String)expected.getName(), (String)actual.getName());
    }

    private static void assertSuperclassEquals(SourceClass expected, SourceClass actual) {
        String expectedSuperclass = expected.getSuperclass() != null ? expected.getSuperclass().getQualifiedName() : null;
        String actualSuperclass = actual.getSuperclass() != null ? actual.getSuperclass().getQualifiedName() : null;
        Assert.assertEquals((String)"Superclass is equal", (String)expectedSuperclass, (String)actualSuperclass);
    }

    private static void assertInterfacesEqual(SourceClass expected, SourceClass actual) {
        Assert.assertEquals((String)"Implemented interfaces should be equal", (int)expected.getDeclaredInterfaces().size(), (int)actual.getDeclaredInterfaces().size());
        Iterator declaredInterfaces = expected.getDeclaredInterfaces().iterator();
        while (declaredInterfaces.hasNext()) {
            XClass declaredInterface = (XClass)declaredInterfaces.next();
            Assert.assertTrue((String)("Implements " + declaredInterface.getQualifiedName()), (boolean)actual.isA(declaredInterface.getQualifiedName()));
        }
    }

    private static void assertModifiersEqual(String msg, XProgramElement expected, XProgramElement actual) {
        Assert.assertEquals((String)msg, (String)expected.getModifiers(), (String)actual.getModifiers());
    }

    private static void assertNameWithSignatureEquals(String msg, XExecutableMember expected, XExecutableMember actual) {
        Assert.assertEquals((String)msg, (String)expected.getNameWithSignature(false), (String)actual.getNameWithSignature(false));
    }

    private static void assertParametersEqual(String msg, XExecutableMember expected, XExecutableMember actual) {
        Assert.assertEquals((String)msg, (int)expected.getParameters().size(), (int)actual.getParameters().size());
        Iterator expectedParameters = expected.getParameters().iterator();
        Iterator actualParameters = actual.getParameters().iterator();
        while (expectedParameters.hasNext()) {
            XParameter expectedParameter = (XParameter)expectedParameters.next();
            XParameter actualParameter = (XParameter)actualParameters.next();
            CodeTestCase.assertParameterEquals(expectedParameter, actualParameter);
        }
    }

    private static void assertThrownExceptionsEqual(String msg, XExecutableMember expected, XExecutableMember actual) {
        Assert.assertEquals((String)msg, (int)expected.getThrownExceptions().size(), (int)actual.getThrownExceptions().size());
        Iterator expectedThrownExceptions = expected.getThrownExceptions().iterator();
        while (expectedThrownExceptions.hasNext()) {
            XClass expectedThrownException = (XClass)expectedThrownExceptions.next();
            Assert.assertTrue((String)("Throws " + expectedThrownException.getQualifiedName()), (boolean)actual.throwsException(expectedThrownException.getQualifiedName()));
        }
    }

    protected File getDir() {
        return new File(((Object)((Object)this)).getClass().getResource("/" + ((Object)((Object)this)).getClass().getName().replace('.', '/') + ".class").getFile()).getParentFile();
    }

    protected File getRootDir() {
        File dir = this.getDir();
        StringTokenizer st = new StringTokenizer(((Object)((Object)this)).getClass().getName(), ".");
        int i = 0;
        while (i < st.countTokens() - 1) {
            dir = dir.getParentFile();
            ++i;
        }
        return dir;
    }

    protected XJavaDoc getXJavaDoc() {
        return new XJavaDoc();
    }
}

