package org.apache.slide.projector.constraints;

import org.apache.commons.xmlio.out.XMLEncode;
import org.apache.commons.xmlio.out.XMLStringWriter;
import org.apache.commons.xmlio.out.XMLWriter;

public abstract class AbstractValueFactory implements ConstraintsFactory {
    public String getContentType(Object value) {
        return value.getClass().getName();
    }
    
    public void save(Object value, XMLStringWriter writer) {
        writer.writeElementWithPCData(XMLWriter.createStartTag(getElementName()), XMLEncode.xmlEncodeText(String.valueOf(value)), XMLWriter.createEndTag(getElementName()));
    }
}
