package org.apache.slide.projector.constraints;

import org.apache.commons.contract.constraints.BooleanConstraints;
import org.apache.commons.contract.constraints.Constraints;
import org.jdom.Element;

public class BooleanFactory extends AbstractValueFactory {
	public Class getValueClass() {
		return Boolean.class;
	}
	
	public String getElementName() {
    	return "boolean";
    }
    
	public Object load(Element element) {
		return Boolean.valueOf(element.getText());
	}

    public Constraints loadDescriptor(Element element) {
    	return new BooleanConstraints();
    }
}