package org.apache.slide.projector.constraints;

import java.util.Date;

import org.apache.commons.contract.constraints.Constraints;
import org.apache.commons.contract.constraints.DateConstraints;
import org.jdom.Element;

public class DateFactory extends AbstractValueFactory {
	public Class getValueClass() {
		return Date.class;
	}
	
	public String getElementName() {
    	return "date";
    }

	public Object load(Element element) {
		return new Date(Long.valueOf(element.getText()).longValue());
	}

    public Constraints loadDescriptor(Element element) {
    	DateConstraints valueDescriptor = new DateConstraints();
        String earliest = element.getAttributeValue("earliest");
        String latest = element.getAttributeValue("latest");
        String formatPattern = element.getAttributeValue("formatPattern");
        if ( earliest != null ) valueDescriptor.setEarliest(new Date(Long.valueOf(earliest).longValue()));
        if ( latest != null ) valueDescriptor.setLatest(new Date(Long.valueOf(latest).longValue()));
        if ( formatPattern != null ) valueDescriptor.setFormatPattern(formatPattern);
    	return valueDescriptor;
    }
}