package org.apache.slide.projector.constraints;

import java.util.Locale;

import org.apache.commons.contract.constraints.Constraints;
import org.apache.commons.contract.constraints.LocaleConstraints;
import org.jdom.Element;

public class LocaleFactory extends AbstractValueFactory {
	public Class getValueClass() {
		return Locale.class;
	}
	
	public String getElementName() {
    	return "locale";
    }

	public Object load(Element element) {
		return new Locale(element.getText());
	}
    
    public Constraints loadDescriptor(Element element) {
    	return new LocaleConstraints();
    }
}