package org.apache.slide.projector.constraints;

import org.apache.commons.contract.Context;
import org.apache.commons.contract.constraints.CastException;
import org.apache.commons.contract.constraints.Constraints;
import org.apache.commons.contract.constraints.StringConstraints;
import org.apache.commons.contract.constraints.ValidationException;
import org.apache.commons.i18n.LocalizedError;
import org.apache.commons.i18n.LocalizedText;
import org.apache.slide.projector.value.MessageValue;

public class MessageConstraints implements Constraints {
	public Object cast(Object value, Context context) throws CastException {
        if ( value instanceof MessageValue ) {
            return (MessageValue)value;
        } else {
        	try {
        		return new MessageValue((StringConstraints.UNCONSTRAINED.cast(value, null).toString()));
        	} catch ( CastException exception ) {
                throw new CastException(new LocalizedError("uncastableMessageValue", new Object[] { value }));
        	}
        }
    }

	public void validate(Object value, Context context) throws ValidationException {
    }

    public LocalizedText verboseConstraints() {
        // TODO Auto-generated method stub
        return null;
    }
}