package org.apache.slide.projector.constraints;

import java.util.Iterator;
import java.util.List;

import org.apache.commons.contract.constraints.Constraints;
import org.apache.slide.projector.value.Text;
import org.jdom.Element;

public class TextFactory extends AbstractValueFactory {
	public Class getValueClass() {
		return Text.class;
	}
	
	public String getElementName() {
    	return "text";
    }
    
	public Object load(Element element) {
		return element.getText();
	}
	
	public Constraints loadDescriptor(Element element) {
        TextConstraints textConstraints = new TextConstraints();
        List allowedValueElements = element.getChildren("allowed-content-type");
        for ( Iterator i = allowedValueElements.iterator(); i.hasNext(); ) {
            Element allowedValueElement = (Element)i.next(); 
            String allowedValue = allowedValueElement.getTextTrim(); 
            textConstraints.addAllowedContentType(allowedValue);
        }
        return textConstraints;
    }

    public String getContentType(Object value) {
        return ((Text)value).getContentType();
    }
}