package org.apache.slide.projector.constraints;

import org.apache.commons.contract.Context;
import org.apache.commons.contract.constraints.CastException;
import org.apache.commons.contract.constraints.Constraints;
import org.apache.commons.contract.constraints.StringConstraints;
import org.apache.commons.contract.constraints.ValidationException;
import org.apache.commons.i18n.LocalizedError;
import org.apache.commons.i18n.LocalizedText;
import org.apache.slide.projector.value.URI;
import org.apache.slide.projector.value.URIValue;

public class URIConstraints implements Constraints {
	public static final URIConstraints UNCONSTRAINED = new URIConstraints();;

    public Object cast(Object value, Context context) throws CastException {
        if ( value instanceof URI ) {
            return value;
        } else {
        	try {
                return new URIValue((String)StringConstraints.UNCONSTRAINED.cast(value, null));
            } catch ( CastException exception ) {
            	throw new CastException(new LocalizedError("uncastableUriValue", new Object[] { value }), exception);
            }
        }
	}
	
	public void validate(Object value, Context context) throws ValidationException {
    }

    /* (non-Javadoc)
     * @see org.apache.commons.contract.constraints.Constraints#verboseConstraints()
     */
    public LocalizedText verboseConstraints() {
        // TODO Auto-generated method stub
        return null;
    }    
}