package org.apache.slide.projector.constraints;

import org.apache.commons.contract.constraints.Constraints;
import org.apache.slide.projector.value.URIValue;
import org.jdom.Element;

public class URIFactory extends AbstractValueFactory {
	public Class getValueClass() {
		return URIValue.class;
	}
	
	public String getElementName() {
    	return "uri";
    }

	public Object load(Element element) {
		return new URIValue(element.getText());
	}
    
    public Constraints loadDescriptor(Element element) {
    	return new URIConstraints();
    }
}