package org.apache.slide.projector.context;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.contract.Store;
import org.apache.commons.contract.StoreException;
import org.apache.commons.httpclient.Credentials;
import org.apache.slide.projector.Projector;
import org.apache.slide.projector.store.CookieStore;
import org.apache.slide.projector.store.FormStore;
import org.apache.slide.projector.store.RequestAttributeStore;
import org.apache.slide.projector.store.RequestHeaderStore;
import org.apache.slide.projector.store.RequestParameterStore;
import org.apache.slide.projector.store.SessionStore;
import org.apache.slide.projector.value.Streamable;
import org.apache.slide.projector.value.URI;

public class HttpContext extends SystemContext {
    private final static String CREDENTIALS = "credentials";

    private Streamable resource;
    private SessionStore sessionStore;
    private RequestAttributeStore requestAttributeStore;
    private RequestParameterStore requestParameterStore;
    private RequestHeaderStore requestHeaderStore;
    private CookieStore cookieStore;
    private FormStore formStore;
    private String contextPath;

    public HttpContext(HttpServletRequest request, HttpServletResponse response) {
        super(Projector.getCredentials());
        this.contextPath = request.getContextPath()+request.getServletPath();
        sessionStore = new SessionStore(request);
        formStore = new FormStore(this, sessionStore);
        requestAttributeStore = new RequestAttributeStore(request);
        requestParameterStore = new RequestParameterStore(request);
        requestHeaderStore = new RequestHeaderStore(request);
        cookieStore = new CookieStore(request, response);
    }

    public void setCredentials(Credentials credentials) {
        sessionStore.put(CREDENTIALS, credentials, Projector.getSystemContext());
    }

    public Credentials getCredentials() {
        Credentials credentials = (Credentials)sessionStore.get(CREDENTIALS, Projector.getSystemContext());
        if ( credentials == null ) {
            credentials = Projector.getCredentials();            
        }
        return credentials;
    }

    public Store getStore(String store) {
        if ( store.equals(SessionStore.ID ) ) {
            return sessionStore;
        } else if ( store.equals(RequestParameterStore.ID ) ) {
            return requestParameterStore;
        } else if ( store.equals(RequestAttributeStore.ID ) ) {
            return requestAttributeStore;
        } else if ( store.equals(RequestHeaderStore.ID ) ) {
            return requestHeaderStore;
        } else if ( store.equals(CookieStore.ID ) ) {
            return cookieStore;
        } else if ( store.equals(FormStore.ID ) ) {
            return formStore;
        }  
        return super.getStore(store);
    }

    public String getContextPath() {
        return contextPath;
    }

    public void setPresentableResource(Streamable resource) {
        this.resource = resource;
    }

    public Streamable getPresentableResource() {
        return resource;
    }

    public void setBookmark(URI processor) throws StoreException {
    	sessionStore.put(BOOKMARK, processor, this);
    }
    
    public URI getBookmark() throws StoreException {
    	return (URI)sessionStore.get(BOOKMARK, this);
    }
}