package org.apache.slide.projector.context;

import java.util.Map;

import org.apache.commons.contract.Store;
import org.apache.commons.contract.StoreException;
import org.apache.commons.httpclient.Credentials;
import org.apache.slide.projector.Projector;
import org.apache.slide.projector.store.Cache;
import org.apache.slide.projector.store.ProcessStore;
import org.apache.slide.projector.store.RepositoryStore;
import org.apache.slide.projector.value.URI;

public class SystemContext extends AbstractContext {
    protected final static String BOOKMARK = "_bookmark_";
    protected Store stepStore;
	
	private Credentials credentials;
    private Cache contextStore = new Cache();
	private RepositoryStore repositoryStore = new RepositoryStore(this);
    private ProcessStore transientProcessStore = new ProcessStore(Cache.getInstance());
    private ProcessStore persistentProcessStore = new ProcessStore(repositoryStore);
    private Cache inputParameterStore = new Cache();
    
    public SystemContext(Credentials credentials) {
        this.credentials = credentials;
    }
    
    public Store getStore(String store) {
        if ( store.equals(Projector.CACHE_STORE) ) {
            return Cache.getInstance();
        } else if ( store.equals(Projector.CONTEXT_STORE) ) {
            return contextStore;
        } else if ( store.equals(Projector.REPOSITORY_STORE) ) {
            return repositoryStore;
        } else if ( store.equals(Projector.TRANSIENT_PROCESS_STORE) ) {
            return transientProcessStore;
        } else if ( store.equals(Projector.PERSISTENT_PROCESS_STORE) ) {
            return persistentProcessStore;
        } else if ( store.equals(Projector.INPUT_STORE) ) {
            return inputParameterStore;
        } else if ( store.equals(Projector.STEP_STORE) ) {
            return stepStore;
        } 
        return null;
    }

    public void setCredentials(Credentials credentials) {
    	this.credentials = credentials;
    }
    
    public Credentials getCredentials() {
        return credentials;
    }

    public void setProcessId(String processId) {
    	transientProcessStore.setProcessId(processId);
    	persistentProcessStore.setProcessId(processId);
    }
    
    public String getProcessId() {
    	return transientProcessStore.getProcessId();
    }

    public void setBookmark(URI processor) throws StoreException {
    	transientProcessStore.put(BOOKMARK, processor, this);
    }
    
    public URI getBookmark() throws StoreException {
    	return (URI)transientProcessStore.get(BOOKMARK, this);
    }

    public void setStepStore(Store store) {
    	this.stepStore = store;
    }

    public void setInputParameters(Map parameters) {
    	inputParameterStore.setMap(parameters);
    }
}