package org.apache.slide.projector.processor;

import org.apache.commons.contract.Processor;
import org.apache.slide.projector.value.Streamable;

public interface ConfigurableProcessor extends Processor {
    /**
     * This method is called before the first invokation of the process method
     * occurs.
     *
     * @param config the resource containing the configuration of the processor
     * @throws ConfigurationException is thrown, if the processor
     *                                could not be configured properly by the given resource
     */
    void configure(Streamable config) throws ConfigurationException;
}