package org.apache.slide.projector.processor;

import java.util.Locale;
import java.util.Map;

import org.apache.commons.contract.Context;
import org.apache.commons.contract.EnvironmentConsumer;
import org.apache.commons.contract.Processor;
import org.apache.commons.contract.Result;
import org.apache.commons.contract.constraints.ArrayConstraints;
import org.apache.commons.contract.constraints.LocaleConstraints;
import org.apache.commons.contract.constraints.StringConstraints;
import org.apache.commons.contract.descriptor.ParameterDescriptor;
import org.apache.commons.contract.descriptor.RequiredEnvironmentDescriptor;
import org.apache.commons.contract.descriptor.ResultDescriptor;
import org.apache.commons.contract.descriptor.ResultEntryDescriptor;
import org.apache.commons.contract.descriptor.StateDescriptor;
import org.apache.commons.contract.i18n.ParameterMessage;
import org.apache.commons.i18n.LocalizedMessage;
import org.apache.commons.i18n.MessageManager;
import org.apache.slide.projector.Projector;

public class Message implements Processor, EnvironmentConsumer {
    private final static String ID = "id";
    private final static String KEY = "key";
    private final static String ARGUMENTS = "arguments";
    private final static String LOCALE = "locale";

    private final static String DEFAULT_KEY = "text";

    private final static ParameterDescriptor[] parameterDescriptors = new ParameterDescriptor[]{
    		new ParameterDescriptor(ID, new ParameterMessage("message/parameter/id"), new StringConstraints()),
    		new ParameterDescriptor(KEY, new ParameterMessage("message/parameter/key"), new StringConstraints(), DEFAULT_KEY),
    		new ParameterDescriptor(ARGUMENTS, new ParameterMessage("message/parameter/arguments"), new ArrayConstraints(new StringConstraints()), new String[] { "" })
    };

    private final static RequiredEnvironmentDescriptor[] requiredEnvironmentDescriptors = new RequiredEnvironmentDescriptor[] {
    		new RequiredEnvironmentDescriptor(LOCALE, Projector.SESSION_STORE, new ParameterMessage("message/requiredEnvironment/locale"), new LocaleConstraints(), Locale.getDefault())
    };
    
    private final static ResultDescriptor[] resultDescriptors = new ResultDescriptor[]{
            new ResultDescriptor(
            StateDescriptor.OK_DESCRIPTOR,
            new ResultEntryDescriptor[]{new ResultEntryDescriptor(
                    SimpleProcessor.OUTPUT, new LocalizedMessage("message/result/output"),
                    StringConstraints.UNCONSTRAINED)})};

    public Result process(Map parameter, Context context) throws Exception {
        String id = parameter.get(ID).toString();
        String key = parameter.get(KEY).toString();
        Object[] arguments = (Object [])parameter.get(ARGUMENTS);
        Locale locale = (Locale)context.getStore(Projector.SESSION_STORE).get(LOCALE, context);
        return new Result(StateDescriptor.OK, SimpleProcessor.OUTPUT, new String(MessageManager.getText(id, key, arguments, locale, id)));
    }

    public ParameterDescriptor[] getParameterDescriptors() {
        return parameterDescriptors;
    }

    public ResultDescriptor[] getResultDescriptors() {
        return resultDescriptors;
    }

	public RequiredEnvironmentDescriptor[] getRequiredEnvironmentDescriptors() {
		return requiredEnvironmentDescriptors;
	}
}