package org.apache.slide.projector.processor;

import java.util.Locale;

import org.apache.commons.i18n.LocalizedError;

public class ProcessException extends Exception {
    private LocalizedError errorMessage;

    public ProcessException(LocalizedError errorMessage, Throwable throwable) {
        super(errorMessage.getSummary(Locale.getDefault(), throwable.getMessage()), throwable);
        this.errorMessage = errorMessage;
    }

    public ProcessException(LocalizedError errorMessage) {
        super(errorMessage.getSummary(Locale.getDefault(), "no message available"));
        this.errorMessage = errorMessage;
    }

    public LocalizedError getLocalizedError() {
        return errorMessage;
    }
}