/*
 * $Header: /home/cvspublic/jakarta-slide/projector/src/java/org/apache/slide/projector/processor/Router.java,v 1.5 2004/11/28 13:54:06 dflorey Exp $
 * $Revision: 1.5 $
 * $Date: 2004/11/28 13:54:06 $
 *
 * ====================================================================
 *
 * Copyright 2004 The Apache Software Foundation 
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */

package org.apache.slide.projector.processor;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

import org.apache.commons.contract.Context;
import org.apache.commons.contract.Result;
import org.apache.commons.contract.constraints.StringConstraints;
import org.apache.commons.contract.descriptor.ParameterDescriptor;
import org.apache.commons.contract.descriptor.ResultDescriptor;
import org.apache.commons.contract.descriptor.StateDescriptor;
import org.apache.commons.contract.i18n.ParameterMessage;
import org.apache.commons.i18n.LocalizedMessage;
import org.apache.commons.xmlio.in.DefaultSimpleImportHandler;
import org.apache.commons.xmlio.in.SimpleImporter;
import org.apache.commons.xmlio.in.SimplePath;
import org.apache.slide.projector.value.Streamable;
import org.apache.slide.projector.value.Text;
import org.xml.sax.InputSource;
import org.xml.sax.helpers.AttributesImpl;

/**
 * The Router class
 * 
 */
public class Router implements ConfigurableProcessor {
    private static Logger logger = Logger.getLogger(Router.class.getName());

    private static ResultDescriptor[] resultDescriptors;
    private static ParameterDescriptor []parameterDescriptors;
    private Map routes = new HashMap();

    public Result process(Map parameter, Context context) throws Exception {
        String value = ((Text)parameter.get(SimpleProcessor.INPUT)).toString();
        return new Result((String)routes.get(value));
    }

    public ParameterDescriptor[] getParameterDescriptors() {
        return parameterDescriptors;
    }

    public ResultDescriptor[] getResultDescriptors() {
        return resultDescriptors;
    }

    public void configure(Streamable config) throws ConfigurationException {
        try {
            InputStream configuration = config.getInputStream();
            SimpleImporter importer = new SimpleImporter();
            ConfigurationHandler handler = new ConfigurationHandler();
            importer.addSimpleImportHandler(handler);
            importer.parse(new InputSource(configuration));
            parameterDescriptors = new ParameterDescriptor[] {
                new ParameterDescriptor(SimpleProcessor.INPUT, new ParameterMessage(handler.getDescription()), handler.getValueDesriptor())
            };
            resultDescriptors = handler.getResultDescriptors();
        } catch (Exception exception) {
            logger.log(Level.SEVERE, "Error while parsing router configuration", exception);
        }
    }

    public class ConfigurationHandler extends DefaultSimpleImportHandler {
        private StringConstraints valueDesriptor = new StringConstraints();
        private List results = new ArrayList();
        private String description;

        public void startElement(SimplePath path, String name, AttributesImpl attributes, String leadingCDdata) {
            if (path.matches("routes")) {
                description = attributes.getValue("description");
            } else if (path.matches("route")) {
                String value = attributes.getValue("value");
                String description = attributes.getValue("description");
                String state = attributes.getValue("state");
                valueDesriptor.addAllowedValue(value);
                results.add(new ResultDescriptor(new StateDescriptor(value, new LocalizedMessage(description))));
                routes.put(value, state);
            }
        }

        public StringConstraints getValueDesriptor() {
            return valueDesriptor;
        }

        public String getDescription() {
            return description;
        }

        public ResultDescriptor[] getResultDescriptors() {
            return (ResultDescriptor[])results.toArray(new ResultDescriptor[results.size()]);
        }
    }
}