package org.apache.slide.projector.processor.access;

import org.apache.commons.contract.Context;
import org.apache.commons.contract.descriptor.ParameterDescriptor;
import org.apache.commons.contract.descriptor.ResultEntryDescriptor;
import org.apache.commons.contract.i18n.ParameterMessage;
import org.apache.commons.i18n.LocalizedMessage;
import org.apache.slide.projector.Projector;
import org.apache.slide.projector.constraints.TextConstraints;
import org.apache.slide.projector.constraints.URIConstraints;
import org.apache.slide.projector.context.ProjectorContext;
import org.apache.slide.projector.processor.SimpleProcessor;
import org.apache.slide.projector.value.URI;
import org.apache.slide.projector.value.URIValue;

public class Get extends SimpleProcessor {
    public Object process(Object input, Context context) throws Exception {
        URI uri = new URIValue(input.toString());
        return Projector.getRepository().getResource(uri, ((ProjectorContext)context).getCredentials());
    }

    public ParameterDescriptor getParameterDescriptor() {
        return new ParameterDescriptor(INPUT, new ParameterMessage("simpleProcessor/parameter/input"), new URIConstraints());
    }

    public ResultEntryDescriptor getResultEntryDescriptor() {
        return new ResultEntryDescriptor(OUTPUT, new LocalizedMessage("simpleProcessor/result/output"), 
                TextConstraints.UNCONSTRAINED);
    }
}