/*
 * $Header: /home/cvspublic/jakarta-slide/projector/src/java/org/apache/slide/projector/processor/access/Remove.java,v 1.6 2004/11/28 13:54:07 dflorey Exp $
 * $Revision: 1.6 $
 * $Date: 2004/11/28 13:54:07 $
 *
 * ====================================================================
 *
 * Copyright 2004 The Apache Software Foundation 
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */

package org.apache.slide.projector.processor.access;

import java.util.Map;

import org.apache.commons.contract.Context;
import org.apache.commons.contract.Processor;
import org.apache.commons.contract.Result;
import org.apache.commons.contract.Store;
import org.apache.commons.contract.constraints.StringConstraints;
import org.apache.commons.contract.descriptor.ParameterDescriptor;
import org.apache.commons.contract.descriptor.ResultDescriptor;
import org.apache.commons.contract.i18n.ParameterMessage;
import org.apache.slide.projector.Projector;

/**
 * The Event class
 * 
 */
public class Remove implements Processor {
    public final static String STORE = "store";
    public final static String KEY = "key";

    private final static ParameterDescriptor[] parameterDescriptors = new ParameterDescriptor[] {
        new ParameterDescriptor(STORE, new ParameterMessage("put/parameter/store"), new StringConstraints(Projector.STORES), Projector.REPOSITORY_STORE),
        new ParameterDescriptor(KEY, new ParameterMessage("put/parameter/key"), new StringConstraints()),
    };
    private final static ResultDescriptor[] resultDescriptors = new ResultDescriptor[] {
            ResultDescriptor.OK
    };

    public Result process(Map parameter, Context context) throws Exception {
    	String storeId = parameter.get(STORE).toString();
    	String key = parameter.get(KEY).toString();
    	Store store = context.getStore(storeId);
    	store.dispose(key, context);
    	return Result.OK;
    }

    public ParameterDescriptor[] getParameterDescriptors() {
        return parameterDescriptors;
    }

    public ResultDescriptor[] getResultDescriptors() {
        return resultDescriptors;
    }
}