package org.apache.slide.projector.processor.core;

import java.util.Map;
import java.util.logging.Logger;

import org.apache.commons.contract.Context;
import org.apache.commons.contract.Processor;
import org.apache.commons.contract.Result;
import org.apache.commons.contract.Store;
import org.apache.commons.contract.constraints.StringConstraints;
import org.apache.commons.contract.descriptor.ParameterDescriptor;
import org.apache.commons.contract.descriptor.ResultDescriptor;
import org.apache.commons.contract.descriptor.StateDescriptor;
import org.apache.commons.contract.i18n.ParameterMessage;
import org.apache.commons.i18n.LocalizedError;
import org.apache.slide.projector.Projector;
import org.apache.slide.projector.processor.ProcessException;

public class Dispose implements Processor {
    private static Logger logger = Logger.getLogger(Dispose.class.getName());

    public final static String STORE = "store";
    public final static String KEY = "key";

    private final static ParameterDescriptor[] parameterDescriptor = new ParameterDescriptor[]{
            new ParameterDescriptor(STORE, new ParameterMessage("dispose/parameter/store"), new StringConstraints(Projector.STORES)),
            new ParameterDescriptor(KEY, new ParameterMessage("dispose/parameter/key"), new StringConstraints())
        };

    private final static ResultDescriptor[] resultDescriptors = new ResultDescriptor[] {
            ResultDescriptor.OK
    };

    public Result process(Map parameter, Context context) throws Exception {
        String name = (String)parameter.get(STORE);
        String key = (String)parameter.get(KEY);
        Store store = context.getStore(name);
        if ( store == null ) {
            throw new ProcessException(new LocalizedError("storeNotAvailable", new String[] {name}));
        }
        store.dispose(key, context);
        return new Result( StateDescriptor.OK );
    }

    public ParameterDescriptor[] getParameterDescriptors() {
        return parameterDescriptor;
    }


    public ResultDescriptor[] getResultDescriptors() {
        return resultDescriptors;
    }
}