package org.apache.slide.projector.processor.core;

import org.apache.commons.contract.Context;
import org.apache.commons.contract.descriptor.ParameterDescriptor;
import org.apache.commons.contract.descriptor.ResultEntryDescriptor;
import org.apache.commons.contract.i18n.ParameterMessage;
import org.apache.commons.i18n.LocalizedMessage;
import org.apache.slide.projector.constraints.AnyConstraints;
import org.apache.slide.projector.processor.SimpleProcessor;

public class Echo extends SimpleProcessor {
    public Object process(Object input, Context context) throws Exception {
        return input;
    }

    public ParameterDescriptor getParameterDescriptor() {
        return new ParameterDescriptor(INPUT, new ParameterMessage("echo/parameter/input"), new AnyConstraints());
    }

    public ResultEntryDescriptor getResultEntryDescriptor() {
        return new ResultEntryDescriptor(OUTPUT, new LocalizedMessage("echo/result/output"), AnyConstraints.UNCONSTRAINED);
    }
}