/*
 * $Header: /home/cvspublic/jakarta-slide/projector/src/java/org/apache/slide/projector/processor/core/Event.java,v 1.6 2004/11/28 13:54:06 dflorey Exp $
 * $Revision: 1.6 $
 * $Date: 2004/11/28 13:54:06 $
 *
 * ====================================================================
 *
 * Copyright 2004 The Apache Software Foundation 
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */

package org.apache.slide.projector.processor.core;

import java.util.Map;

import org.apache.commons.contract.Context;
import org.apache.commons.contract.Processor;
import org.apache.commons.contract.Result;
import org.apache.commons.contract.constraints.BooleanConstraints;
import org.apache.commons.contract.constraints.MapConstraints;
import org.apache.commons.contract.descriptor.ParameterDescriptor;
import org.apache.commons.contract.descriptor.ResultDescriptor;
import org.apache.commons.contract.descriptor.StateDescriptor;
import org.apache.commons.contract.i18n.ParameterMessage;
import org.apache.slide.projector.Projector;
import org.apache.slide.projector.context.ProjectorContext;

/**
 * The Event class
 * 
 */
public class Event implements Processor {
    public final static String INFORMATION = "information";
    public final static String VETOABLE = "vetoable";

    private final static ParameterDescriptor[] parameterDescriptors = new ParameterDescriptor[] {
        new ParameterDescriptor(INFORMATION, new ParameterMessage("event/information"), MapConstraints.UNCONSTRAINED),
        new ParameterDescriptor(VETOABLE, new ParameterMessage("event/vetoable"), new BooleanConstraints(), Boolean.FALSE)
    };
    private final static ResultDescriptor[] resultDescriptors = new ResultDescriptor[] {
            ResultDescriptor.OK
    };

    public Result process(Map parameter, Context context) throws Exception {
        Map information = (Map)parameter.get(INFORMATION);
        boolean vetoable = ((Boolean)parameter.get(VETOABLE)).booleanValue();
        if ( vetoable ) {
            Projector.getRepository().fireVetoableEvent(information, ((ProjectorContext)context).getCredentials());
        } else {
            Projector.getRepository().fireEvent(information, ((ProjectorContext)context).getCredentials());
        }
        return new Result(StateDescriptor.OK);
    }

    public ParameterDescriptor[] getParameterDescriptors() {
        return parameterDescriptors;
    }

    public ResultDescriptor[] getResultDescriptors() {
        return resultDescriptors;
    }
}
