package org.apache.slide.projector.processor.core;

import java.util.Map;
import java.util.logging.Logger;

import org.apache.commons.contract.Context;
import org.apache.commons.contract.Processor;
import org.apache.commons.contract.Result;
import org.apache.commons.contract.descriptor.ParameterDescriptor;
import org.apache.commons.contract.descriptor.ResultDescriptor;
import org.apache.commons.contract.descriptor.StateDescriptor;
import org.apache.commons.contract.i18n.ParameterMessage;
import org.apache.commons.i18n.LocalizedMessage;
import org.apache.slide.projector.constraints.AnyConstraints;

public class Exists implements Processor {
    private static Logger logger = Logger.getLogger(Exists.class.getName());

    public final static String INPUT = "input";

    public final static String TRUE = "true";
    public final static String FALSE = "false";

    private final static ResultDescriptor[] resultDescriptors = new ResultDescriptor[] {
            new ResultDescriptor(new StateDescriptor(TRUE, new LocalizedMessage("exists/state/true"))),
            new ResultDescriptor(new StateDescriptor(FALSE, new LocalizedMessage("exists/state/false")))
        };
	private final static ParameterDescriptor[] parameterDescriptor = new ParameterDescriptor[]{ new ParameterDescriptor(INPUT, new ParameterMessage("exists/input"), new AnyConstraints(), null) };
    
    public Result process(Map parameter, Context context) throws Exception {
        Object input = parameter.get(INPUT);
        if ( input == null ) {
            return new Result(FALSE);
        }
        return new Result(TRUE);
    }

    public ParameterDescriptor[] getParameterDescriptors() {
    	return parameterDescriptor;
    }
    	
    public ResultDescriptor[] getResultDescriptors() {
        return resultDescriptors;
    }
}