/*
 * $Header: /home/cvspublic/jakarta-slide/projector/src/java/org/apache/slide/projector/processor/core/MapEntry.java,v 1.7 2004/11/28 13:54:06 dflorey Exp $
 * $Revision: 1.7 $
 * $Date: 2004/11/28 13:54:06 $
 *
 * ====================================================================
 *
 * Copyright 2004 The Apache Software Foundation 
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */

package org.apache.slide.projector.processor.core;

import java.util.Map;

import org.apache.commons.contract.Context;
import org.apache.commons.contract.Processor;
import org.apache.commons.contract.Result;
import org.apache.commons.contract.constraints.MapConstraints;
import org.apache.commons.contract.constraints.StringConstraints;
import org.apache.commons.contract.descriptor.ParameterDescriptor;
import org.apache.commons.contract.descriptor.ResultDescriptor;
import org.apache.commons.contract.descriptor.ResultEntryDescriptor;
import org.apache.commons.contract.descriptor.StateDescriptor;
import org.apache.commons.contract.i18n.ParameterMessage;
import org.apache.commons.i18n.LocalizedMessage;
import org.apache.slide.projector.constraints.AnyConstraints;
import org.apache.slide.projector.processor.SimpleProcessor;
import org.apache.slide.projector.value.Text;

/**
 * The MapEntry class
 * 
 */
public class MapEntry implements Processor {
    private final static String MAP = "map";
    private final static String KEY = "key";

    private final static String KEY_NOT_FOUND = "keyNotFound";

    private final static ParameterDescriptor[] parameterDescriptors = new ParameterDescriptor[] {
        new ParameterDescriptor(MAP, new ParameterMessage("mapEntry/map"), MapConstraints.UNCONSTRAINED),
        new ParameterDescriptor(KEY, new ParameterMessage("mapEntry/key"), new StringConstraints())
    };

    private final static ResultDescriptor[] resultDescriptor = new ResultDescriptor[] {
            new ResultDescriptor(
            StateDescriptor.OK_DESCRIPTOR, 
            new ResultEntryDescriptor[] {
                    new ResultEntryDescriptor(SimpleProcessor.OUTPUT, new LocalizedMessage("mapEntry/output"), AnyConstraints.UNCONSTRAINED)
            }),
            new ResultDescriptor(new StateDescriptor(KEY_NOT_FOUND, new LocalizedMessage("mapEntry/state/keyNotFound")))
    };

    public Result process(Map parameter, Context context) throws Exception {
        Map map = (Map)parameter.get(MAP);
        String key = ((Text)parameter.get(KEY)).toString();
        Object entry = map.get(key);
        if ( entry == null ) return new Result(KEY_NOT_FOUND);
        return new Result(StateDescriptor.OK, SimpleProcessor.OUTPUT, entry);
    }

    public ParameterDescriptor[] getParameterDescriptors() {
        return parameterDescriptors;
    }

    public ResultDescriptor[] getResultDescriptors() {
        return resultDescriptor;
    }
}
