package org.apache.slide.projector.processor.core;

import java.util.Map;

import org.apache.commons.contract.Context;
import org.apache.commons.contract.Processor;
import org.apache.commons.contract.Result;
import org.apache.commons.contract.constraints.ArrayConstraints;
import org.apache.commons.contract.descriptor.ParameterDescriptor;
import org.apache.commons.contract.descriptor.ResultDescriptor;
import org.apache.commons.contract.descriptor.ResultEntryDescriptor;
import org.apache.commons.contract.descriptor.StateDescriptor;
import org.apache.commons.contract.i18n.ParameterMessage;
import org.apache.commons.i18n.LocalizedMessage;
import org.apache.slide.projector.constraints.URIConstraints;
import org.apache.slide.projector.engine.ProcessorManager;
import org.apache.slide.projector.value.URI;

public class ProcessorReflector implements Processor {
	private final static String PROCESSOR_URI = "processor-uri";
	private final static String PARAMETERS = "parameters";
    private final static String RESULTS = "results";
    private final static String STATES = "states";
    
    private final static ParameterDescriptor[] parameterDescriptors = new ParameterDescriptor[]{
    		new ParameterDescriptor(PROCESSOR_URI, new ParameterMessage("processorReflector/parameter/processor-url"), new URIConstraints())
    };
    
    private final static ResultDescriptor []resultDescriptors = new ResultDescriptor [] {
            new ResultDescriptor(
            StateDescriptor.OK_DESCRIPTOR,
            new ResultEntryDescriptor[]{
                    new ResultEntryDescriptor(PARAMETERS, new LocalizedMessage("processorReflector/result/parameters"),
                    ArrayConstraints.UNCONSTRAINED),
                    new ResultEntryDescriptor(RESULTS, new LocalizedMessage("processorReflector/result/results"),
                    ArrayConstraints.UNCONSTRAINED),
                    new ResultEntryDescriptor(STATES, new LocalizedMessage("processorReflector/result/states"),
                    ArrayConstraints.UNCONSTRAINED)
                    })};

	public Result process(Map parameters, Context context) throws Exception {
		URI processorUri = (URI)parameters.get(PROCESSOR_URI);
        Processor processor = ProcessorManager.getInstance().getProcessor(processorUri);
        ParameterDescriptor[] parameterDescriptor = processor.getParameterDescriptors();
        for ( int i = 0; i < parameterDescriptor.length; i++ ) {
            
        }
        return new Result(StateDescriptor.OK);

	}

	public ParameterDescriptor[] getParameterDescriptors() {
		return parameterDescriptors; 
	}

	public ResultDescriptor[] getResultDescriptors() {
		return resultDescriptors;
	}
}