package org.apache.slide.projector.processor.core;

import org.apache.commons.contract.Context;
import org.apache.commons.contract.constraints.ArrayConstraints;
import org.apache.commons.contract.constraints.StringConstraints;
import org.apache.commons.contract.descriptor.ParameterDescriptor;
import org.apache.commons.contract.descriptor.ResultEntryDescriptor;
import org.apache.commons.contract.i18n.ParameterMessage;
import org.apache.commons.i18n.LocalizedMessage;
import org.apache.slide.projector.processor.SimpleProcessor;

public class StringArrayRenderer extends SimpleProcessor {
    public Object process(Object input, Context context) throws Exception {
        Object[] array = (Object [])input;
        StringBuffer buffer = new StringBuffer(1024);
        for ( int i = 0; i < array.length; i++ ) {
        	buffer.append((String)array[i]);
        }
        return buffer.toString();
    }

    public ParameterDescriptor getParameterDescriptor() {
        return new ParameterDescriptor(INPUT, new ParameterMessage("arrayRenderer/input"), new ArrayConstraints(new StringConstraints()));
    }

    public ResultEntryDescriptor getResultEntryDescriptor() {
        return new ResultEntryDescriptor(OUTPUT, new LocalizedMessage("arrayRenderer/output"), StringConstraints.UNCONSTRAINED);
    }
}