package org.apache.slide.projector.processor.core;

import java.util.Date;
import java.util.Map;

import org.apache.commons.contract.Context;
import org.apache.commons.contract.Processor;
import org.apache.commons.contract.Result;
import org.apache.commons.contract.constraints.DateConstraints;
import org.apache.commons.contract.descriptor.ParameterDescriptor;
import org.apache.commons.contract.descriptor.ResultDescriptor;
import org.apache.commons.contract.descriptor.ResultEntryDescriptor;
import org.apache.commons.contract.descriptor.StateDescriptor;
import org.apache.commons.i18n.LocalizedMessage;

public class System implements Processor {
    private final static String CURRENT_DATE = "currentDate";
    
    private final static ParameterDescriptor[] parameterDescriptors = new ParameterDescriptor[0];
    
    private final static ResultDescriptor []resultDescriptors = new ResultDescriptor [] { 
            new ResultDescriptor(StateDescriptor.OK_DESCRIPTOR,
            new ResultEntryDescriptor[] {
            new ResultEntryDescriptor(CURRENT_DATE, new LocalizedMessage("system/result/currentDate"), DateConstraints.UNCONSTRAINED)})
    };

    public Result process(Map parameter, Context context) throws Exception {
        return new Result(StateDescriptor.OK, CURRENT_DATE, new Date(java.lang.System.currentTimeMillis()));
    }

    public ParameterDescriptor[] getParameterDescriptors() {
        return parameterDescriptors;
    }

    public ResultDescriptor[] getResultDescriptors() {
        return resultDescriptors;
    }
}