package org.apache.slide.projector.processor.core;

import org.apache.commons.contract.Context;
import org.apache.commons.contract.descriptor.ParameterDescriptor;
import org.apache.commons.contract.descriptor.ResultEntryDescriptor;
import org.apache.commons.contract.i18n.ParameterMessage;
import org.apache.commons.i18n.LocalizedError;
import org.apache.commons.i18n.LocalizedMessage;
import org.apache.slide.projector.constraints.AnyConstraints;
import org.apache.slide.projector.constraints.URIConstraints;
import org.apache.slide.projector.context.HttpContext;
import org.apache.slide.projector.processor.ProcessException;
import org.apache.slide.projector.processor.SimpleProcessor;

public class URL extends SimpleProcessor {
    public Object process(Object input, Context context) throws Exception {
        if ( context instanceof HttpContext ) {
            return ((HttpContext)context).getContextPath() + "/" + input.toString();
        } else {
            throw new ProcessException(new LocalizedError("httpContextRequired"));
        }
    }

    public ParameterDescriptor getParameterDescriptor() {
        return new ParameterDescriptor(INPUT, new ParameterMessage("url/parameter/input"), URIConstraints.UNCONSTRAINED);
    }

    public ResultEntryDescriptor getResultEntryDescriptor() {
        return new ResultEntryDescriptor(OUTPUT, new LocalizedMessage("url/result/output"), AnyConstraints.UNCONSTRAINED);
    }
}