package org.apache.slide.projector.processor.form;

import java.util.Map;

import org.apache.commons.contract.Context;
import org.apache.commons.contract.Processor;
import org.apache.commons.contract.Result;
import org.apache.commons.contract.Store;
import org.apache.commons.contract.descriptor.ParameterDescriptor;
import org.apache.commons.contract.descriptor.ResultDescriptor;
import org.apache.commons.contract.descriptor.StateDescriptor;
import org.apache.slide.projector.Projector;
import org.apache.slide.projector.store.FormStore;

public class ClearForm implements Processor {
    private final static ResultDescriptor[] resultDescriptors = new ResultDescriptor[] {
            ResultDescriptor.OK
    };
    
	public Result process(Map parameter, Context context) throws Exception {
		Store formStore = context.getStore(Projector.FORM_STORE);
		if ( formStore != null ) {
			((FormStore)formStore).clear(context);
		}
		return new Result(StateDescriptor.OK);
	}

	public ParameterDescriptor[] getParameterDescriptors() {
		return ParameterDescriptor.NO_PARAMETERS;
	}

	public ResultDescriptor[] getResultDescriptors() {
		return resultDescriptors;
	}
}
